/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.model.Action;
import java.lang.reflect.Field;
import jenkins.model.ModelObjectWithContextMenu;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Restricted(value={NoExternalUse.class})
public class ContextMenuIconUtils {
    private ContextMenuIconUtils() {
        throw new IllegalAccessError("Utility class");
    }

    @NonNull
    public static String buildUrl(String ... segments) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String segment : segments) {
            String str;
            if (segment == null || (str = StringUtils.removeEnd((String)StringUtils.removeStart((String)segment, (String)"/"), (String)"/")).isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                result.append('/');
            }
            result.append(str);
        }
        return result.toString();
    }

    public static void addMenuItem(@NonNull ModelObjectWithContextMenu.ContextMenu menu, @CheckForNull String prefix, @NonNull Action action, @CheckForNull ModelObjectWithContextMenu.ContextMenu subMenu) {
        if (ContextMenuIconUtils.isContextMenuVisible(action) && action.getIconFileName() != null) {
            Icon icon = action instanceof IconSpec ? ContextMenuIconUtils.getIcon(action) : null;
            String base = icon != null ? ContextMenuIconUtils.getQualifiedUrl(icon) : Functions.getIconFilePath((Action)action);
            ModelObjectWithContextMenu.MenuItem item = new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, action.getUrlName()), ContextMenuIconUtils.getMenuItemIconUrl(base), action.getDisplayName());
            item.subMenu = subMenu;
            menu.add(item);
        }
    }

    private static boolean isContextMenuVisible(Action a) {
        if (a instanceof ModelObjectWithContextMenu.ContextMenuVisibility) {
            return ((ModelObjectWithContextMenu.ContextMenuVisibility)a).isVisible();
        }
        return true;
    }

    public static void addMenuItem(@NonNull ModelObjectWithContextMenu.ContextMenu menu, @CheckForNull String prefix, @NonNull Action action) {
        ContextMenuIconUtils.addMenuItem(menu, null, action, null);
    }

    public static void addMenuItem(@NonNull ModelObjectWithContextMenu.ContextMenu menu, @NonNull Action action) {
        ContextMenuIconUtils.addMenuItem(menu, null, action, null);
    }

    @CheckForNull
    public static String getMenuItemIconUrlByClassSpec(@CheckForNull String spec) {
        return ContextMenuIconUtils.getMenuItemIconUrl(ContextMenuIconUtils.getQualifiedUrl(ContextMenuIconUtils.getIconByClassSpec(spec)));
    }

    public static String getMenuItemIconUrl(String url) {
        if (url == null) {
            return null;
        }
        String contextPath = Stapler.getCurrentRequest2().getContextPath();
        return (StringUtils.isBlank((String)contextPath) ? "" : contextPath) + (url.startsWith("images/") ? Functions.getResourcePath() : "") + (String)(url.startsWith("/") ? url : "/" + url);
    }

    @CheckForNull
    public static Icon getIconByClassSpec(String spec) {
        return IconSet.icons.getIconByClassSpec((Object)spec);
    }

    @CheckForNull
    public static Icon getIcon(@NonNull Action action) {
        Icon icon;
        if (action.getIconFileName() == null) {
            return null;
        }
        Icon icon2 = icon = action instanceof IconSpec ? IconSet.icons.getIconByClassSpec((Object)((IconSpec)action).getIconClassName()) : null;
        if (icon == null) {
            icon = IconSet.icons.getIconByClassSpec((Object)IconSet.toNormalizedIconNameClass((Object)action.getIconFileName()));
        }
        if (icon == null) {
            icon = IconSet.icons.getIconByUrl((Object)action.getIconFileName());
        }
        return icon;
    }

    @CheckForNull
    public static String getQualifiedUrl(@CheckForNull Icon icon) {
        if (icon == null) {
            return null;
        }
        try {
            Field iconType = Icon.class.getDeclaredField("iconType");
            iconType.setAccessible(true);
            IconType type = (IconType)iconType.get(icon);
            switch (type) {
                case CORE: {
                    return Functions.getResourcePath() + "/images/" + icon.getUrl();
                }
                case PLUGIN: {
                    return Functions.getResourcePath() + "/plugin/" + icon.getUrl();
                }
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchFieldException iconType) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)Functions.getResourcePath());
            return icon.getQualifiedUrl(ctx);
        }
    }
}

