/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.List;
import java.util.Optional;
import jenkins.branch.BranchEventCause;
import jenkins.branch.BranchIndexingCause;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OverrideIndexTriggersJobProperty;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class NoTriggerMultiBranchQueueDecisionHandler
extends Queue.QueueDecisionHandler {
    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        if (!NoTriggerMultiBranchQueueDecisionHandler.isMultiBranchJob(p)) {
            return true;
        }
        for (Action action : actions) {
            Optional<Boolean> result;
            if (!(action instanceof CauseAction) || !(result = this.processAction((Job)p, (CauseAction)action)).isPresent()) continue;
            return result.get();
        }
        return true;
    }

    private static boolean isMultiBranchJob(Queue.Task task) {
        if (!(task instanceof Job)) {
            return false;
        }
        Job job = (Job)task;
        return job.getParent() instanceof MultiBranchProject;
    }

    @VisibleForTesting
    Optional<Boolean> processAction(Job<?, ?> job, CauseAction action) {
        for (Cause cause : action.getCauses()) {
            if (!(cause instanceof BranchIndexingCause) && !(cause instanceof BranchEventCause)) continue;
            OverrideIndexTriggersJobProperty overrideTriggersProperty = (OverrideIndexTriggersJobProperty)job.getProperty(OverrideIndexTriggersJobProperty.class);
            if (overrideTriggersProperty != null) {
                return Optional.of(overrideTriggersProperty.getEnableTriggers());
            }
            NoTriggerProperty noTriggerProperty = this.findNoTriggerProperty(job);
            if (noTriggerProperty == null) {
                return Optional.of(Boolean.TRUE);
            }
            return Optional.of(!NoTriggerMultiBranchQueueDecisionHandler.shouldSuppressBuild(job, cause, noTriggerProperty));
        }
        return Optional.empty();
    }

    private NoTriggerProperty findNoTriggerProperty(Job job) {
        for (Object object : this.getBranchProperties((MultiBranchProject)job.getParent(), job)) {
            if (!(object instanceof NoTriggerProperty)) continue;
            return (NoTriggerProperty)object;
        }
        return null;
    }

    @NonNull
    protected abstract Iterable<? extends Object> getBranchProperties(MultiBranchProject var1, Job var2);

    private static boolean shouldSuppressBuild(Job<?, ?> job, Cause cause, NoTriggerProperty property) {
        if (!NoTriggerMultiBranchQueueDecisionHandler.getBranchNameOf(job).matches(property.getTriggeredBranchesRegex())) {
            return true;
        }
        return property.getStrategy().shouldSuppress(cause);
    }

    private static String getBranchNameOf(Job<?, ?> job) {
        return ((MultiBranchProject)job.getParent()).getProjectFactory().getBranch(job).getName();
    }

    public static enum SuppressionStrategy {
        INDEXING(Messages._NoTriggerProperty_strategy_indexing()),
        EVENTS(Messages._NoTriggerProperty_strategy_events()),
        NONE(Messages._NoTriggerProperty_strategy_none());

        private final Localizable displayName;

        private SuppressionStrategy(Localizable displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public boolean shouldSuppress(Cause cause) {
            boolean indexing = cause instanceof BranchIndexingCause;
            boolean events = cause instanceof BranchEventCause;
            if (!indexing && !events) {
                String className = cause != null ? cause.getClass().getName() : "null";
                throw new IllegalArgumentException("Unsupported cause type: " + className);
            }
            return indexing && this == INDEXING || events && this == EVENTS;
        }
    }

    public static interface NoTriggerProperty {
        @NonNull
        public String getTriggeredBranchesRegex();

        @NonNull
        public SuppressionStrategy getStrategy();
    }
}

