/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ListView;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.ViewsTabBar;
import hudson.views.WeatherColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jenkins.branch.DescriptionColumn;
import jenkins.branch.ItemColumn;
import jenkins.branch.MultiBranchCategoryFilter;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMSourceCategory;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class OrganizationFolderViewHolder
extends AbstractFolderViewHolder {
    @NonNull
    private final OrganizationFolder owner;
    private transient ViewsTabBar tabBar;
    @GuardedBy(value="this")
    private volatile transient List<View> views = null;
    @GuardedBy(value="this")
    private volatile transient String primaryView = null;

    public OrganizationFolderViewHolder(OrganizationFolder owner) {
        this.owner = owner;
    }

    @NonNull
    public List<View> getViews() {
        this.ensureViews();
        return this.views;
    }

    public void setViews(@NonNull List<? extends View> views) {
    }

    public String getPrimaryView() {
        this.ensureViews();
        return this.primaryView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureViews() {
        if (this.views == null) {
            OrganizationFolderViewHolder organizationFolderViewHolder = this;
            synchronized (organizationFolderViewHolder) {
                if (this.views == null) {
                    ArrayList<View> views = new ArrayList<View>();
                    for (SCMSourceCategory c : SCMSourceCategory.collectAndSimplify(this.owner.getNavigators()).values()) {
                        views.add((View)new ViewImpl((ViewGroup)this.owner, c));
                        if (!c.isUncategorized()) continue;
                        this.primaryView = c.getName();
                    }
                    this.views = views;
                }
            }
        }
    }

    public void setPrimaryView(@CheckForNull String name) {
    }

    public boolean isPrimaryModifiable() {
        return false;
    }

    @NonNull
    public ViewsTabBar getTabBar() {
        if (this.tabBar == null) {
            this.tabBar = new DefaultViewsTabBar();
        }
        return this.tabBar;
    }

    public void setTabBar(@NonNull ViewsTabBar tabBar) {
    }

    public boolean isTabBarModifiable() {
        return false;
    }

    public synchronized void invalidateCaches() {
        this.views = null;
        this.primaryView = null;
    }

    @Restricted(value={NoExternalUse.class})
    public static class ViewImpl
    extends ListView {
        @NonNull
        private final SCMSourceCategory category;

        public ViewImpl(ViewGroup owner, @NonNull SCMSourceCategory category) {
            super(category.getName(), owner);
            this.category = category;
            try {
                this.getJobFilters().replaceBy(Arrays.asList(new MultiBranchCategoryFilter(category)));
                this.getColumns().replaceBy(Arrays.asList(new ListViewColumn[]{new StatusColumn(), new WeatherColumn(), new ItemColumn(), new DescriptionColumn()}));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setRecurse(false);
        }

        public String getDisplayName() {
            return this.category.getDisplayName() + " (" + this.getItems().size() + ")";
        }

        public boolean isRecurse() {
            return false;
        }

        public ACL getACL() {
            final ACL acl = super.getACL();
            return new ACL(){

                public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
                    if (View.CREATE.equals((Object)permission) || View.CONFIGURE.equals((Object)permission) || View.DELETE.equals((Object)permission)) {
                        return false;
                    }
                    return acl.hasPermission(a, permission);
                }
            };
        }

        public void save() throws IOException {
        }

        @Extension
        public static class ViewDescriptorImpl
        extends ViewDescriptor {
            public String getDisplayName() {
                return "Organization folder All view";
            }

            public boolean isInstantiable() {
                return false;
            }
        }
    }
}

