/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.PluginManager;
import io.jenkins.servlet.ServletContextWrapper;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;

public class LocalPluginManager
extends PluginManager {
    private static final Logger LOGGER = Logger.getLogger(LocalPluginManager.class.getName());

    public LocalPluginManager(@CheckForNull ServletContext context, @NonNull File rootDir) {
        super(context, new File(rootDir, "plugins"));
    }

    @Deprecated
    public LocalPluginManager(@CheckForNull javax.servlet.ServletContext context, @NonNull File rootDir) {
        this(context != null ? ServletContextWrapper.toJakartaServletContext((javax.servlet.ServletContext)context) : null, rootDir);
    }

    public LocalPluginManager(@NonNull Jenkins jenkins) {
        this(jenkins.getServletContext(), jenkins.getRootDir());
    }

    public LocalPluginManager(@NonNull File rootDir) {
        this((ServletContext)null, rootDir);
    }

    @Override
    protected Collection<String> loadBundledPlugins() {
        if (SystemProperties.getString("hudson.bundled.plugins") != null) {
            return Collections.emptySet();
        }
        try {
            Set<String> set = this.loadPluginsFromWar("/WEB-INF/plugins");
            return set;
        }
        finally {
            this.loadDetachedPlugins();
        }
    }
}

