/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FeedAdapter;
import hudson.PermalinkList;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.model.AbstractItem;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Build;
import hudson.model.BuildTimelineWidget;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributor;
import hudson.model.Failure;
import hudson.model.Fingerprint;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.PermalinkProjectAction;
import hudson.model.Queue;
import hudson.model.RSS;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.search.QuickSilver;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.search.SearchItems;
import hudson.security.ACL;
import hudson.tasks.LogRotator;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.CopyOnWriteList;
import hudson.util.DataSetBuilder;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.Graph;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import hudson.util.TextFile;
import hudson.widgets.HistoryWidget;
import hudson.widgets.Widget;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.BuildDiscarder;
import jenkins.model.BuildDiscarderProperty;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.HistoricalBuild;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.PeepholePermalink;
import jenkins.model.ProjectNamingStrategy;
import jenkins.model.RunIdMigrator;
import jenkins.scm.RunWithSCM;
import jenkins.security.HexStringConfidentialKey;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.triggers.SCMTriggerItem;
import jenkins.widgets.HasWidgets;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

@BridgeMethodsAdded
public abstract class Job<JobT extends Job<JobT, RunT>, RunT extends Run<JobT, RunT>>
extends AbstractItem
implements ExtensionPoint,
StaplerOverridable,
ModelObjectWithChildren,
HasWidgets {
    private static final Logger LOGGER = Logger.getLogger(Job.class.getName());
    protected volatile transient int nextBuildNumber = 1;
    private volatile transient boolean holdOffBuildUntilSave;
    private volatile transient boolean holdOffBuildUntilUserSave;
    @Deprecated
    private volatile BuildDiscarder logRotator;
    private transient Integer cachedBuildHealthReportsBuildNumber = null;
    private transient List<HealthReport> cachedBuildHealthReports = null;
    boolean keepDependencies;
    protected CopyOnWriteList<JobProperty<? super JobT>> properties = new CopyOnWriteList();
    @Restricted(value={NoExternalUse.class})
    public transient RunIdMigrator runIdMigrator;
    public static final HistoryWidget.Adapter<HistoricalBuild> HISTORY_ADAPTER = new HistoryWidget.Adapter<HistoricalBuild>(){

        @Override
        public int compare(HistoricalBuild record, String key) {
            try {
                int k = Integer.parseInt(key);
                return record.getNumber() - k;
            }
            catch (NumberFormatException nfe) {
                return String.valueOf(record.getNumber()).compareTo(key);
            }
        }

        @Override
        public String getKey(HistoricalBuild record) {
            return String.valueOf(record.getNumber());
        }

        @Override
        public boolean isBuilding(HistoricalBuild record) {
            return record.isBuilding();
        }

        @Override
        public String getNextKey(String key) {
            try {
                int k = Integer.parseInt(key);
                return String.valueOf(k + 1);
            }
            catch (NumberFormatException nfe) {
                return "-unable to determine next key-";
            }
        }
    };
    private static final HexStringConfidentialKey SERVER_COOKIE = new HexStringConfidentialKey(Job.class, "serverCookie", 16);

    protected Job(ItemGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public synchronized void save() throws IOException {
        super.save();
        this.holdOffBuildUntilSave = this.holdOffBuildUntilUserSave;
    }

    @Override
    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        this.runIdMigrator = new RunIdMigrator();
        this.runIdMigrator.created(this.getBuildDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        File buildDir = this.getBuildDir();
        this.runIdMigrator = new RunIdMigrator();
        this.runIdMigrator.migrate(buildDir, Jenkins.get().getRootDir());
        TextFile f = this.getNextBuildNumberFile();
        if (f.exists()) {
            try {
                Job job = this;
                synchronized (job) {
                    this.nextBuildNumber = Integer.parseInt(f.readTrim());
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Corruption in {0}: {1}", new Object[]{f, e});
                RunT RunT = this.getLastBuild();
                Job job = this;
                synchronized (job) {
                    this.nextBuildNumber = RunT != null ? ((Run)RunT).getNumber() + 1 : 1;
                }
                this.saveNextBuildNumber();
            }
        } else if (this.nextBuildNumber == 0) {
            this.nextBuildNumber = 1;
        }
        if (this.properties == null) {
            this.properties = new CopyOnWriteList();
        }
        for (JobProperty jobProperty : this.properties) {
            jobProperty.setOwner(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCopiedFrom(Item src) {
        super.onCopiedFrom(src);
        Job job = this;
        synchronized (job) {
            this.nextBuildNumber = 1;
            this.holdOffBuildUntilSave = this.holdOffBuildUntilUserSave = true;
        }
    }

    TextFile getNextBuildNumberFile() {
        return new TextFile(new File(this.getRootDir(), "nextBuildNumber"));
    }

    public synchronized boolean isHoldOffBuildUntilSave() {
        return this.holdOffBuildUntilSave;
    }

    protected synchronized void saveNextBuildNumber() throws IOException {
        if (this.nextBuildNumber == 0) {
            this.nextBuildNumber = 1;
        }
        this.getNextBuildNumberFile().write(String.valueOf(this.nextBuildNumber) + "\n");
    }

    @Exported
    public boolean isInQueue() {
        return false;
    }

    @Exported
    public Queue.Item getQueueItem() {
        return null;
    }

    public boolean isBuilding() {
        RunT b = this.getLastBuild();
        return b != null && ((Run)b).isBuilding();
    }

    public boolean isLogUpdated() {
        RunT b = this.getLastBuild();
        return b != null && ((Run)b).isLogUpdated();
    }

    @Override
    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, this, Messages.Job_Pronoun());
    }

    @Override
    public boolean isNameEditable() {
        return true;
    }

    @Exported
    public boolean isKeepDependencies() {
        return this.keepDependencies;
    }

    public int assignBuildNumber() throws IOException {
        return ExtensionList.lookupFirst(BuildNumberAssigner.class).assignBuildNumber(this, this::saveNextBuildNumber);
    }

    @Exported
    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public EnvVars getCharacteristicEnvVars() {
        EnvVars env = new EnvVars();
        env.put("JENKINS_SERVER_COOKIE", SERVER_COOKIE.get());
        env.put("HUDSON_SERVER_COOKIE", SERVER_COOKIE.get());
        env.put("JOB_NAME", this.getFullName());
        env.put("JOB_BASE_NAME", this.getName());
        return env;
    }

    @NonNull
    public EnvVars getEnvironment(@CheckForNull Node node, @NonNull TaskListener listener) throws IOException, InterruptedException {
        Computer computer;
        EnvVars env = new EnvVars();
        if (node != null && (computer = node.toComputer()) != null) {
            env = computer.getEnvironment();
            env.putAll(computer.buildEnvironment(listener));
        }
        env.putAll(this.getCharacteristicEnvVars());
        env.put("CLASSPATH", "");
        for (EnvironmentContributor ec : EnvironmentContributor.all().reverseView()) {
            ec.buildEnvironmentFor(this, env, listener);
        }
        return env;
    }

    public synchronized void updateNextBuildNumber(int next) throws IOException {
        RunT lb = this.getLastBuild();
        if (lb != null ? next > ((Run)lb).getNumber() : next > 0) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    @Restricted(value={Beta.class})
    public void fastUpdateNextBuildNumber(int nextBuildNumber) {
        this.nextBuildNumber = nextBuildNumber;
    }

    public synchronized BuildDiscarder getBuildDiscarder() {
        BuildDiscarderProperty prop = this._getProperty(BuildDiscarderProperty.class);
        return prop != null ? prop.getStrategy() : this.logRotator;
    }

    public synchronized void setBuildDiscarder(BuildDiscarder bd) throws IOException {
        try (BulkChange bc = new BulkChange(this);){
            this.removeProperty(BuildDiscarderProperty.class);
            if (bd != null) {
                this.addProperty(new BuildDiscarderProperty(bd));
            }
            bc.commit();
        }
    }

    @Deprecated
    public LogRotator getLogRotator() {
        BuildDiscarder buildDiscarder = this.getBuildDiscarder();
        return buildDiscarder instanceof LogRotator ? (LogRotator)buildDiscarder : null;
    }

    @Deprecated
    public void setLogRotator(LogRotator logRotator) throws IOException {
        this.setBuildDiscarder(logRotator);
    }

    public void logRotate() throws IOException, InterruptedException {
        BuildDiscarder bd = this.getBuildDiscarder();
        if (bd != null) {
            bd.perform(this);
        }
    }

    public boolean supportsLogRotator() {
        return true;
    }

    @Override
    public String getSearchIcon() {
        return "symbol-status-" + this.getIconColor().getIconName();
    }

    @Override
    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add(new SearchIndex(){

            @Override
            public void find(String token, List<SearchItem> result) {
                try {
                    int n;
                    Object b;
                    if (token.startsWith("#")) {
                        token = token.substring(1);
                    }
                    if ((b = Job.this.getBuildByNumber(n = Integer.parseInt(token))) == null) {
                        return;
                    }
                    result.add(SearchItems.create("#" + n, "" + n, b));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            @Override
            public void suggest(String token, List<SearchItem> result) {
                this.find(token, result);
            }
        });
    }

    @Override
    public Collection<? extends Job> getAllJobs() {
        return Set.of(this);
    }

    public void addProperty(JobProperty<? super JobT> jobProp) throws IOException {
        jobProp.setOwner(this);
        this.properties.add(jobProp);
        this.save();
    }

    public void removeProperty(JobProperty<? super JobT> jobProp) throws IOException {
        this.properties.remove(jobProp);
        this.save();
    }

    public <T extends JobProperty> T removeProperty(Class<T> clazz) throws IOException {
        for (JobProperty<? super JobT> jobProperty : this.properties) {
            if (!clazz.isInstance(jobProperty)) continue;
            this.removeProperty(jobProperty);
            return (T)((JobProperty)clazz.cast(jobProperty));
        }
        return null;
    }

    public Map<JobPropertyDescriptor, JobProperty<? super JobT>> getProperties() {
        Map<Descriptor<JobProperty<JobT>>, JobProperty<JobT>> result = Descriptor.toMap(this.properties);
        if (this.logRotator != null) {
            result.put(Jenkins.get().getDescriptorByType(BuildDiscarderProperty.DescriptorImpl.class), new BuildDiscarderProperty(this.logRotator));
        }
        return result;
    }

    @Exported(name="property", inline=true)
    public List<JobProperty<? super JobT>> getAllProperties() {
        return this.properties.getView();
    }

    public <T extends JobProperty> T getProperty(Class<T> clazz) {
        if (clazz == BuildDiscarderProperty.class && this.logRotator != null) {
            return (T)((JobProperty)clazz.cast(new BuildDiscarderProperty(this.logRotator)));
        }
        return this._getProperty(clazz);
    }

    private <T extends JobProperty> T _getProperty(Class<T> clazz) {
        for (JobProperty<? super JobT> jobProperty : this.properties) {
            if (!clazz.isInstance(jobProperty)) continue;
            return (T)((JobProperty)clazz.cast(jobProperty));
        }
        return null;
    }

    public JobProperty getProperty(String className) {
        for (JobProperty<JobT> p : this.properties) {
            if (!p.getClass().getName().equals(className)) continue;
            return p;
        }
        return null;
    }

    public Collection<?> getOverrides() {
        ArrayList r = new ArrayList();
        for (JobProperty<JobT> p : this.properties) {
            r.addAll(p.getJobOverrides());
        }
        return r;
    }

    @Deprecated(forRemoval=true, since="2.410")
    protected HistoryWidget createHistoryWidget() {
        throw new IllegalStateException("HistoryWidget is now created via WidgetFactory implementation");
    }

    @Override
    public void renameTo(String newName) throws IOException {
        File oldBuildDir = this.getBuildDir();
        super.renameTo(newName);
        File newBuildDir = this.getBuildDir();
        if (Files.isDirectory(Util.fileToPath(oldBuildDir), new LinkOption[0]) && !Files.isDirectory(Util.fileToPath(newBuildDir), new LinkOption[0])) {
            Util.createDirectories(Util.fileToPath(newBuildDir.getParentFile()), new FileAttribute[0]);
            Files.move(Util.fileToPath(oldBuildDir), Util.fileToPath(newBuildDir), new CopyOption[0]);
        }
    }

    @Override
    public void movedTo(DirectlyModifiableTopLevelItemGroup destination, AbstractItem newItem, File destDir) throws IOException {
        File oldBuildDir = this.getBuildDir();
        super.movedTo(destination, newItem, destDir);
        File newBuildDir = this.getBuildDir();
        if (oldBuildDir.isDirectory()) {
            FileUtils.moveDirectory((File)oldBuildDir, (File)newBuildDir);
        }
    }

    @Override
    public void delete() throws IOException, InterruptedException {
        super.delete();
        Util.deleteRecursive(this.getBuildDir());
    }

    @Exported
    public abstract boolean isBuildable();

    @Exported(name="allBuilds", visibility=-2)
    @WithBridgeMethods(value={List.class})
    public RunList<RunT> getBuilds() {
        return RunList.fromRuns(this._getRuns().values());
    }

    @Exported(name="builds")
    public RunList<RunT> getNewBuilds() {
        return ((RunList)this.getBuilds()).limit(100);
    }

    public synchronized List<RunT> getBuilds(Fingerprint.RangeSet rs) {
        ArrayList<RunT> builds = new ArrayList<RunT>();
        for (Fingerprint.Range r : rs.getRanges()) {
            for (RunT b = this.getNearestBuild(r.start); b != null && ((Run)b).getNumber() < r.end; b = ((Run)b).getNextBuild()) {
                builds.add(b);
            }
        }
        return builds;
    }

    public SortedMap<Integer, RunT> getBuildsAsMap() {
        return Collections.unmodifiableSortedMap(this._getRuns());
    }

    public RunT getBuild(String id) {
        for (Run r : this._getRuns().values()) {
            if (!r.getId().equals(id)) continue;
            return (RunT)r;
        }
        return null;
    }

    public RunT getBuildByNumber(int n) {
        return (RunT)((Run)this._getRuns().get(n));
    }

    @Deprecated
    @WithBridgeMethods(value={List.class})
    public RunList<RunT> getBuildsByTimestamp(long start, long end) {
        return ((RunList)this.getBuilds()).byTimestamp(start, end);
    }

    @CLIResolver
    public RunT getBuildForCLI(@Argument(required=true, metaVar="BUILD#", usage="Build number") String id) throws CmdLineException {
        try {
            int n = Integer.parseInt(id);
            RunT r = this.getBuildByNumber(n);
            if (r == null) {
                throw new CmdLineException(null, "No such build '#" + n + "' exists");
            }
            return r;
        }
        catch (NumberFormatException e) {
            throw new CmdLineException(null, id + "is not a number", (Throwable)e);
        }
    }

    public RunT getNearestBuild(int n) {
        SortedMap<Integer, RunT> m = this._getRuns().headMap(n - 1);
        if (m.isEmpty()) {
            return null;
        }
        return (RunT)((Run)m.get(m.lastKey()));
    }

    public RunT getNearestOldBuild(int n) {
        SortedMap<Integer, RunT> m = this._getRuns().tailMap(n);
        if (m.isEmpty()) {
            return null;
        }
        return (RunT)((Run)m.get(m.firstKey()));
    }

    @Override
    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        if (Util.isOverridden(Job.class, this.getClass(), "getDynamic", String.class, StaplerRequest.class, StaplerResponse.class)) {
            return this.getDynamic(token, StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
        }
        try {
            return this.getBuildByNumber(Integer.parseInt(token));
        }
        catch (NumberFormatException e) {
            for (Widget w : this.getWidgets()) {
                if (!w.getUrlName().equals(token)) continue;
                return w;
            }
            for (PermalinkProjectAction.Permalink p : this.getPermalinks()) {
                if (!p.getId().equals(token)) continue;
                return p.resolve(this);
            }
            return super.getDynamic(token, req, rsp);
        }
    }

    @Override
    @Deprecated
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        try {
            return this.getBuildByNumber(Integer.parseInt(token));
        }
        catch (NumberFormatException e) {
            for (Widget w : this.getWidgets()) {
                if (!w.getUrlName().equals(token)) continue;
                return w;
            }
            for (PermalinkProjectAction.Permalink p : this.getPermalinks()) {
                if (!p.getId().equals(token)) continue;
                return p.resolve(this);
            }
            return super.getDynamic(token, req, rsp);
        }
    }

    public File getBuildDir() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return new File(this.getRootDir(), "builds");
        }
        return j.getBuildDirFor(this);
    }

    protected abstract SortedMap<Integer, ? extends RunT> _getRuns();

    protected abstract void removeRun(RunT var1);

    @Exported
    @QuickSilver
    public RunT getLastBuild() {
        SortedMap<Integer, RunT> runs = this._getRuns();
        if (runs.isEmpty()) {
            return null;
        }
        return (RunT)((Run)runs.get(runs.firstKey()));
    }

    @Exported
    @QuickSilver
    public RunT getFirstBuild() {
        SortedMap<Integer, RunT> runs = this._getRuns();
        if (runs.isEmpty()) {
            return null;
        }
        return (RunT)((Run)runs.get(runs.lastKey()));
    }

    @Exported
    @QuickSilver
    public RunT getLastSuccessfulBuild() {
        return (RunT)PeepholePermalink.LAST_SUCCESSFUL_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastUnsuccessfulBuild() {
        return (RunT)PeepholePermalink.LAST_UNSUCCESSFUL_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastUnstableBuild() {
        return (RunT)PeepholePermalink.LAST_UNSTABLE_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastStableBuild() {
        return (RunT)PeepholePermalink.LAST_STABLE_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastFailedBuild() {
        return (RunT)PeepholePermalink.LAST_FAILED_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastCompletedBuild() {
        return (RunT)PeepholePermalink.LAST_COMPLETED_BUILD.resolve(this);
    }

    public List<RunT> getLastBuildsOverThreshold(int numberOfBuilds, Result threshold) {
        RunT r = this.getLastBuild();
        return ((Run)r).getBuildsOverThreshold(numberOfBuilds, threshold);
    }

    protected List<RunT> getEstimatedDurationCandidates() {
        ArrayList<Object> candidates = new ArrayList<Object>(3);
        RunT lastSuccessful = this.getLastSuccessfulBuild();
        int lastSuccessfulNumber = -1;
        if (lastSuccessful != null) {
            candidates.add(lastSuccessful);
            lastSuccessfulNumber = ((Run)lastSuccessful).getNumber();
        }
        int i = 0;
        ArrayList<RunT> fallbackCandidates = new ArrayList<RunT>(3);
        for (RunT r = this.getLastBuild(); r != null && candidates.size() < 3 && i < 6; ++i, r = ((Run)r).getPreviousBuild()) {
            if (((Run)r).isBuilding() || ((Run)r).getResult() == null || ((Run)r).getNumber() == lastSuccessfulNumber) continue;
            Result result = ((Run)r).getResult();
            if (result.isBetterOrEqualTo(Result.UNSTABLE)) {
                candidates.add(r);
                continue;
            }
            if (!result.isCompleteBuild()) continue;
            fallbackCandidates.add(r);
        }
        while (candidates.size() < 3 && !fallbackCandidates.isEmpty()) {
            Run run = (Run)fallbackCandidates.remove(0);
            candidates.add(run);
        }
        return candidates;
    }

    public long getEstimatedDuration() {
        List<RunT> builds = this.getEstimatedDurationCandidates();
        if (builds.isEmpty()) {
            return -1L;
        }
        long totalDuration = 0L;
        for (Run b : builds) {
            totalDuration += b.getDuration();
        }
        if (totalDuration == 0L) {
            return -1L;
        }
        return Math.round((double)totalDuration / (double)builds.size());
    }

    public PermalinkList getPermalinks() {
        PeepholePermalink.initialized();
        PermalinkList permalinks = new PermalinkList((Collection<? extends PermalinkProjectAction.Permalink>)PermalinkProjectAction.Permalink.BUILTIN);
        for (PermalinkProjectAction ppa : this.getActions(PermalinkProjectAction.class)) {
            permalinks.addAll(ppa.getPermalinks());
        }
        return permalinks;
    }

    public void doRssChangelog(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        class FeedItem {
            ChangeLogSet.Entry e;
            int idx;

            FeedItem(ChangeLogSet.Entry e, int idx) {
                this.e = e;
                this.idx = idx;
            }

            Run<?, ?> getBuild() {
                return this.e.getParent().build;
            }
        }
        ArrayList<FeedItem> entries = new ArrayList<FeedItem>();
        Object scmDisplayName = "";
        Job job = this;
        if (job instanceof SCMTriggerItem) {
            SCMTriggerItem scmItem = (SCMTriggerItem)((Object)job);
            ArrayList<String> scmNames = new ArrayList<String>();
            for (SCM sCM : scmItem.getSCMs()) {
                scmNames.add(sCM.getDescriptor().getDisplayName());
            }
            scmDisplayName = " " + String.join((CharSequence)", ", scmNames);
        }
        for (RunT r = this.getLastBuild(); r != null; r = ((Run)r).getPreviousBuild()) {
            int idx = 0;
            if (!(r instanceof RunWithSCM)) continue;
            for (ChangeLogSet changeLogSet : ((RunWithSCM)r).getChangeSets()) {
                for (ChangeLogSet.Entry e : changeLogSet) {
                    entries.add(new FeedItem(e, idx++));
                }
            }
        }
        RSS.forwardToRss(this.getDisplayName() + (String)scmDisplayName + " changes", this.getUrl() + "changes", entries, new FeedAdapter<FeedItem>(){

            @Override
            public String getEntryTitle(FeedItem item) {
                return "#" + item.getBuild().number + " " + item.e.getMsg() + " (" + item.e.getAuthor() + ")";
            }

            @Override
            public String getEntryUrl(FeedItem item) {
                return item.getBuild().getUrl() + "changes#detail" + item.idx;
            }

            @Override
            public String getEntryID(FeedItem item) {
                return this.getEntryUrl(item);
            }

            @Override
            public String getEntryDescription(FeedItem item) {
                StringBuilder buf = new StringBuilder();
                for (String path : item.e.getAffectedPaths()) {
                    buf.append(path).append('\n');
                }
                return buf.toString();
            }

            @Override
            public Calendar getEntryTimestamp(FeedItem item) {
                return item.getBuild().getTimestamp();
            }

            @Override
            public String getEntryAuthor(FeedItem entry) {
                return JenkinsLocationConfiguration.get().getAdminAddress();
            }
        }, req, (HttpServletResponse)rsp);
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest2 request, StaplerResponse2 response) throws Exception {
        if (Util.isOverridden(Job.class, this.getClass(), "doChildrenContextMenu", StaplerRequest.class, StaplerResponse.class)) {
            return this.doChildrenContextMenu(StaplerRequest.fromStaplerRequest2((StaplerRequest2)request), StaplerResponse.fromStaplerResponse2((StaplerResponse2)response));
        }
        return this.doChildrenContextMenuImpl(request, response);
    }

    @Override
    @Deprecated
    @StaplerNotDispatchable
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return this.doChildrenContextMenuImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)request), StaplerResponse.toStaplerResponse2((StaplerResponse)response));
    }

    private ModelObjectWithContextMenu.ContextMenu doChildrenContextMenuImpl(StaplerRequest2 request, StaplerResponse2 response) {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (PermalinkProjectAction.Permalink p : this.getPermalinks()) {
            if (p.resolve(this) == null) continue;
            menu.add(p.getId(), p.getDisplayName());
        }
        return menu;
    }

    @Exported(visibility=2, name="color")
    public BallColor getIconColor() {
        RunT lastBuild;
        for (lastBuild = this.getLastBuild(); lastBuild != null && ((Run)lastBuild).hasntStartedYet(); lastBuild = ((Run)lastBuild).getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return ((Run)lastBuild).getIconColor();
        }
        return BallColor.NOTBUILT;
    }

    public HealthReport getBuildHealth() {
        List<HealthReport> reports = this.getBuildHealthReports();
        return reports.isEmpty() ? new HealthReport() : reports.get(0);
    }

    @Exported(name="healthReport")
    public List<HealthReport> getBuildHealthReports() {
        ArrayList<HealthReport> reports = new ArrayList<HealthReport>();
        RunT lastBuild = this.getLastBuild();
        if (lastBuild != null && ((Run)lastBuild).isBuilding()) {
            lastBuild = ((Run)lastBuild).getPreviousBuild();
        }
        if (this.cachedBuildHealthReportsBuildNumber != null && this.cachedBuildHealthReports != null && lastBuild != null && this.cachedBuildHealthReportsBuildNumber.intValue() == ((Run)lastBuild).getNumber()) {
            reports.addAll(this.cachedBuildHealthReports);
        } else if (lastBuild != null) {
            for (HealthReportingAction healthReportingAction : ((Actionable)lastBuild).getActions(HealthReportingAction.class)) {
                HealthReport report = healthReportingAction.getBuildHealth();
                if (report == null) continue;
                if (report.isAggregateReport()) {
                    reports.addAll(report.getAggregatedReports());
                    continue;
                }
                reports.add(report);
            }
            HealthReport report = this.getBuildStabilityHealthReport();
            if (report != null) {
                if (report.isAggregateReport()) {
                    reports.addAll(report.getAggregatedReports());
                } else {
                    reports.add(report);
                }
            }
            Collections.sort(reports);
            this.cachedBuildHealthReportsBuildNumber = ((Run)lastBuild).getNumber();
            this.cachedBuildHealthReports = new ArrayList<HealthReport>(reports);
        }
        return reports;
    }

    private HealthReport getBuildStabilityHealthReport() {
        SortedMap<Integer, RunT> runs;
        int failCount = 0;
        int totalCount = 0;
        RunT i = this.getLastBuild();
        RunT u = this.getLastFailedBuild();
        if (i != null && u == null) {
            return new HealthReport(100, Messages._Job_BuildStability(Messages._Job_NoRecentBuildFailed()));
        }
        if (i != null && ((Run)u).getNumber() <= ((Run)i).getNumber() && (runs = this._getRuns()) instanceof RunMap) {
            RunMap runMap = (RunMap)runs;
            for (int index = ((Run)i).getNumber(); index > ((Run)u).getNumber() && totalCount < 5; --index) {
                if (!runMap.runExists(index)) continue;
                ++totalCount;
            }
            if (totalCount < 5) {
                i = u;
            }
        }
        while (totalCount < 5 && i != null) {
            switch (((Run)i).getIconColor()) {
                case BLUE: 
                case YELLOW: {
                    ++totalCount;
                    break;
                }
                case RED: {
                    ++failCount;
                    ++totalCount;
                    break;
                }
            }
            i = ((Run)i).getPreviousBuild();
        }
        if (totalCount > 0) {
            int score = (int)(100.0 * (double)(totalCount - failCount) / (double)totalCount);
            Localizable description = failCount == 0 ? Messages._Job_NoRecentBuildFailed() : (totalCount == failCount ? Messages._Job_AllRecentBuildFailed() : Messages._Job_NOfMFailed(failCount, totalCount));
            return new HealthReport(score, Messages._Job_BuildStability(description));
        }
        return null;
    }

    @POST
    public synchronized void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        this.description = req.getParameter("description");
        JSONObject json = req.getSubmittedForm();
        try {
            try (BulkChange bc = new BulkChange(this);){
                this.setDisplayName(json.optString("displayNameOrNull"));
                this.logRotator = null;
                DescribableList t = new DescribableList(NOOP, this.getAllProperties());
                JSONObject jsonProperties = json.optJSONObject("properties");
                if (jsonProperties != null) {
                    t.rebuild(req, jsonProperties, JobPropertyDescriptor.getPropertyDescriptors(this.getClass()));
                } else {
                    t.clear();
                }
                this.properties.clear();
                for (JobProperty p : t) {
                    p.setOwner(this);
                    this.properties.add(p);
                }
                this.submit(req, rsp);
                bc.commit();
            }
            ItemListener.fireOnUpdated(this);
            ProjectNamingStrategy namingStrategy = Jenkins.get().getProjectNamingStrategy();
            if (namingStrategy.isForceExistingJobs()) {
                namingStrategy.checkName(this.getParent().getFullName(), this.name);
            }
            FormApply.success(".").generateResponse(req, rsp, null);
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, "failed to parse " + json, e);
            this.sendError((Exception)((Object)e), req, rsp);
        }
    }

    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        if (Util.isOverridden(Job.class, this.getClass(), "submit", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.submit(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (javax.servlet.ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((javax.servlet.ServletException)e);
            }
        }
    }

    @Deprecated
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException, Descriptor.FormException {
    }

    public void doDescription(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.getMethod().equals("GET")) {
            rsp.setContentType("text/plain;charset=UTF-8");
            rsp.getWriter().write(Util.fixNull(this.getDescription()));
            return;
        }
        if (req.getMethod().equals("POST")) {
            this.checkPermission(CONFIGURE);
            if (req.getParameter("description") != null) {
                this.setDescription(req.getParameter("description"));
                rsp.sendError(204);
                return;
            }
        }
        rsp.sendError(400);
    }

    public void doBuildStatus(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/48x48/" + this.getBuildStatusUrl());
    }

    public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    public Graph getBuildTimeGraph() {
        return new Graph(this.getLastBuildTime(), 500, 400){

            @Override
            protected JFreeChart createGraph() {
                DataSetBuilder<String, ChartLabel> data = new DataSetBuilder<String, ChartLabel>();
                for (Run r : Job.this.getNewBuilds()) {
                    if (r.isBuilding()) continue;
                    data.add((double)r.getDuration() / 60000.0, "min", new ChartLabel(r));
                }
                CategoryDataset dataset = data.build();
                JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)Messages.Job_minutes(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                ChartUtil.adjustChebyshev(dataset, rangeAxis);
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                ChartLabelStackedAreaRenderer2 ar = new ChartLabelStackedAreaRenderer2(dataset);
                plot.setRenderer((CategoryItemRenderer)ar);
                plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
                return chart;
            }
        };
    }

    private Calendar getLastBuildTime() {
        RunT lastBuild = this.getLastBuild();
        if (lastBuild == null) {
            GregorianCalendar neverBuiltCalendar = new GregorianCalendar();
            neverBuiltCalendar.setTimeInMillis(0L);
            return neverBuiltCalendar;
        }
        return ((Run)lastBuild).getTimestamp();
    }

    @Deprecated
    @RequirePOST
    public void doDoRename(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        String newName = req.getParameter("newName");
        this.doConfirmRename(newName).generateResponse(req, rsp, null);
    }

    @Override
    protected void checkRename(String newName) throws Failure {
        if (this.isBuilding()) {
            throw new Failure(Messages.Job_NoRenameWhileBuilding());
        }
    }

    public void doRssAll(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (all builds)", this.getUrl(), ((RunList)this.getBuilds()).newBuilds());
    }

    public void doRssFailed(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (failed builds)", this.getUrl(), ((RunList)this.getBuilds()).failureOnly().newBuilds());
    }

    @Override
    public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getACL(this);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public BuildTimelineWidget getTimeline() {
        return new BuildTimelineWidget((RunList<?>)this.getBuilds());
    }

    @Restricted(value={Beta.class})
    public static interface BuildNumberAssigner
    extends ExtensionPoint {
        public int assignBuildNumber(Job<?, ?> var1, SaveNextBuildNumber var2) throws IOException;

        public static interface SaveNextBuildNumber {
            public void call() throws IOException;
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="category dataset is only relevant for coloring, not equality")
    private static class ChartLabelStackedAreaRenderer2
    extends StackedAreaRenderer2 {
        private final CategoryDataset categoryDataset;

        ChartLabelStackedAreaRenderer2(CategoryDataset categoryDataset) {
            this.categoryDataset = categoryDataset;
        }

        @Override
        public Paint getItemPaint(int row, int column) {
            ChartLabel key = (ChartLabel)this.categoryDataset.getColumnKey(column);
            return key.getColor();
        }

        @Override
        public String generateURL(CategoryDataset dataset, int row, int column) {
            ChartLabel label = (ChartLabel)dataset.getColumnKey(column);
            return String.valueOf(label.run.number);
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            ChartLabel label = (ChartLabel)dataset.getColumnKey(column);
            return label.run.getDisplayName() + " : " + label.run.getDurationString();
        }
    }

    private static class ChartLabel
    implements Comparable<ChartLabel> {
        final Run run;

        ChartLabel(Run r) {
            this.run = r;
        }

        @Override
        public int compareTo(ChartLabel that) {
            return this.run.number - that.run.number;
        }

        public boolean equals(Object o) {
            if (o == null || !ChartLabel.class.isAssignableFrom(o.getClass())) {
                return false;
            }
            ChartLabel that = (ChartLabel)o;
            return this.run == that.run;
        }

        public Color getColor() {
            Result r = this.run.getResult();
            if (r == Result.FAILURE) {
                return ColorPalette.RED;
            }
            if (r == Result.UNSTABLE) {
                return ColorPalette.YELLOW;
            }
            if (r == Result.ABORTED || r == Result.NOT_BUILT) {
                return ColorPalette.DARK_GREY;
            }
            return ColorPalette.BLUE;
        }

        public int hashCode() {
            return this.run.hashCode();
        }

        public String toString() {
            String s;
            Object l = this.run.getDisplayName();
            if (this.run instanceof Build && (s = ((Build)this.run).getBuiltOnStr()) != null) {
                l = (String)l + " " + s;
            }
            return l;
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class SubItemBuildsLocationImpl
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            Jenkins jenkins = Jenkins.get();
            if (!jenkins.isDefaultBuildDir() && item instanceof Job) {
                File newBuildDir = ((Job)item).getBuildDir();
                try {
                    if (!Util.isDescendant(item.getRootDir(), newBuildDir)) {
                        String oldBuildsDir = Jenkins.expandVariablesForDirectory(jenkins.getRawBuildsDir(), oldFullName, "<NOPE>");
                        if (oldBuildsDir.contains("<NOPE>")) {
                            LOGGER.severe(String.format("Builds directory for job %1$s appears to be outside of item root, but somehow still containing the item root path, which is unknown. Cannot move builds from %2$s to %1$s.", newFullName, oldFullName));
                        } else {
                            File oldDir = new File(oldBuildsDir);
                            if (oldDir.isDirectory()) {
                                try {
                                    FileUtils.moveDirectory((File)oldDir, (File)newBuildDir);
                                }
                                catch (IOException e) {
                                    LOGGER.log(Level.SEVERE, String.format("Failed to move %s to %s", oldBuildsDir, newBuildDir.getAbsolutePath()), e);
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to inspect " + item.getRootDir() + ". Builds might not be moved.", e);
                }
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension(ordinal=-1000.0)
    public static final class DefaultBuildNumberAssigner
    implements BuildNumberAssigner {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int assignBuildNumber(Job<?, ?> job, BuildNumberAssigner.SaveNextBuildNumber saveNextBuildNumber) throws IOException {
            Job<?, ?> job2 = job;
            synchronized (job2) {
                int r = job.nextBuildNumber++;
                saveNextBuildNumber.call();
                return r;
            }
        }
    }

    @Extension(ordinal=-1.7976931348623157E308)
    public static class LastItemListener
    extends ItemListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCopied(Item src, Item item) {
            if (item instanceof Job) {
                Job job;
                Job job2 = job = (Job)item;
                synchronized (job2) {
                    job.holdOffBuildUntilUserSave = false;
                }
            }
        }
    }
}

