/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.userproperty;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.ModelObject;
import hudson.model.userproperty.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public abstract class UserPropertyCategory
implements ExtensionPoint,
ModelObject {
    public abstract String getShortDescription();

    public static ExtensionList<UserPropertyCategory> all() {
        return ExtensionList.lookup(UserPropertyCategory.class);
    }

    @NonNull
    public static <T extends UserPropertyCategory> T get(Class<T> type) {
        UserPropertyCategory category = (UserPropertyCategory)UserPropertyCategory.all().get(type);
        if (category == null) {
            throw new AssertionError((Object)("Category not found. It seems the " + type + " is not annotated with @Extension and so not registered"));
        }
        return (T)category;
    }

    @Extension
    @Symbol(value={"invisible"})
    public static class Invisible
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Invisible_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Invisible_ShortDescription();
        }
    }

    @Extension
    @Symbol(value={"security"})
    public static class Security
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Security_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Security_ShortDescription();
        }
    }

    @Extension
    @Symbol(value={"appearance"})
    public static class Appearance
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Appearance_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Appearance_ShortDescription();
        }
    }

    @Extension
    @Symbol(value={"experimental"})
    public static class Experimental
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Experimental_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Experimental_ShortDescription();
        }
    }

    @Extension
    @Symbol(value={"preferences"})
    public static class Preferences
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Preferences_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Preferences_ShortDescription();
        }
    }

    @Extension
    @Symbol(value={"account"})
    public static class Account
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Account_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Account_ShortDescription();
        }
    }

    @Extension
    @Symbol(value={"unclassified"})
    @Restricted(value={DoNotUse.class})
    public static class Unclassified
    extends UserPropertyCategory {
        @Override
        public String getDisplayName() {
            return Messages.UserPropertyCategory_Unclassified_DisplayName();
        }

        @Override
        public String getShortDescription() {
            return Messages.UserPropertyCategory_Unclassified_ShortDescription();
        }
    }
}

