/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class ResourceBundleUtil {
    private static final Map<String, JSONObject> bundles = new ConcurrentHashMap<String, JSONObject>();

    private ResourceBundleUtil() {
    }

    @NonNull
    public static JSONObject getBundle(@NonNull String baseName) throws MissingResourceException {
        return ResourceBundleUtil.getBundle(baseName, Locale.getDefault());
    }

    @NonNull
    public static JSONObject getBundle(@NonNull String baseName, @NonNull Locale locale) throws MissingResourceException {
        String bundleKey = baseName + ":" + locale;
        JSONObject bundleJSON = bundles.get(bundleKey);
        if (bundleJSON != null) {
            return bundleJSON;
        }
        ResourceBundle.Control noFallbackControl = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        ClassLoader uberClassLoader = Jenkins.get().getPluginManager().uberClassLoader;
        bundleJSON = ResourceBundleUtil.toJSONObject(ResourceBundle.getBundle(baseName, locale, uberClassLoader, noFallbackControl));
        bundles.put(bundleKey, bundleJSON);
        return bundleJSON;
    }

    private static JSONObject toJSONObject(@NonNull ResourceBundle bundle) {
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            json.put(key, (Object)bundle.getString(key));
        }
        return json;
    }
}

