/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.matchers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class ScopeMatcher
implements CredentialsMatcher,
CredentialsMatcher.CQL {
    private static final long serialVersionUID = -7786779595366393177L;
    @NonNull
    private final Set<CredentialsScope> scopes;

    public ScopeMatcher(@NonNull CredentialsScope scope) {
        Objects.requireNonNull(scope);
        this.scopes = Collections.singleton(scope);
    }

    public ScopeMatcher(CredentialsScope ... scopes) {
        this.scopes = EnumSet.copyOf(Arrays.asList(scopes));
    }

    public ScopeMatcher(@NonNull Collection<CredentialsScope> scopes) {
        this.scopes = EnumSet.copyOf(scopes);
    }

    @Override
    public boolean matches(@NonNull Credentials item) {
        return this.scopes.contains(item.getScope());
    }

    @Override
    public String describe() {
        if (this.scopes.isEmpty()) {
            return "false";
        }
        StringBuilder sb = new StringBuilder("(");
        if (this.scopes.size() == 1) {
            sb.append("scope == ");
            sb.append(CredentialsScope.class.getName());
            sb.append('.');
            sb.append(this.scopes.iterator().next().name());
        } else {
            boolean first = true;
            for (CredentialsScope s : this.scopes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" || ");
                }
                sb.append("(scope == ");
                sb.append(CredentialsScope.class.getName());
                sb.append('.');
                sb.append(s.name());
                sb.append(')');
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.scopes.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeMatcher that = (ScopeMatcher)o;
        return this.scopes.equals(that.scopes);
    }

    public String toString() {
        return "ScopeMatcher{scopes=" + this.scopes + '}';
    }
}

