/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.CachingScriptLoader;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.WebApp;

public abstract class AbstractTearOff<CLT, S, E extends Exception>
extends CachingScriptLoader<S, E> {
    private static final Logger LOGGER = Logger.getLogger(AbstractTearOff.class.getName());
    protected final MetaClass owner;
    protected final CLT classLoader;
    private final Map<String, ExpirableCacheHit<S>> cachedScripts = new ConcurrentHashMap<String, ExpirableCacheHit<S>>();
    private static final Pattern JAR_URL = Pattern.compile("jar:(file:.+)!/.*");

    protected AbstractTearOff(MetaClass owner, Class<CLT> cltClass) {
        this.owner = owner;
        this.classLoader = owner.classLoader != null ? owner.classLoader.loadTearOff(cltClass) : null;
    }

    protected final WebApp getWebApp() {
        return this.owner.webApp;
    }

    protected abstract String getDefaultScriptExtension();

    protected boolean hasAllowedExtension(String name) {
        return name.endsWith(this.getDefaultScriptExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S resolveScript(String name) throws E {
        block13: {
            URL res;
            block14: {
                Object script;
                ExpirableCacheHit<S> cached;
                long timestamp;
                block15: {
                    S script2;
                    block17: {
                        block16: {
                            if (((String)name).lastIndexOf(46) <= ((String)name).lastIndexOf(47)) {
                                name = (String)name + this.getDefaultScriptExtension();
                            }
                            if (!this.hasAllowedExtension((String)name)) {
                                return null;
                            }
                            res = this.getResource((String)name);
                            if (res == null) {
                                int dot = ((String)name).lastIndexOf(46);
                                if (((String)name).lastIndexOf(47) < dot) {
                                    res = this.getResource(((String)name).substring(0, dot) + ".default" + ((String)name).substring(dot));
                                }
                            }
                            if (res == null) break block13;
                            if (!MetaClass.NO_CACHE) break block14;
                            File file = AbstractTearOff.fileOf(res);
                            if (file == null) {
                                LOGGER.log(Level.FINE, "no file associated with {0}", res);
                                return this.parseScript(res);
                            }
                            timestamp = file.lastModified();
                            if (timestamp == 0L) {
                                LOGGER.log(Level.FINE, "no timestamp associated with {0}", file);
                                return this.parseScript(res);
                            }
                            cached = this.cachedScripts.get(res.toString());
                            if (cached != null) break block15;
                            if (!LOGGER.isLoggable(Level.FINE)) break block16;
                            long start = System.nanoTime();
                            try {
                                script2 = this.parseScript(res);
                            }
                            catch (Throwable throwable) {
                                LOGGER.log(Level.FINE, "cache miss; took {0}ms to parse {1}", new Object[]{(System.nanoTime() - start) / 1000000L, res});
                                throw throwable;
                            }
                            LOGGER.log(Level.FINE, "cache miss; took {0}ms to parse {1}", new Object[]{(System.nanoTime() - start) / 1000000L, res});
                            break block17;
                        }
                        LOGGER.log(Level.FINE, "cache miss on {0}", res);
                        script2 = this.parseScript(res);
                    }
                    this.cachedScripts.put(res.toString(), new ExpirableCacheHit<S>(timestamp, script2));
                    return script2;
                }
                if (timestamp == cached.timestamp) {
                    script = cached.script.get();
                    if (script == null) {
                        LOGGER.log(Level.FINE, "cache hit on {0} but value collected", res);
                    } else {
                        LOGGER.log(Level.FINE, "cache hit on {0}", res);
                    }
                } else {
                    LOGGER.log(Level.FINE, "expired cache hit on {0}", res);
                    script = null;
                }
                if (script == null) {
                    script = this.parseScript(res);
                    this.cachedScripts.put(res.toString(), new ExpirableCacheHit(timestamp, script));
                }
                return script;
            }
            LOGGER.log(Level.FINE, "standard CachingScriptLoader logic applies to {0}", res);
            return this.parseScript(res);
        }
        return null;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Files are read from approved plugins, not from user input.")
    private static File fileOf(URL res) {
        try {
            switch (res.getProtocol()) {
                case "file": {
                    return new File(res.toURI());
                }
                case "jar": {
                    Matcher m = JAR_URL.matcher(res.toString());
                    if (m.matches()) {
                        return new File(new URI(m.group(1)));
                    }
                    return null;
                }
            }
            return null;
        }
        catch (IllegalArgumentException | URISyntaxException x) {
            return null;
        }
    }

    @Override
    protected final S loadScript(String name) throws E {
        S s = this.resolveScript(name);
        if (s != null) {
            return s;
        }
        if (this.owner.baseClass != null) {
            return ((AbstractTearOff)this.owner.baseClass.loadTearOff(this.getClass())).findScript(name);
        }
        return null;
    }

    protected abstract S parseScript(URL var1) throws E;

    @Override
    protected URL getResource(String name) {
        return this.owner.klass.getResource(name);
    }

    private static final class ExpirableCacheHit<S> {
        private final long timestamp;
        private final Reference<S> script;

        ExpirableCacheHit(long timestamp, S script) {
            this.timestamp = timestamp;
            this.script = new SoftReference<S>(script);
        }
    }
}

