/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.kohsuke.stapler.AbstractTearOff;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.DispatchValidator;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.IndexViewDispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.ScriptExecutor;
import org.kohsuke.stapler.ScriptRequestDispatcher;
import org.kohsuke.stapler.event.FilteredDispatchTriggerListener;
import org.kohsuke.stapler.lang.Klass;

public abstract class Facet {
    public static final Logger LOGGER = Logger.getLogger(Facet.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Legacy switch.")
    public static boolean ALLOW_VIEW_NAME_PATH_TRAVERSAL = Boolean.getBoolean(Facet.class.getName() + ".allowViewNamePathTraversal");

    public abstract void buildViewDispatchers(MetaClass var1, List<Dispatcher> var2);

    public void buildIndexDispatchers(MetaClass owner, List<Dispatcher> dispatchers) {
        dispatchers.add(new IndexViewDispatcher(owner, this));
    }

    public void buildFallbackDispatchers(MetaClass owner, List<Dispatcher> dispatchers) {
    }

    public static List<Facet> discover(ClassLoader cl) {
        return Facet.discoverExtensions(Facet.class, cl);
    }

    public static <T> List<T> discoverExtensions(Class<T> type, ClassLoader ... cls) {
        ArrayList<T> r = new ArrayList<T>();
        HashSet<String> classNames = new HashSet<String>();
        for (ClassLoader cl : cls) {
            ClassLoaders classLoaders = new ClassLoaders();
            classLoaders.put(cl);
            DiscoverServiceNames dc = new DiscoverServiceNames(classLoaders);
            ResourceNameIterator itr = dc.findResourceNames(type.getName());
            while (itr.hasNext()) {
                Class<T> c;
                String name = itr.nextResourceName();
                if (!classNames.add(name)) continue;
                try {
                    c = cl.loadClass(name).asSubclass(type);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.WARNING, "Failed to load " + name, e);
                    continue;
                }
                try {
                    r.add(c.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate " + c, e);
                }
            }
        }
        return r;
    }

    @CheckForNull
    public RequestDispatcher createRequestDispatcher(RequestImpl request, Klass<?> type, Object it, String viewName) throws IOException {
        return null;
    }

    @CheckForNull
    public RequestDispatcher createRequestDispatcher(RequestImpl request, Class type, Object it, String viewName) throws IOException {
        return this.createRequestDispatcher(request, Klass.java(type), it, viewName);
    }

    public abstract boolean handleIndexRequest(RequestImpl var1, ResponseImpl var2, Object var3, MetaClass var4) throws IOException, ServletException;

    public Klass<?> getKlass(Object o) {
        return null;
    }

    protected boolean isBasename(String potentialPath) {
        if (ALLOW_VIEW_NAME_PATH_TRAVERSAL) {
            return true;
        }
        return !potentialPath.contains("\\") && !potentialPath.contains("/");
    }

    @NonNull
    protected String getExtensionSuffix() {
        return "";
    }

    @NonNull
    protected <S> Dispatcher createValidatingDispatcher(final @NonNull AbstractTearOff<?, ? extends S, ?> scriptLoader, final @NonNull ScriptExecutor<? super S> scriptExecutor) {
        return new Dispatcher(){

            @Override
            public boolean dispatch(@NonNull RequestImpl req, @NonNull ResponseImpl rsp, @CheckForNull Object node) throws ServletException {
                Object script;
                String next = req.tokens.peek();
                if (next == null) {
                    return false;
                }
                if (req.tokens.countRemainingTokens() > 1) {
                    return false;
                }
                if (req.tokens.endsWithSlash) {
                    return false;
                }
                if (!Facet.this.isBasename(next)) {
                    return false;
                }
                DispatchValidator validator = req.getWebApp().getDispatchValidator();
                FilteredDispatchTriggerListener listener = req.getWebApp().getFilteredDispatchTriggerListener();
                Boolean valid = validator.isDispatchAllowed(req, rsp, next, node);
                if (valid != null && !valid.booleanValue()) {
                    return listener.onDispatchTrigger(req, rsp, node, next);
                }
                try {
                    script = scriptLoader.findScript(next + Facet.this.getExtensionSuffix());
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                if (script == null) {
                    return false;
                }
                req.tokens.next();
                1.anonymizedTraceEval(req, rsp, node, "%s: View: %s%s", next, scriptLoader.getDefaultScriptExtension());
                if (1.traceable()) {
                    1.trace(req, rsp, "-> %s on <%s>", next, node);
                }
                try {
                    scriptExecutor.execute(req, rsp, script, node);
                    return true;
                }
                catch (Exception e) {
                    req.tokens.prev();
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof CancelRequestHandlingException)) continue;
                        return listener.onDispatchTrigger(req, rsp, node, next);
                    }
                    throw new ServletException((Throwable)e);
                }
            }

            @Override
            public String toString() {
                return "VIEW" + scriptLoader.getDefaultScriptExtension() + " for url=/VIEW";
            }
        };
    }

    protected <S> boolean handleIndexRequest(@NonNull AbstractTearOff<?, ? extends S, ?> scriptLoader, @NonNull ScriptExecutor<? super S> scriptExecutor, @NonNull RequestImpl req, @NonNull ResponseImpl rsp, @CheckForNull Object node) throws ServletException, IOException {
        Object script;
        try {
            script = scriptLoader.findScript("index");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (script == null) {
            return false;
        }
        Dispatcher.anonymizedTraceEval(req, rsp, node, "Index: index%s", scriptLoader.getDefaultScriptExtension());
        if (Dispatcher.traceable()) {
            Dispatcher.trace(req, rsp, "-> index on <%s>", node);
        }
        try {
            scriptExecutor.execute(req, rsp, script, node);
            return true;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @CheckForNull
    protected <S> RequestDispatcher createRequestDispatcher(@NonNull AbstractTearOff<?, ? extends S, ?> scriptLoader, @NonNull ScriptExecutor<? super S> scriptExecutor, @CheckForNull Object it, @NonNull String viewName) {
        return ScriptRequestDispatcher.newRequestDispatcher(scriptLoader, scriptExecutor, viewName, it);
    }
}

