/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchProperty;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.NameEncoder;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMHead;
import jenkins.scm.impl.NullSCMSource;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class Branch {
    private final String sourceId;
    private final SCMHead head;
    private final SCM scm;
    private final CopyOnWriteArrayList<BranchProperty> properties = new CopyOnWriteArrayList();
    private List<Action> actions;

    public Branch(String sourceId, SCMHead head, SCM scm, List<? extends BranchProperty> properties) {
        this.sourceId = sourceId;
        this.head = head;
        this.scm = scm;
        this.properties.addAll(properties);
        this.actions = new ArrayList<Action>();
    }

    private Branch(String id, SCM scm, Branch b) {
        this.sourceId = id;
        this.head = b.head;
        this.scm = scm;
        this.properties.addAll(b.properties);
        this.actions = new ArrayList<Action>(b.actions);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        return this;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.head.getName();
    }

    public String getEncodedName() {
        return NameEncoder.encode(this.getName());
    }

    @Exported
    public SCMHead getHead() {
        return this.head;
    }

    @Exported
    public SCM getScm() {
        return this.scm;
    }

    public boolean hasProperty(Class<? extends BranchProperty> clazz) {
        return this.getProperty(clazz) != null;
    }

    @CheckForNull
    public <T extends BranchProperty> T getProperty(Class<T> clazz) {
        for (BranchProperty p : this.properties) {
            if (!clazz.isInstance((Object)p)) continue;
            return (T)((Object)((BranchProperty)((Object)clazz.cast((Object)p))));
        }
        return null;
    }

    @NonNull
    public List<BranchProperty> getProperties() {
        return this.properties;
    }

    @NonNull
    public List<Action> getActions() {
        return this.actions == null ? Collections.emptyList() : Collections.unmodifiableList(this.actions);
    }

    void setActions(@NonNull List<Action> actions) {
        this.actions = new ArrayList<Action>(actions);
    }

    @CheckForNull
    public <T extends Action> T getAction(Class<T> clazz) {
        if (this.actions == null) {
            return null;
        }
        for (Action p : this.actions) {
            if (!clazz.isInstance(p)) continue;
            return (T)((Action)clazz.cast(p));
        }
        return null;
    }

    public boolean isBuildable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch branch = (Branch)o;
        if (!Objects.equals(this.sourceId, branch.sourceId)) {
            return false;
        }
        return this.head.equals((Object)branch.head);
    }

    public int hashCode() {
        int result = this.sourceId != null ? this.sourceId.hashCode() : 0;
        result = 31 * result + this.head.hashCode();
        return result;
    }

    @Extension
    public static class TransientJobActionsFactoryImpl
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull Job target) {
            MultiBranchProject p;
            BranchProjectFactory factory;
            if (target.getParent() instanceof MultiBranchProject && (factory = (p = (MultiBranchProject)target.getParent()).getProjectFactory()).isProject((Item)target)) {
                Branch b = factory.getBranch(factory.asProject((Item)target));
                return b.getActions();
            }
            return Collections.emptyList();
        }
    }

    public static class Dead
    extends Branch {
        public Dead(SCMHead name, List<? extends BranchProperty> properties) {
            super(NullSCMSource.ID, name, (SCM)new NullSCM(), properties);
        }

        public Dead(Branch b) {
            super(NullSCMSource.ID, (SCM)new NullSCM(), b);
        }

        @Override
        public boolean isBuildable() {
            return false;
        }
    }
}

