/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.cli.HelpCommand;
import hudson.cli.WhoAmICommand;
import hudson.cli.declarative.OptionHandlerExtension;
import hudson.remoting.Channel;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.spi.OptionHandler;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@ExtensionPoint.LegacyInstancesAreScopedToHudson
public abstract class CLICommand
implements ExtensionPoint,
Cloneable {
    public transient PrintStream stdout;
    public transient PrintStream stderr;
    static final String CLI_LISTPARAM_SUMMARY_ERROR_TEXT = "Error occurred while performing this command, see previous stderr output.";
    public transient InputStream stdin;
    @Deprecated
    public transient Channel channel;
    public transient Locale locale;
    @CheckForNull
    private transient Charset encoding;
    private transient Authentication transportAuth;
    private static final Logger LOGGER = Logger.getLogger(CLICommand.class.getName());
    private static final ThreadLocal<CLICommand> CURRENT_COMMAND = new ThreadLocal();

    public String getName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        if ((name = name.substring(name.lastIndexOf(36) + 1)).endsWith("Command")) {
            name = name.substring(0, name.length() - 7);
        }
        return name.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ENGLISH);
    }

    public abstract String getShortDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = new BufferedInputStream(stdin);
        this.stdout = stdout;
        this.stderr = stderr;
        this.locale = locale;
        this.registerOptionHandlers();
        CmdLineParser p = this.getCmdLineParser();
        SecurityContext sc = null;
        Authentication old = null;
        try {
            sc = SecurityContextHolder.getContext();
            old = sc.getAuthentication();
            Authentication auth = this.getTransportAuthentication2();
            sc.setAuthentication(auth);
            if (!(this instanceof HelpCommand) && !(this instanceof WhoAmICommand)) {
                Jenkins.get().checkPermission(Jenkins.READ);
            }
            p.parseArgument(args.toArray(new String[0]));
            LOGGER.log(Level.FINE, "Invoking CLI command {0}, with {1} arguments, as user {2}.", new Object[]{this.getName(), args.size(), auth.getName()});
            int res = this.run();
            LOGGER.log(Level.FINE, "Executed CLI command {0}, with {1} arguments, as user {2}, return code {3}", new Object[]{this.getName(), args.size(), auth.getName(), res});
            int n = res;
            return n;
        }
        catch (CmdLineException e) {
            this.logFailedCommandAndPrintExceptionErrorMessage(args, e);
            this.printUsage(stderr, p);
            int n = 2;
            return n;
        }
        catch (IllegalStateException e) {
            this.logFailedCommandAndPrintExceptionErrorMessage(args, e);
            int n = 4;
            return n;
        }
        catch (IllegalArgumentException e) {
            this.logFailedCommandAndPrintExceptionErrorMessage(args, e);
            int n = 3;
            return n;
        }
        catch (AbortException e) {
            this.logFailedCommandAndPrintExceptionErrorMessage(args, e);
            int n = 5;
            return n;
        }
        catch (AccessDeniedException e) {
            this.logFailedCommandAndPrintExceptionErrorMessage(args, e);
            int n = 6;
            return n;
        }
        catch (BadCredentialsException e) {
            String id = UUID.randomUUID().toString();
            this.logAndPrintError(e, "Bad Credentials. Search the server log for " + id + " for more details.", "CLI login attempt failed: " + id, Level.INFO);
            int n = 7;
            return n;
        }
        catch (Throwable e) {
            String errorMsg = "Unexpected exception occurred while performing " + this.getName() + " command.";
            this.logAndPrintError(e, errorMsg, errorMsg, Level.WARNING);
            Functions.printStackTrace(e, stderr);
            int n = 1;
            return n;
        }
        finally {
            if (sc != null) {
                sc.setAuthentication(old);
            }
        }
    }

    private void logFailedCommandAndPrintExceptionErrorMessage(List<String> args, Throwable e) {
        Authentication auth = this.getTransportAuthentication2();
        String logMessage = String.format("Failed call to CLI command %s, with %d arguments, as user %s.", this.getName(), args.size(), auth != null ? auth.getName() : "<unknown>");
        this.logAndPrintError(e, e.getMessage(), logMessage, Level.FINE);
    }

    private void logAndPrintError(Throwable e, String errorMessage, String logMessage, Level logLevel) {
        LOGGER.log(logLevel, logMessage, e);
        this.stderr.println();
        this.stderr.println("ERROR: " + errorMessage);
    }

    protected CmdLineParser getCmdLineParser() {
        return new CmdLineParser((Object)this);
    }

    @Deprecated
    public Channel checkChannel() throws AbortException {
        throw new AbortException("This command is requesting the -remoting mode which is no longer supported. See https://www.jenkins.io/redirect/cli-command-requires-channel");
    }

    public Authentication getTransportAuthentication2() {
        Authentication a = this.transportAuth;
        if (a == null) {
            a = Jenkins.ANONYMOUS2;
        }
        return a;
    }

    @Deprecated
    public org.acegisecurity.Authentication getTransportAuthentication() {
        return org.acegisecurity.Authentication.fromSpring(this.getTransportAuthentication2());
    }

    public void setTransportAuth2(Authentication transportAuth) {
        this.transportAuth = transportAuth;
    }

    @Deprecated
    public void setTransportAuth(org.acegisecurity.Authentication transportAuth) {
        this.setTransportAuth2(transportAuth.toSpring());
    }

    protected abstract int run() throws Exception;

    protected void printUsage(PrintStream stderr, CmdLineParser p) {
        stderr.print("java -jar jenkins-cli.jar " + this.getName());
        p.printSingleLineUsage((OutputStream)stderr);
        stderr.println();
        this.printUsageSummary(stderr);
        p.printUsage((OutputStream)stderr);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getSingleLineSummary() {
        Charset charset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getCmdLineParser().printSingleLineUsage((OutputStream)out);
        try {
            charset = this.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return out.toString(charset);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getUsage() {
        Charset charset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getCmdLineParser().printUsage((OutputStream)out);
        try {
            charset = this.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return out.toString(charset);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getLongDescription() {
        Charset charset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            charset = this.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        PrintStream ps = new PrintStream((OutputStream)out, false, charset);
        this.printUsageSummary(ps);
        ps.close();
        return out.toString(charset);
    }

    protected void printUsageSummary(PrintStream stderr) {
        stderr.println(this.getShortDescription());
    }

    @Deprecated
    protected String getClientSystemProperty(String name) throws IOException, InterruptedException {
        this.checkChannel();
        return null;
    }

    public void setClientCharset(@NonNull Charset encoding) {
        this.encoding = encoding;
    }

    @NonNull
    protected Charset getClientCharset() throws IOException, InterruptedException {
        if (this.encoding != null) {
            return this.encoding;
        }
        return Charset.defaultCharset();
    }

    @Deprecated
    protected String getClientEnvironmentVariable(String name) throws IOException, InterruptedException {
        this.checkChannel();
        return null;
    }

    protected CLICommand createClone() {
        try {
            return (CLICommand)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    protected void registerOptionHandlers() {
        try {
            for (Class c : Index.list(OptionHandlerExtension.class, (ClassLoader)Jenkins.get().pluginManager.uberClassLoader, Class.class)) {
                Type t = Types.getBaseClass((Type)c, OptionHandler.class);
                CmdLineParser.registerHandler((Class)Types.erasure((Type)Types.getTypeArgument((Type)t, (int)0)), (Class)c);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static ExtensionList<CLICommand> all() {
        return ExtensionList.lookup(CLICommand.class);
    }

    public static CLICommand clone(String name) {
        for (CLICommand cmd : CLICommand.all()) {
            if (!name.equals(cmd.getName())) continue;
            return cmd.createClone();
        }
        return null;
    }

    static CLICommand setCurrent(CLICommand cmd) {
        CLICommand old = CLICommand.getCurrent();
        CURRENT_COMMAND.set(cmd);
        return old;
    }

    public static CLICommand getCurrent() {
        return CURRENT_COMMAND.get();
    }

    static {
        ClassLoaders cls = new ClassLoaders();
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            cls.put(j.getPluginManager().uberClassLoader);
            ResourceNameIterator servicesIter = new DiscoverServiceNames(cls).findResourceNames(OptionHandler.class.getName());
            ResourceClassIterator itr = new DiscoverClasses(cls).findResourceClasses(servicesIter);
            while (itr.hasNext()) {
                Class h = itr.nextResourceClass().loadClass();
                Class c = Types.erasure((Type)Types.getTypeArgument((Type)Types.getBaseClass((Type)h, OptionHandler.class), (int)0));
                CmdLineParser.registerHandler((Class)c, (Class)h);
            }
        }
    }
}

