/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.lifecycle.Lifecycle;
import hudson.lifecycle.Messages;
import hudson.lifecycle.WindowsServiceLifecycle;
import hudson.model.ManagementLink;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import hudson.util.jna.DotNet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class WindowsInstallerLink
extends ManagementLink {
    private final File hudsonWar;
    private volatile File installationDir;
    private static final Logger LOGGER = Logger.getLogger(WindowsInstallerLink.class.getName());

    private WindowsInstallerLink(File jenkinsWar) {
        this.hudsonWar = jenkinsWar;
    }

    @Override
    public String getIconFileName() {
        return "symbol-windows";
    }

    @Override
    public String getUrlName() {
        return "install";
    }

    @Override
    public String getDisplayName() {
        return Messages.WindowsInstallerLink_DisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.WindowsInstallerLink_Description();
    }

    @Override
    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public boolean isInstalled() {
        return this.installationDir != null;
    }

    @RequirePOST
    public void doDoInstall(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="dir") String _dir) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.installationDir != null) {
            this.sendError("Installation is already complete", req, rsp);
            return;
        }
        if (!DotNet.isInstalled(4, 0)) {
            this.sendError(".NET Framework 4.0 or later is required for this feature", req, rsp);
            return;
        }
        File dir = new File(_dir).getAbsoluteFile();
        if (!dir.exists() && !dir.mkdirs()) {
            this.sendError("Failed to create installation directory: " + dir, req, rsp);
            return;
        }
        try {
            this.copy(req, rsp, dir, this.getClass().getResource("/windows-service/jenkins.exe"), "jenkins.exe");
            Files.deleteIfExists(Util.fileToPath(dir).resolve("jenkins.exe.config"));
            this.copy(req, rsp, dir, this.getClass().getResource("/windows-service/jenkins.xml"), "jenkins.xml");
            if (!this.hudsonWar.getCanonicalFile().equals(new File(dir, "jenkins.war").getCanonicalFile())) {
                this.copy(req, rsp, dir, this.hudsonWar.toURI().toURL(), "jenkins.war");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamTaskListener task = new StreamTaskListener(baos);
            task.getLogger().println("Installing a service");
            int r = WindowsInstallerLink.runElevated(new File(dir, "jenkins.exe"), "install", task, dir);
            if (r != 0) {
                this.sendError(baos.toString(Charset.defaultCharset()), req, rsp);
                return;
            }
            this.installationDir = dir;
            rsp.sendRedirect(".");
        }
        catch (AbortException baos) {
        }
        catch (InterruptedException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void copy(StaplerRequest req, StaplerResponse rsp, File dir, URL src, String name) throws ServletException, IOException {
        try {
            FileUtils.copyURLToFile((URL)src, (File)new File(dir, name));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to copy " + name, e);
            this.sendError("Failed to copy " + name + ": " + e.getMessage(), req, rsp);
            throw new AbortException();
        }
    }

    @RequirePOST
    public void doRestart(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.installationDir == null) {
            rsp.sendRedirect(req.getContextPath() + "/");
            return;
        }
        rsp.forward((Object)this, "_restart", req);
        final File oldRoot = Jenkins.get().getRootDir();
        new Thread("terminator"){

            @Override
            @SuppressFBWarnings(value={"DM_EXIT"}, justification="Exit is really intended.")
            public void run() {
                try {
                    Thread.sleep(1000L);
                    Runtime.getRuntime().addShutdownHook(new Thread("service starter"){

                        @Override
                        public void run() {
                            try {
                                if (!oldRoot.equals(WindowsInstallerLink.this.installationDir)) {
                                    LOGGER.info("Moving data");
                                    Move mv = new Move();
                                    Project p = new Project();
                                    p.addBuildListener((BuildListener)this.createLogger());
                                    mv.setProject(p);
                                    FileSet fs = new FileSet();
                                    fs.setDir(oldRoot);
                                    fs.setExcludes("war/**");
                                    mv.addFileset(fs);
                                    mv.setTodir(WindowsInstallerLink.this.installationDir);
                                    mv.setFailOnError(false);
                                    mv.execute();
                                }
                                LOGGER.info("Starting a Windows service");
                                StreamTaskListener task = StreamTaskListener.fromStdout();
                                int r = WindowsInstallerLink.runElevated(new File(WindowsInstallerLink.this.installationDir, "jenkins.exe"), "start", task, WindowsInstallerLink.this.installationDir);
                                task.getLogger().println((String)(r == 0 ? "Successfully started" : "start service failed. Exit code=" + r));
                            }
                            catch (IOException | InterruptedException e) {
                                e.printStackTrace();
                            }
                        }

                        private DefaultLogger createLogger() {
                            DefaultLogger logger = new DefaultLogger();
                            logger.setOutputPrintStream(System.out);
                            logger.setErrorPrintStream(System.err);
                            return logger;
                        }
                    });
                    Jenkins.get().cleanUp();
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected final void sendError(Exception e, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.sendError(e.getMessage(), req, rsp);
    }

    protected final void sendError(String message, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        req.setAttribute("message", (Object)message);
        req.setAttribute("pre", (Object)true);
        rsp.forward((Object)Jenkins.get(), "error", req);
    }

    @Extension
    public static WindowsInstallerLink registerIfApplicable() {
        if (!Functions.isWindows()) {
            return null;
        }
        if (Lifecycle.get() instanceof WindowsServiceLifecycle) {
            return null;
        }
        String war = SystemProperties.getString("executable-war");
        if (war != null && new File(war).exists()) {
            WindowsInstallerLink link = new WindowsInstallerLink(new File(war));
            if (SystemProperties.getString(WindowsInstallerLink.class.getName() + ".prominent") != null) {
                Jenkins.get().getActions().add(link);
            }
            return link;
        }
        return null;
    }

    static int runElevated(File jenkinsExe, String command, TaskListener out, File pwd) throws IOException, InterruptedException {
        return new Launcher.LocalLauncher(out).launch().cmds(jenkinsExe, command).stdout(out).pwd(pwd).join();
    }
}

