/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;

public abstract class DescriptorVisibilityFilter
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(DescriptorVisibilityFilter.class.getName());

    public boolean filterType(@NonNull Class<?> contextClass, @NonNull Descriptor descriptor) {
        return true;
    }

    public abstract boolean filter(@CheckForNull Object var1, @NonNull Descriptor var2);

    public static ExtensionList<DescriptorVisibilityFilter> all() {
        return ExtensionList.lookup(DescriptorVisibilityFilter.class);
    }

    public static <T extends Descriptor> List<T> apply(Object context, Iterable<T> source) {
        Class<?> contextClass;
        ExtensionList<DescriptorVisibilityFilter> filters = DescriptorVisibilityFilter.all();
        ArrayList<Descriptor> r = new ArrayList<Descriptor>();
        Class<?> clazz = contextClass = context == null ? null : context.getClass();
        if (source == null) {
            throw new NullPointerException("Descriptor list is null for context '" + contextClass + "' in thread '" + Thread.currentThread().getName() + "'");
        }
        block3: for (Descriptor d : source) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Determining visibility of " + d + " in context " + context);
            }
            for (DescriptorVisibilityFilter f : filters) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Querying " + f + " for visibility of " + d + " in " + context);
                }
                try {
                    if (contextClass != null && !f.filterType(contextClass, d)) {
                        if (!LOGGER.isLoggable(Level.CONFIG)) continue block3;
                        LOGGER.config("Filter " + f + " hides " + d + " in contexts of type " + contextClass);
                        continue block3;
                    }
                    if (f.filter(context, d)) continue;
                    if (!LOGGER.isLoggable(Level.CONFIG)) continue block3;
                    LOGGER.config("Filter " + f + " hides " + d + " in context " + context);
                    continue block3;
                }
                catch (Error e) {
                    LOGGER.log(Level.WARNING, "Encountered error while processing filter " + f + " for context " + context, e);
                    throw e;
                }
                catch (Throwable e) {
                    LOGGER.log(DescriptorVisibilityFilter.logLevelFor(f), "Uncaught exception from filter " + f + " for context " + context, e);
                    continue block3;
                }
            }
            r.add(d);
        }
        return r;
    }

    public static <T extends Descriptor> List<T> applyType(Class<?> contextClass, Iterable<T> source) {
        ExtensionList<DescriptorVisibilityFilter> filters = DescriptorVisibilityFilter.all();
        ArrayList<Descriptor> r = new ArrayList<Descriptor>();
        block3: for (Descriptor d : source) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Determining visibility of " + d + " in contexts of type " + contextClass);
            }
            for (DescriptorVisibilityFilter f : filters) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Querying " + f + " for visibility of " + d + " in type " + contextClass);
                }
                try {
                    if (contextClass == null || f.filterType(contextClass, d)) continue;
                    if (!LOGGER.isLoggable(Level.CONFIG)) continue block3;
                    LOGGER.config("Filter " + f + " hides " + d + " in contexts of type " + contextClass);
                    continue block3;
                }
                catch (Error e) {
                    LOGGER.log(Level.WARNING, "Encountered error while processing filter " + f + " for contexts of type " + contextClass, e);
                    throw e;
                }
                catch (Throwable e) {
                    LOGGER.log(DescriptorVisibilityFilter.logLevelFor(f), "Uncaught exception from filter " + f + " for context of type " + contextClass, e);
                    continue block3;
                }
            }
            r.add(d);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Level logLevelFor(DescriptorVisibilityFilter f) {
        Long interval = SystemProperties.getLong(DescriptorVisibilityFilter.class.getName() + ".badFilterLogWarningIntervalMinutes", 60L);
        WeakHashMap<DescriptorVisibilityFilter, Long> weakHashMap = ResourceHolder.BAD_FILTERS;
        synchronized (weakHashMap) {
            Long lastTime = ResourceHolder.BAD_FILTERS.get(f);
            if (lastTime == null || lastTime + TimeUnit.MINUTES.toMillis(interval) < System.currentTimeMillis()) {
                ResourceHolder.BAD_FILTERS.put(f, System.currentTimeMillis());
                return Level.WARNING;
            }
            return Level.FINE;
        }
    }

    private static final class ResourceHolder {
        private static final WeakHashMap<DescriptorVisibilityFilter, Long> BAD_FILTERS = new WeakHashMap();

        private ResourceHolder() {
        }
    }
}

