/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Pattern;
import jenkins.util.SystemProperties;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FileParameterValue
extends ParameterValue {
    private static final String FOLDER_NAME = "fileParameters";
    private static final Pattern PROHIBITED_DOUBLE_DOT = Pattern.compile(".*[\\\\/]\\.\\.[\\\\/].*");
    private static final long serialVersionUID = -143427023159076073L;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ALLOW_FOLDER_TRAVERSAL_OUTSIDE_WORKSPACE = SystemProperties.getBoolean(FileParameterValue.class.getName() + ".allowFolderTraversalOutsideWorkspace");
    private final transient FileItem file;
    private final String originalFileName;
    private String location;

    @DataBoundConstructor
    public FileParameterValue(String name, FileItem file) {
        this(name, file, FilenameUtils.getName((String)file.getName()));
    }

    public FileParameterValue(String name, File file, String originalFileName) {
        this(name, new FileItemImpl(file), originalFileName);
    }

    protected FileParameterValue(String name, FileItem file, String originalFileName) {
        super(name);
        this.file = file;
        this.originalFileName = originalFileName;
        this.setLocation(name);
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public Object getValue() {
        return this.file;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.originalFileName);
    }

    @Override
    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return name -> this.name.equals(name) ? this.originalFileName : null;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public FileItem getFile() {
        return this.file;
    }

    @Override
    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        return new BuildWrapper(){

            @Override
            @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
            public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                if (FileParameterValue.this.location != null && !FileParameterValue.this.location.isEmpty() && FileParameterValue.this.file.getName() != null && !FileParameterValue.this.file.getName().isEmpty()) {
                    listener.getLogger().println("Copying file to " + FileParameterValue.this.location);
                    FilePath ws = build.getWorkspace();
                    if (ws == null) {
                        throw new IllegalStateException("The workspace should be created when setUp method is called");
                    }
                    if (!(ALLOW_FOLDER_TRAVERSAL_OUTSIDE_WORKSPACE || !PROHIBITED_DOUBLE_DOT.matcher(FileParameterValue.this.location).matches() && ws.isDescendant(FileParameterValue.this.location))) {
                        listener.error("Rejecting file path escaping base directory with relative path: " + FileParameterValue.this.location);
                        return null;
                    }
                    FilePath locationFilePath = ws.child(FileParameterValue.this.location);
                    locationFilePath.getParent().mkdirs();
                    if (locationFilePath.exists() && !locationFilePath.isDirectory()) {
                        locationFilePath.delete();
                    }
                    locationFilePath.copyFrom(FileParameterValue.this.file);
                    locationFilePath.copyTo(new FilePath(FileParameterValue.this.getLocationUnderBuild(build)));
                }
                return new BuildWrapper.Environment(){};
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileParameterValue other = (FileParameterValue)obj;
        return this.location == null && other.location == null;
    }

    public String toString() {
        return "(FileParameterValue) " + this.getName() + "='" + this.originalFileName + "'";
    }

    @Override
    public String getShortDescription() {
        return this.name + "=" + this.originalFileName;
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest request, StaplerResponse response) {
        AbstractBuild build = (AbstractBuild)request.findAncestor(AbstractBuild.class).getObject();
        File fileParameter = this.getFileParameterFolderUnderBuild(build);
        return new DirectoryBrowserSupport((ModelObject)build, new FilePath(fileParameter), Messages.FileParameterValue_IndexTitle(), "folder.png", false);
    }

    private File getLocationUnderBuild(AbstractBuild build) {
        return new File(this.getFileParameterFolderUnderBuild(build), this.location);
    }

    private File getFileParameterFolderUnderBuild(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), FOLDER_NAME);
    }

    public static final class FileItemImpl
    implements FileItem {
        private final File file;

        public FileItemImpl(File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(Util.fileToPath(this.file), new OpenOption[0]);
        }

        public String getContentType() {
            return null;
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean isInMemory() {
            return false;
        }

        public long getSize() {
            return this.file.length();
        }

        public byte[] get() {
            try {
                return Files.readAllBytes(this.file.toPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.get(), encoding);
        }

        public String getString() {
            return new String(this.get(), Charset.defaultCharset());
        }

        public void write(File to) throws Exception {
            new FilePath(this.file).copyTo(new FilePath(to));
        }

        public void delete() {
            try {
                Files.deleteIfExists(this.file.toPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public String getFieldName() {
            return null;
        }

        public void setFieldName(String name) {
        }

        public boolean isFormField() {
            return false;
        }

        public void setFormField(boolean state) {
        }

        @Deprecated
        public OutputStream getOutputStream() throws IOException {
            return Files.newOutputStream(Util.fileToPath(this.file), new OpenOption[0]);
        }

        public FileItemHeaders getHeaders() {
            return new FileItemHeadersImpl();
        }

        public void setHeaders(FileItemHeaders headers) {
        }
    }
}

