/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.ModelObject;
import hudson.model.PersistenceRoot;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.access.AccessDeniedException;

public interface ItemGroup<T extends Item>
extends PersistenceRoot,
ModelObject {
    public String getFullName();

    public String getFullDisplayName();

    public Collection<T> getItems();

    default public Collection<T> getItems(Predicate<T> pred) {
        return this.getItemsStream(pred).collect(Collectors.toList());
    }

    default public Stream<T> getItemsStream() {
        return this.getItems().stream();
    }

    default public Stream<T> getItemsStream(Predicate<T> pred) {
        return this.getItemsStream().filter(pred);
    }

    public String getUrl();

    public String getUrlChildPrefix();

    @CheckForNull
    public T getItem(String var1) throws AccessDeniedException;

    public File getRootDirFor(T var1);

    default public void onRenamed(T item, String oldName, String newName) throws IOException {
    }

    public void onDeleted(T var1) throws IOException;

    default public <T extends Item> List<T> getAllItems(Class<T> type) {
        return Items.getAllItems(this, type);
    }

    default public <T extends Item> List<T> getAllItems(Class<T> type, Predicate<T> pred) {
        return Items.getAllItems(this, type, pred);
    }

    default public <T extends Item> Iterable<T> allItems(Class<T> type) {
        return Items.allItems(this, type);
    }

    default public <T extends Item> Iterable<T> allItems(Class<T> type, Predicate<T> pred) {
        return Items.allItems(this, type, pred);
    }

    default public List<Item> getAllItems() {
        return this.getAllItems(Item.class);
    }

    default public Iterable<Item> allItems() {
        return this.allItems(Item.class);
    }
}

