/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.model.Computer;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class AbstractAsyncNodeMonitorDescriptor<T>
extends AbstractNodeMonitorDescriptor<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractAsyncNodeMonitorDescriptor.class.getName());

    protected AbstractAsyncNodeMonitorDescriptor() {
    }

    protected AbstractAsyncNodeMonitorDescriptor(long interval) {
        super(interval);
    }

    protected AbstractAsyncNodeMonitorDescriptor(Class<? extends NodeMonitor> clazz) {
        super(clazz);
    }

    protected AbstractAsyncNodeMonitorDescriptor(Class<? extends NodeMonitor> clazz, long interval) {
        super(clazz, interval);
    }

    @CheckForNull
    protected abstract Callable<T, IOException> createCallable(Computer var1);

    @Override
    protected T monitor(Computer c) throws IOException, InterruptedException {
        Callable<T, IOException> cc;
        VirtualChannel ch = c.getChannel();
        if (ch != null && (cc = this.createCallable(c)) != null) {
            return (T)ch.call(cc);
        }
        return null;
    }

    @Override
    protected Map<Computer, T> monitor() throws InterruptedException {
        return this.monitorDetailed().getMonitoringData();
    }

    @NonNull
    protected final Result<T> monitorDetailed() throws InterruptedException {
        HashMap<Computer, Future> futures = new HashMap<Computer, Future>();
        HashSet<Computer> skipped = new HashSet<Computer>();
        for (Computer c : Jenkins.get().getComputers()) {
            try {
                Callable<T, IOException> cc;
                VirtualChannel ch = c.getChannel();
                futures.put(c, null);
                if (ch == null || (cc = this.createCallable(c)) == null) continue;
                futures.put(c, ch.callAsync(cc));
            }
            catch (IOException | RuntimeException e) {
                this.error(c, e);
            }
        }
        long now = System.currentTimeMillis();
        long end = now + this.getMonitoringTimeOut();
        HashMap data = new HashMap();
        for (Map.Entry e : futures.entrySet()) {
            Computer c = (Computer)e.getKey();
            java.util.concurrent.Future f = (java.util.concurrent.Future)futures.get(c);
            data.put(c, null);
            if (f != null) {
                try {
                    data.put(c, f.get(Math.max(0L, end - System.currentTimeMillis()), TimeUnit.MILLISECONDS));
                }
                catch (RuntimeException | ExecutionException | TimeoutException x) {
                    this.error(c, x);
                }
                continue;
            }
            skipped.add(c);
        }
        return new Result(data, skipped);
    }

    private void error(Computer c, Throwable x) {
        boolean cIsStillCurrent;
        boolean bl = cIsStillCurrent = Jenkins.get().getComputer(c.getName()) == c;
        if (!cIsStillCurrent) {
            return;
        }
        if (c instanceof SlaveComputer) {
            Functions.printStackTrace(x, ((SlaveComputer)c).getListener().error("Failed to monitor for " + this.getDisplayName()));
        } else {
            LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), x);
        }
    }

    protected static final class Result<T> {
        private static final long serialVersionUID = -7671448355804481216L;
        @NonNull
        private final Map<Computer, T> data;
        @NonNull
        private final ArrayList<Computer> skipped;

        private Result(@NonNull Map<Computer, T> data, @NonNull Collection<Computer> skipped) {
            this.data = new HashMap<Computer, T>(data);
            this.skipped = new ArrayList<Computer>(skipped);
        }

        @NonNull
        protected Map<Computer, T> getMonitoringData() {
            return this.data;
        }

        @NonNull
        protected List<Computer> getSkipped() {
            return this.skipped;
        }
    }
}

