/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.search.Messages;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class UserSearchProperty
extends UserProperty {
    private static final boolean DEFAULT_SEARCH_CASE_INSENSITIVE_MODE = true;
    private final boolean insensitiveSearch;

    public UserSearchProperty(boolean insensitiveSearch) {
        this.insensitiveSearch = insensitiveSearch;
    }

    @Exported
    public boolean getInsensitiveSearch() {
        return this.insensitiveSearch;
    }

    public static boolean isCaseInsensitive() {
        User user = User.current();
        if (user == null) {
            return true;
        }
        return user.getProperty(UserSearchProperty.class).getInsensitiveSearch();
    }

    @Extension
    @Symbol(value={"search"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.UserSearchProperty_DisplayName();
        }

        @Override
        public UserProperty newInstance(User user) {
            return new UserSearchProperty(true);
        }

        @Override
        public UserProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new UserSearchProperty(formData.optBoolean("insensitiveSearch"));
        }
    }
}

