/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChainedServletFilter
implements Filter {
    protected volatile Filter[] filters;
    private static final Pattern UNINTERESTING_URIS = Pattern.compile("/(images|jsbundles|css|scripts|adjuncts)/|/favicon[.](ico|svg)|/ajax");
    private static final Logger LOGGER = Logger.getLogger(ChainedServletFilter.class.getName());

    public ChainedServletFilter() {
        this.filters = new Filter[0];
    }

    public ChainedServletFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public ChainedServletFilter(Collection<? extends Filter> filters) {
        this.setFilters(filters);
    }

    public void setFilters(Collection<? extends Filter> filters) {
        this.filters = filters.toArray(new Filter[0]);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            for (Filter f : this.filters) {
                LOGGER.finest("ChainedServletFilter contains: " + f);
            }
        }
        for (Filter f : this.filters) {
            f.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        final String uri = request instanceof HttpServletRequest ? ((HttpServletRequest)request).getRequestURI() : "?";
        final Level level = UNINTERESTING_URIS.matcher(uri).find() ? Level.FINER : Level.FINE;
        LOGGER.log(level, () -> "starting filter on " + uri);
        new FilterChain(){
            private int position = 0;
            private final Filter[] filters;
            {
                this.filters = ChainedServletFilter.this.filters;
            }

            public void doFilter(ServletRequest request, ServletResponse response2) throws IOException, ServletException {
                if (this.position == this.filters.length) {
                    LOGGER.log(level, () -> uri + " end: " + this.status());
                    chain.doFilter(request, response2);
                } else {
                    Filter next = this.filters[this.position++];
                    try {
                        LOGGER.log(level, () -> uri + " @" + this.position + " " + next + " \u00bb");
                        next.doFilter(request, response2, (FilterChain)this);
                        LOGGER.log(level, () -> uri + " @" + this.position + " " + next + " \u00ab success: " + this.status());
                    }
                    catch (IOException | RuntimeException | ServletException x) {
                        LOGGER.log(level, () -> this.lambda$doFilter$3(uri, next, (Exception)x));
                        throw x;
                    }
                }
            }

            private int status() {
                return response instanceof HttpServletResponse ? ((HttpServletResponse)response).getStatus() : 0;
            }

            private /* synthetic */ String lambda$doFilter$3(String uri2, Filter next, Exception x) {
                return uri2 + " @" + this.position + " " + next + " \u00ab " + x + ": " + this.status();
            }
        }.doFilter(request, response);
    }

    public void destroy() {
        for (Filter f : this.filters) {
            f.destroy();
        }
    }
}

