/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ComputerSet;
import hudson.model.Environment;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Messages;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class EnvironmentVariablesNodeProperty
extends NodeProperty<Node> {
    private final EnvVars envVars;

    @DataBoundConstructor
    public EnvironmentVariablesNodeProperty(List<Entry> env) {
        this.envVars = EnvironmentVariablesNodeProperty.toMap(env);
    }

    public EnvironmentVariablesNodeProperty(Entry ... env) {
        this(Arrays.asList(env));
    }

    public EnvVars getEnvVars() {
        return this.envVars;
    }

    public List<Entry> getEnv() {
        return this.envVars.entrySet().stream().map(x$0 -> new Entry((Map.Entry<String, String>)x$0)).collect(Collectors.toList());
    }

    @Override
    public Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return Environment.create(this.envVars);
    }

    @Override
    public void buildEnvVars(EnvVars env, TaskListener listener) throws IOException, InterruptedException {
        env.putAll(this.envVars);
    }

    private static EnvVars toMap(List<Entry> entries) {
        EnvVars map = new EnvVars();
        if (entries != null) {
            for (Entry entry : entries) {
                map.put(entry.key, entry.value);
            }
        }
        return map;
    }

    public static class Entry {
        public String key;
        public String value;

        private Entry(Map.Entry<String, String> e) {
            this(e.getKey(), e.getValue());
        }

        @DataBoundConstructor
        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    @Extension
    @Symbol(value={"envVars"})
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.EnvironmentVariablesNodeProperty_displayName();
        }

        public String getHelpPage() {
            ComputerSet object = (ComputerSet)Stapler.getCurrentRequest().findAncestorObject(ComputerSet.class);
            if (object != null) {
                return "/help/system-config/nodeEnvironmentVariables.html";
            }
            return "/help/system-config/globalEnvironmentVariables.html";
        }
    }
}

