/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Fingerprinter;
import hudson.tasks.LogRotator;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.BuildDiscarder;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.BuildListenerAdapter;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ArtifactArchiver
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOG = Logger.getLogger(ArtifactArchiver.class.getName());
    private String artifacts;
    private String excludes;
    @Deprecated
    private Boolean latestOnly;
    @NonNull
    private Boolean allowEmptyArchive;
    private boolean onlyIfSuccessful;
    private boolean fingerprint;
    @NonNull
    private Boolean defaultExcludes = true;
    @NonNull
    private Boolean caseSensitive = true;
    @NonNull
    private Boolean followSymlinks = true;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static volatile DescriptorImpl DESCRIPTOR;

    @DataBoundConstructor
    public ArtifactArchiver(String artifacts) {
        this.artifacts = artifacts.trim();
        this.allowEmptyArchive = false;
    }

    @Deprecated
    public ArtifactArchiver(String artifacts, String excludes, boolean latestOnly) {
        this(artifacts, excludes, latestOnly, false, false);
    }

    @Deprecated
    public ArtifactArchiver(String artifacts, String excludes, boolean latestOnly, boolean allowEmptyArchive) {
        this(artifacts, excludes, latestOnly, allowEmptyArchive, false);
    }

    @Deprecated
    public ArtifactArchiver(String artifacts, String excludes, boolean latestOnly, boolean allowEmptyArchive, boolean onlyIfSuccessful) {
        this(artifacts, excludes, latestOnly, allowEmptyArchive, onlyIfSuccessful, true);
    }

    @Deprecated
    public ArtifactArchiver(String artifacts, String excludes, boolean latestOnly, boolean allowEmptyArchive, boolean onlyIfSuccessful, Boolean defaultExcludes) {
        this(artifacts);
        this.setExcludes(excludes);
        this.latestOnly = latestOnly;
        this.setAllowEmptyArchive(allowEmptyArchive);
        this.setOnlyIfSuccessful(onlyIfSuccessful);
        this.setDefaultExcludes(defaultExcludes);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Null checks in readResolve are valid since we deserialize and upgrade objects")
    protected Object readResolve() {
        if (this.allowEmptyArchive == null) {
            this.allowEmptyArchive = SystemProperties.getBoolean(ArtifactArchiver.class.getName() + ".warnOnEmpty");
        }
        if (this.defaultExcludes == null) {
            this.defaultExcludes = true;
        }
        if (this.caseSensitive == null) {
            this.caseSensitive = true;
        }
        if (this.followSymlinks == null) {
            this.followSymlinks = true;
        }
        return this;
    }

    public String getArtifacts() {
        return this.artifacts;
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public final void setExcludes(@CheckForNull String excludes) {
        this.excludes = Util.fixEmptyAndTrim(excludes);
    }

    @Deprecated
    public boolean isLatestOnly() {
        return this.latestOnly != null ? this.latestOnly : false;
    }

    public boolean isOnlyIfSuccessful() {
        return this.onlyIfSuccessful;
    }

    @DataBoundSetter
    public final void setOnlyIfSuccessful(boolean onlyIfSuccessful) {
        this.onlyIfSuccessful = onlyIfSuccessful;
    }

    public boolean isFingerprint() {
        return this.fingerprint;
    }

    @DataBoundSetter
    public void setFingerprint(boolean fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean getAllowEmptyArchive() {
        return this.allowEmptyArchive;
    }

    @DataBoundSetter
    public final void setAllowEmptyArchive(boolean allowEmptyArchive) {
        this.allowEmptyArchive = allowEmptyArchive;
    }

    public boolean isDefaultExcludes() {
        return this.defaultExcludes;
    }

    @DataBoundSetter
    public final void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @DataBoundSetter
    public final void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    @DataBoundSetter
    public final void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    @Override
    public void perform(Run<?, ?> build, FilePath ws, EnvVars environment, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        block12: {
            if (this.artifacts.isEmpty()) {
                throw new AbortException(Messages.ArtifactArchiver_NoIncludes());
            }
            Result result = build.getResult();
            if (this.onlyIfSuccessful && result != null && result.isWorseThan(Result.UNSTABLE)) {
                listener.getLogger().println(Messages.ArtifactArchiver_SkipBecauseOnlyIfSuccessful());
                return;
            }
            listener.getLogger().println(Messages.ArtifactArchiver_ARCHIVING_ARTIFACTS());
            try {
                Map<String, String> files;
                String artifacts = this.artifacts;
                if (build instanceof AbstractBuild) {
                    artifacts = environment.expand(artifacts);
                }
                if (!(files = ws.act(new ListFiles(artifacts, this.excludes, this.defaultExcludes, this.caseSensitive, this.followSymlinks))).isEmpty()) {
                    build.pickArtifactManager().archive(ws, launcher, BuildListenerAdapter.wrap(listener), files);
                    if (this.fingerprint) {
                        Fingerprinter f = new Fingerprinter(artifacts);
                        f.setExcludes(this.excludes);
                        f.setDefaultExcludes(this.defaultExcludes);
                        f.setCaseSensitive(this.caseSensitive);
                        f.perform(build, ws, environment, launcher, listener);
                    }
                    break block12;
                }
                result = build.getResult();
                if (result != null && !result.isBetterOrEqualTo(Result.UNSTABLE)) break block12;
                try {
                    String msg = ws.validateAntFileMask(artifacts, FilePath.VALIDATE_ANT_FILE_MASK_BOUND, this.caseSensitive);
                    if (msg != null) {
                        listener.getLogger().println(msg);
                    }
                }
                catch (FilePath.FileMaskNoMatchesFoundException e) {
                    listener.getLogger().println(e.getMessage());
                }
                catch (Exception e) {
                    Functions.printStackTrace((Throwable)e, listener.getLogger());
                }
                if (this.allowEmptyArchive.booleanValue()) {
                    listener.getLogger().println(Messages.ArtifactArchiver_NoMatchFound(artifacts));
                    break block12;
                }
                throw new AbortException(Messages.ArtifactArchiver_NoMatchFound(artifacts));
            }
            catch (AccessDeniedException e) {
                LOG.log(Level.FINE, "Diagnosing anticipated Exception", e);
                throw new AbortException(e.toString());
            }
        }
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class Migrator
    extends ItemListener {
        @Override
        public void onLoaded() {
            for (AbstractProject p : Jenkins.get().allItems(AbstractProject.class)) {
                try {
                    Fingerprinter f;
                    ArtifactArchiver aa = (ArtifactArchiver)p.getPublishersList().get(ArtifactArchiver.class);
                    if (aa != null && aa.latestOnly != null) {
                        if (aa.latestOnly.booleanValue()) {
                            BuildDiscarder bd = p.getBuildDiscarder();
                            if (bd instanceof LogRotator) {
                                LogRotator lr = (LogRotator)bd;
                                if (lr.getArtifactNumToKeep() == -1) {
                                    p.setBuildDiscarder(new LogRotator(lr.getDaysToKeep(), lr.getNumToKeep(), lr.getArtifactDaysToKeep(), 1));
                                } else {
                                    LOG.log(Level.WARNING, "will not clobber artifactNumToKeep={0} in {1}", new Object[]{lr.getArtifactNumToKeep(), p});
                                }
                            } else if (bd == null) {
                                p.setBuildDiscarder(new LogRotator(-1, -1, -1, 1));
                            } else {
                                LOG.log(Level.WARNING, "unrecognized BuildDiscarder {0} in {1}", new Object[]{bd, p});
                            }
                        }
                        aa.latestOnly = null;
                        p.save();
                    }
                    if ((f = (Fingerprinter)p.getPublishersList().get(Fingerprinter.class)) == null || !f.getRecordBuildArtifacts()) continue;
                    f.recordBuildArtifacts = null;
                    if (aa != null) {
                        aa.setFingerprint(true);
                    }
                    if (f.getTargets().isEmpty()) {
                        p.getPublishersList().remove(f);
                    }
                    p.save();
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, "could not migrate " + p, x);
                }
            }
        }
    }

    @Extension
    @Symbol(value={"archiveArtifacts"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ArtifactArchiver_DisplayName();
        }

        public FormValidation doCheckArtifacts(@AncestorInPath AbstractProject project, @QueryParameter String value, @QueryParameter(value="caseSensitive") String caseSensitive) throws IOException {
            if (project == null) {
                return FormValidation.ok();
            }
            boolean bCaseSensitive = !"false".equals(caseSensitive);
            return FilePath.validateFileMask(project.getSomeWorkspace(), value, bCaseSensitive);
        }

        @Override
        public ArtifactArchiver newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ArtifactArchiver)req.bindJSON(ArtifactArchiver.class, formData);
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    private static final class ListFiles
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private final String includes;
        private final String excludes;
        private final boolean defaultExcludes;
        private final boolean caseSensitive;
        private final boolean followSymlinks;

        ListFiles(String includes, String excludes, boolean defaultExcludes, boolean caseSensitive, boolean followSymlinks) {
            this.includes = includes;
            this.excludes = excludes;
            this.defaultExcludes = defaultExcludes;
            this.caseSensitive = caseSensitive;
            this.followSymlinks = followSymlinks;
        }

        @Override
        public Map<String, String> invoke(File basedir, VirtualChannel channel) throws IOException, InterruptedException {
            HashMap<String, String> r = new HashMap<String, String>();
            FileSet fileSet = Util.createFileSet(basedir, this.includes, this.excludes);
            fileSet.setDefaultexcludes(this.defaultExcludes);
            fileSet.setCaseSensitive(this.caseSensitive);
            fileSet.setFollowSymlinks(this.followSymlinks);
            for (String f : fileSet.getDirectoryScanner().getIncludedFiles()) {
                f = f.replace(File.separatorChar, '/');
                r.put(f, f);
            }
            return r;
        }
    }
}

