/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AdministrativeMonitor;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.PersistentDescriptor;
import hudson.model.Run;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.triggers.Messages;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DaemonThreadFactory;
import hudson.util.FlushProofOutputStream;
import hudson.util.FormValidation;
import hudson.util.NamingThreadFactory;
import hudson.util.SequentialExecutionQueue;
import hudson.util.StreamTaskListener;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.scm.SCMDecisionHandler;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SCMTrigger
extends Trigger<Item> {
    private boolean ignorePostCommitHooks;
    private static final Logger LOGGER = Logger.getLogger(SCMTrigger.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static long STARVATION_THRESHOLD = SystemProperties.getLong(SCMTrigger.class.getName() + ".starvationThreshold", TimeUnit.HOURS.toMillis(1L));

    @DataBoundConstructor
    public SCMTrigger(String scmpoll_spec) {
        super(scmpoll_spec);
    }

    @Deprecated
    public SCMTrigger(String scmpoll_spec, boolean ignorePostCommitHooks) {
        super(scmpoll_spec);
        this.ignorePostCommitHooks = ignorePostCommitHooks;
    }

    public boolean isIgnorePostCommitHooks() {
        return this.ignorePostCommitHooks;
    }

    @DataBoundSetter
    public void setIgnorePostCommitHooks(boolean ignorePostCommitHooks) {
        this.ignorePostCommitHooks = ignorePostCommitHooks;
    }

    public String getScmpoll_spec() {
        return super.getSpec();
    }

    @Override
    public void run() {
        if (this.job == null) {
            return;
        }
        this.run(null);
    }

    public void run(Action[] additionalActions) {
        if (this.job == null) {
            return;
        }
        DescriptorImpl d = this.getDescriptor();
        LOGGER.fine("Scheduling a polling for " + this.job);
        if (d.synchronousPolling) {
            LOGGER.fine("Running the trigger directly without threading, as it's already taken care of by Trigger.Cron");
            new Runner(additionalActions).run();
        } else {
            LOGGER.fine("scheduling the trigger to (asynchronously) run");
            d.queue.execute(new Runner(additionalActions));
            d.clogCheck();
        }
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public Collection<? extends Action> getProjectActions() {
        if (this.job == null) {
            return Collections.emptyList();
        }
        return Set.of(new SCMAction());
    }

    public File getLogFile() {
        return new File(Objects.requireNonNull(this.job).getRootDir(), "scm-polling.log");
    }

    private SCMTriggerItem job() {
        return SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(this.job);
    }

    public static class SCMTriggerCause
    extends Cause {
        @CheckForNull
        private String pollingLog;
        private transient Run run;

        public SCMTriggerCause(File logFile) throws IOException {
            this(Files.readString(Util.fileToPath(logFile), Charset.defaultCharset()));
        }

        public SCMTriggerCause(String pollingLog) {
            this.pollingLog = pollingLog;
        }

        @Deprecated
        public SCMTriggerCause() {
            this("");
        }

        public void onLoad(Run run) {
            this.run = run;
        }

        @Override
        public void onAddedTo(Run build) {
            this.run = build;
            try {
                BuildAction a = new BuildAction(build);
                if (this.pollingLog != null) {
                    Files.writeString(Util.fileToPath(a.getPollingLogFile()), (CharSequence)this.pollingLog, Charset.defaultCharset(), new OpenOption[0]);
                }
                build.replaceAction(a);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to persist the polling log", e);
            }
            this.pollingLog = null;
        }

        @Override
        public String getShortDescription() {
            return Messages.SCMTrigger_SCMTriggerCause_ShortDescription();
        }

        @Restricted(value={DoNotUse.class})
        public Run getRun() {
            return this.run;
        }

        public boolean equals(Object o) {
            return o instanceof SCMTriggerCause;
        }

        public int hashCode() {
            return 3;
        }
    }

    public class Runner
    implements Runnable {
        private volatile long startTime;
        private Action[] additionalActions;

        public Runner() {
            this(null);
        }

        public Runner(Action[] actions) {
            Objects.requireNonNull(SCMTrigger.this.job, "Runner can't be instantiated when job is null");
            this.additionalActions = actions == null ? new Action[0] : Arrays.copyOf(actions, actions.length);
        }

        public File getLogFile() {
            return SCMTrigger.this.getLogFile();
        }

        public SCMTriggerItem getTarget() {
            return SCMTrigger.this.job();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getDuration() {
            return Util.getTimeSpanString(System.currentTimeMillis() - this.startTime);
        }

        private boolean runPolling() {
            boolean bl;
            StreamTaskListener listener = new StreamTaskListener(this.getLogFile(), Charset.defaultCharset());
            try {
                PrintStream logger = listener.getLogger();
                long start = System.currentTimeMillis();
                logger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
                boolean result = SCMTrigger.this.job().poll(listener).hasChanges();
                logger.println("Done. Took " + Util.getTimeSpanString(System.currentTimeMillis() - start));
                if (result) {
                    logger.println("Changes found");
                } else {
                    logger.println("No changes");
                }
                bl = result;
            }
            catch (Error | RuntimeException e) {
                try {
                    try {
                        Functions.printStackTrace(e, listener.error("Failed to record SCM polling for " + SCMTrigger.this.job));
                        LOGGER.log(Level.SEVERE, "Failed to record SCM polling for " + SCMTrigger.this.job, e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        listener.close();
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    LOGGER.log(Level.SEVERE, "Failed to record SCM polling for " + SCMTrigger.this.job, e2);
                    return false;
                }
            }
            listener.close();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                if (SCMTrigger.this.job == null) {
                    return;
                }
                SCMDecisionHandler veto = SCMDecisionHandler.firstShouldPollVeto(SCMTrigger.this.job);
                if (veto != null) {
                    try (StreamTaskListener listener = new StreamTaskListener(this.getLogFile(), Charset.defaultCharset());){
                        listener.getLogger().println("Skipping polling on " + DateFormat.getDateTimeInstance().format(new Date()) + " due to veto from " + veto);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Failed to record SCM polling for " + SCMTrigger.this.job, e);
                    }
                    LOGGER.log(Level.FINE, "Skipping polling for {0} due to veto from {1}", new Object[]{SCMTrigger.this.job.getFullDisplayName(), veto});
                    return;
                }
                String threadName = Thread.currentThread().getName();
                Thread.currentThread().setName("SCM polling for " + SCMTrigger.this.job);
                try {
                    SCMTriggerCause cause;
                    this.startTime = System.currentTimeMillis();
                    if (!this.runPolling()) break block17;
                    SCMTriggerItem p = SCMTrigger.this.job();
                    String name = " #" + p.getNextBuildNumber();
                    try {
                        cause = new SCMTriggerCause(this.getLogFile());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to parse the polling log", e);
                        cause = new SCMTriggerCause();
                    }
                    Action[] queueActions = new Action[this.additionalActions.length + 1];
                    queueActions[0] = new CauseAction((Cause)cause);
                    System.arraycopy(this.additionalActions, 0, queueActions, 1, this.additionalActions.length);
                    if (p.scheduleBuild2(p.getQuietPeriod(), queueActions) != null) {
                        LOGGER.info("SCM changes detected in " + SCMTrigger.this.job.getFullDisplayName() + ". Triggering " + name);
                    } else {
                        LOGGER.info("SCM changes detected in " + SCMTrigger.this.job.getFullDisplayName() + ". Job is already in the queue");
                    }
                }
                finally {
                    Thread.currentThread().setName(threadName);
                }
            }
        }

        public boolean equals(Object that) {
            return that instanceof Runner && SCMTrigger.this.job == ((Runner)that)._job();
        }

        private Item _job() {
            return SCMTrigger.this.job;
        }

        public int hashCode() {
            return Objects.requireNonNull(SCMTrigger.this.job).hashCode();
        }
    }

    public final class SCMAction
    implements Action {
        public AbstractProject<?, ?> getOwner() {
            Item item = this.getItem();
            return item instanceof AbstractProject ? (AbstractProject)item : null;
        }

        public Item getItem() {
            return SCMTrigger.this.job().asItem();
        }

        @Override
        public String getIconFileName() {
            return "clipboard.png";
        }

        @Override
        public String getDisplayName() {
            HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
            for (SCM sCM : SCMTrigger.this.job().getSCMs()) {
                descriptors.add(sCM.getDescriptor());
            }
            return descriptors.size() == 1 ? Messages.SCMTrigger_getDisplayName(((SCMDescriptor)descriptors.iterator().next()).getDisplayName()) : Messages.SCMTrigger_BuildAction_DisplayName();
        }

        @Override
        public String getUrlName() {
            return "scmPollLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile(SCMTrigger.this.getLogFile(), Charset.defaultCharset());
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="method signature does not permit plumbing through the return value")
        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText<SCMAction>(SCMTrigger.this.getLogFile(), Charset.defaultCharset(), true, this).writeHtmlTo(0L, out.asWriter());
        }
    }

    public static class BuildAction
    implements RunAction2 {
        private transient Run<?, ?> run;
        @Deprecated
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="for backward compatibility")
        public transient AbstractBuild build;

        public BuildAction(Run<?, ?> run) {
            this.run = run;
            this.build = run instanceof AbstractBuild ? (AbstractBuild)run : null;
        }

        @Deprecated
        public BuildAction(AbstractBuild build) {
            this((Run<?, ?>)build);
        }

        public Run<?, ?> getRun() {
            return this.run;
        }

        public File getPollingLogFile() {
            return new File(this.run.getRootDir(), "polling.log");
        }

        @Override
        public String getIconFileName() {
            return "clipboard.png";
        }

        @Override
        public String getDisplayName() {
            return Messages.SCMTrigger_BuildAction_DisplayName();
        }

        @Override
        public String getUrlName() {
            return "pollingLog";
        }

        public void doPollingLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
            rsp.setContentType("text/plain;charset=UTF-8");
            try (OutputStream os = rsp.getCompressedOutputStream((HttpServletRequest)req);
                 FlushProofOutputStream out = new FlushProofOutputStream(os);){
                this.getPollingLogText().writeLogTo(0L, out);
            }
        }

        public AnnotatedLargeText getPollingLogText() {
            return new AnnotatedLargeText<BuildAction>(this.getPollingLogFile(), Charset.defaultCharset(), true, this);
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="method signature does not permit plumbing through the return value")
        public void writePollingLogTo(long offset, XMLOutput out) throws IOException {
            this.getPollingLogText().writeHtmlTo(offset, out.asWriter());
        }

        @Override
        public void onAttached(Run<?, ?> r) {
        }

        @Override
        public void onLoad(Run<?, ?> r) {
            this.run = r;
            this.build = this.run instanceof AbstractBuild ? (AbstractBuild)this.run : null;
        }
    }

    @Extension
    public static final class AdministrativeMonitorImpl
    extends AdministrativeMonitor {
        private boolean on;

        @Override
        public String getDisplayName() {
            return Messages.SCMTrigger_AdministrativeMonitorImpl_DisplayName();
        }

        @Override
        public boolean isActivated() {
            return this.on;
        }
    }

    @Extension
    @Symbol(value={"pollSCM"})
    public static class DescriptorImpl
    extends TriggerDescriptor
    implements PersistentDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor(DescriptorImpl.threadFactory()));
        public boolean synchronousPolling = false;
        private int maximumThreads = 10;
        private static final int THREADS_LOWER_BOUND = 5;
        private static final int THREADS_UPPER_BOUND = 100;
        private static final int THREADS_DEFAULT = 10;

        private static ThreadFactory threadFactory() {
            return new NamingThreadFactory(new DaemonThreadFactory(), "SCMTrigger");
        }

        private Object readResolve() {
            if (this.maximumThreads == 0) {
                this.maximumThreads = 10;
            }
            return this;
        }

        @Override
        public boolean isApplicable(Item item) {
            return SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(item) != null;
        }

        public ExecutorService getExecutor() {
            return this.queue.getExecutors();
        }

        public boolean isClogged() {
            return this.queue.isStarving(STARVATION_THRESHOLD);
        }

        public void clogCheck() {
            AdministrativeMonitor.all().get(AdministrativeMonitorImpl.class).on = this.isClogged();
        }

        public List<Runner> getRunners() {
            return Util.filter(this.queue.getInProgress(), Runner.class);
        }

        public List<SCMTriggerItem> getItemsBeingPolled() {
            ArrayList<SCMTriggerItem> r = new ArrayList<SCMTriggerItem>();
            for (Runner i : this.getRunners()) {
                r.add(i.getTarget());
            }
            return r;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SCMTrigger_DisplayName();
        }

        public int getPollingThreadCount() {
            return this.maximumThreads;
        }

        public void setPollingThreadCount(int n) {
            if (n < 5) {
                n = 5;
            }
            if (n > 100) {
                n = 100;
            }
            this.maximumThreads = n;
            this.resizeThreadPool();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isPollingThreadCountOptionVisible() {
            if (this.getPollingThreadCount() != 10) {
                return true;
            }
            int count = 0;
            for (Item item : Jenkins.get().allItems(Item.class)) {
                if (!(item instanceof SCMTriggerItem) || ++count <= 10) continue;
                return true;
            }
            return false;
        }

        @PostConstruct
        synchronized void resizeThreadPool() {
            this.queue.setExecutors(Executors.newFixedThreadPool(this.maximumThreads, DescriptorImpl.threadFactory()));
        }

        @Override
        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            String t = json.optString("pollingThreadCount", null);
            if (this.doCheckPollingThreadCount((String)t).kind != FormValidation.Kind.OK) {
                this.setPollingThreadCount(10);
            } else {
                this.setPollingThreadCount(Integer.parseInt(t));
            }
            this.save();
            return true;
        }

        public FormValidation doCheckPollingThreadCount(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange(value, 5, 100);
        }

        public FormValidation doCheckScmpoll_spec(@QueryParameter String value, @QueryParameter boolean ignorePostCommitHooks, @AncestorInPath Item item) {
            if (StringUtils.isBlank((String)value)) {
                if (ignorePostCommitHooks) {
                    return FormValidation.ok(Messages.SCMTrigger_no_schedules_no_hooks());
                }
                return FormValidation.ok(Messages.SCMTrigger_no_schedules_hooks());
            }
            return Jenkins.get().getDescriptorByType(TimerTrigger.DescriptorImpl.class).doCheckSpec(value, item);
        }
    }
}

