/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DependencyRunner;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Item;
import hudson.model.PeriodicWork;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.triggers.SCMTrigger;
import hudson.triggers.SlowTriggerAdminMonitor;
import hudson.triggers.TriggerDescriptor;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.triggers.TriggeredItem;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Trigger<J extends Item>
implements Describable<Trigger<?>>,
ExtensionPoint {
    protected final String spec;
    protected transient CronTabList tabs;
    @CheckForNull
    protected transient J job;
    private static Future previousSynchronousPolling;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    @RestrictedSince(value="2.289")
    public static long CRON_THRESHOLD;
    private static final Logger LOGGER;
    @Deprecated
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"}, justification="for backward compatibility")
    @CheckForNull
    public static Timer timer;

    public void start(J project, boolean newInstance) {
        LOGGER.finer(() -> "Starting " + this + " on " + project);
        this.job = project;
        try {
            if (this.spec != null) {
                this.tabs = CronTabList.create(this.spec, Hash.from(project.getFullName()));
            } else {
                LOGGER.log(Level.WARNING, "The job {0} has a null crontab spec which is incorrect", this.job.getFullName());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, String.format("Failed to parse crontab spec %s in job %s", this.spec, project.getFullName()), e);
        }
    }

    public void run() {
    }

    public void stop() {
    }

    @Deprecated
    public Action getProjectAction() {
        return null;
    }

    public Collection<? extends Action> getProjectActions() {
        Action a = this.getProjectAction();
        if (a == null) {
            return Collections.emptyList();
        }
        return List.of(a);
    }

    public TriggerDescriptor getDescriptor() {
        return (TriggerDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    protected Trigger(@NonNull String cronTabSpec) {
        this.spec = cronTabSpec;
        this.tabs = CronTabList.create(cronTabSpec);
    }

    protected Trigger() {
        this.spec = "";
        this.tabs = new CronTabList(Collections.emptyList());
    }

    public final String getSpec() {
        return this.spec;
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            this.tabs = CronTabList.create(this.spec);
        }
        catch (IllegalArgumentException e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
        return this;
    }

    public String toString() {
        return super.toString() + "[" + this.spec + "]";
    }

    public static void checkTriggers(Calendar cal) {
        Jenkins inst = Jenkins.get();
        SCMTrigger.DescriptorImpl scmd = inst.getDescriptorByType(SCMTrigger.DescriptorImpl.class);
        if (scmd.synchronousPolling) {
            LOGGER.fine("using synchronous polling");
            if (previousSynchronousPolling == null || previousSynchronousPolling.isDone()) {
                previousSynchronousPolling = scmd.getExecutor().submit(new DependencyRunner(new DependencyRunner.ProjectRunnable(){

                    @Override
                    public void run(AbstractProject p) {
                        for (Trigger<?> t : p.getTriggers().values()) {
                            if (!(t instanceof SCMTrigger)) continue;
                            if (t.job != null) {
                                LOGGER.fine("synchronously triggering SCMTrigger for project " + t.job.getName());
                            } else {
                                LOGGER.fine("synchronously triggering SCMTrigger for unknown project");
                            }
                            t.run();
                        }
                    }
                }));
            } else {
                LOGGER.fine("synchronous polling has detected unfinished jobs, will not trigger additional jobs.");
            }
        }
        for (TriggeredItem p : inst.allItems(TriggeredItem.class)) {
            LOGGER.finer(() -> "considering " + p);
            for (Trigger<?> t : p.getTriggers().values()) {
                LOGGER.finer(() -> "found trigger " + t);
                if (p instanceof AbstractProject && t instanceof SCMTrigger && scmd.synchronousPolling) continue;
                if (t != null && t.spec != null && t.tabs != null) {
                    LOGGER.log(Level.FINE, "cron checking {0} with spec \u2018{1}\u2019", new Object[]{p, t.spec.trim()});
                    if (t.tabs.check(cal)) {
                        LOGGER.log(Level.CONFIG, "cron triggered {0}", p);
                        try {
                            long begin_time = System.currentTimeMillis();
                            if (t.job == null) {
                                LOGGER.fine(() -> t + " not yet started on " + p + " but trying to run anyway");
                            }
                            t.run();
                            long end_time = System.currentTimeMillis();
                            if (end_time - begin_time <= CRON_THRESHOLD * 1000L) continue;
                            TriggerDescriptor descriptor = t.getDescriptor();
                            String name = descriptor.getDisplayName();
                            String msg = String.format("Trigger '%s' triggered by '%s' (%s) spent too much time (%s) in its execution, other timers could be delayed.", name, p.getFullDisplayName(), p.getFullName(), Util.getTimeSpanString(end_time - begin_time));
                            LOGGER.log(Level.WARNING, msg);
                            SlowTriggerAdminMonitor.getInstance().report(descriptor.getClass(), p.getFullName(), end_time - begin_time);
                        }
                        catch (Throwable e) {
                            LOGGER.log(Level.WARNING, t.getClass().getName() + ".run() failed for " + p, e);
                        }
                        continue;
                    }
                    LOGGER.log(Level.FINER, "did not trigger {0}", p);
                    continue;
                }
                LOGGER.log(Level.WARNING, "The job {0} has a syntactically incorrect config and is missing the cron spec for a trigger", p.getFullName());
            }
        }
    }

    public static DescriptorExtensionList<Trigger<?>, TriggerDescriptor> all() {
        return Jenkins.get().getDescriptorList(Trigger.class);
    }

    public static List<TriggerDescriptor> for_(Item i) {
        ArrayList<TriggerDescriptor> r = new ArrayList<TriggerDescriptor>();
        for (TriggerDescriptor t : Trigger.all()) {
            TopLevelItemDescriptor tld;
            if (!t.isApplicable(i) || i instanceof TopLevelItem && (tld = ((TopLevelItem)i).getDescriptor()) != null && !tld.isApplicable(t)) continue;
            r.add(t);
        }
        return r;
    }

    static {
        CRON_THRESHOLD = SystemProperties.getLong(Trigger.class.getName() + ".CRON_THRESHOLD", 30L);
        LOGGER = Logger.getLogger(Trigger.class.getName());
    }

    @Extension
    @Symbol(value={"cron"})
    public static class Cron
    extends PeriodicWork {
        private final Calendar cal = new GregorianCalendar();

        public Cron() {
            this.cal.set(13, 0);
            this.cal.set(14, 0);
        }

        @Override
        public long getRecurrencePeriod() {
            return 60000L;
        }

        @Override
        public long getInitialDelay() {
            return 60000L - TimeUnit.SECONDS.toMillis(Calendar.getInstance().get(13));
        }

        @Override
        public void doRun() {
            while (new Date().getTime() >= this.cal.getTimeInMillis()) {
                LOGGER.log(Level.FINE, "cron checking {0}", this.cal.getTime());
                try {
                    Trigger.checkTriggers(this.cal);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Cron thread throw an exception", e);
                }
                this.cal.add(12, 1);
            }
        }
    }
}

