/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.Messages;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public final class StatusFilter
extends ViewJobFilter {
    private final boolean statusFilter;

    @DataBoundConstructor
    public StatusFilter(boolean statusFilter) {
        this.statusFilter = statusFilter;
    }

    @Override
    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> filtered = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : added) {
            if (item instanceof ParameterizedJobMixIn.ParameterizedJob && !(((ParameterizedJobMixIn.ParameterizedJob)((Object)item)).isDisabled() ^ this.statusFilter)) continue;
            filtered.add(item);
        }
        return filtered;
    }

    public boolean getStatusFilter() {
        return this.statusFilter;
    }

    @Extension
    public static class StatusFilterDescriptor
    extends Descriptor<ViewJobFilter> {
        public StatusFilterDescriptor() {
            super(StatusFilter.class);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.StatusFilter_DisplayName();
        }
    }
}

