/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.diagnostics.Messages;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
@Extension
public class URICheckEncodingMonitor
extends AdministrativeMonitor {
    private static final Logger LOGGER = Logger.getLogger(URICheckEncodingMonitor.class.getName());

    public boolean isCheckEnabled() {
        return !"ISO-8859-1".equalsIgnoreCase(System.getProperty("file.encoding"));
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return Messages.URICheckEncodingMonitor_DisplayName();
    }

    public FormValidation doCheckURIEncoding(StaplerRequest request) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String expected = "\u57f7\u4e8b";
        String value = Util.fixEmpty(request.getParameter("value"));
        if (!"\u57f7\u4e8b".equals(value)) {
            String expectedHex = Util.toHexString("\u57f7\u4e8b".getBytes(StandardCharsets.UTF_8));
            String valueHex = value != null ? Util.toHexString(value.getBytes(StandardCharsets.UTF_8)) : null;
            LOGGER.log(Level.CONFIG, "Expected to receive: \u57f7\u4e8b (" + expectedHex + ") but got: " + value + " (" + valueHex + ")");
            return FormValidation.warningWithMarkup(hudson.model.Messages.Hudson_NotUsesUTF8ToDecodeURL());
        }
        return FormValidation.ok();
    }
}

