/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.IdStrategyDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class IdStrategy
extends AbstractDescribableImpl<IdStrategy>
implements ExtensionPoint,
Comparator<String> {
    private static final Pattern PSEUDO_UNICODE_PATTERN = Pattern.compile("\\$[a-f0-9]{4}");
    private static final Pattern CAPITALIZATION_PATTERN = Pattern.compile("~[a-z]");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in several plugins")
    public static IdStrategy CASE_INSENSITIVE = new CaseInsensitive();

    @Deprecated
    public String filenameOf(@NonNull String id) {
        return null;
    }

    @Deprecated
    @Restricted(value={ProtectedExternally.class})
    public String legacyFilenameOf(@NonNull String id) {
        return null;
    }

    @Deprecated
    public String idFromFilename(@NonNull String filename) {
        return filename;
    }

    @NonNull
    public String keyFor(@NonNull String id) {
        return id;
    }

    public boolean equals(@NonNull String id1, @NonNull String id2) {
        return this.compare(id1, id2) == 0;
    }

    @Override
    public abstract int compare(@NonNull String var1, @NonNull String var2);

    public IdStrategyDescriptor getDescriptor() {
        return (IdStrategyDescriptor)super.getDescriptor();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static DescriptorExtensionList<IdStrategy, IdStrategyDescriptor> all() {
        return Jenkins.get().getDescriptorList(IdStrategy.class);
    }

    String applyPatternRepeatedly(@NonNull Pattern pattern, @NonNull String filename, @NonNull Function<String, Character> converter) {
        StringBuilder id = new StringBuilder();
        int beginIndex = 0;
        Matcher matcher = pattern.matcher(filename);
        while (matcher.find()) {
            String group = matcher.group();
            id.append(filename, beginIndex, matcher.start());
            id.append(converter.apply(group));
            beginIndex = matcher.end();
        }
        id.append(filename.substring(beginIndex));
        return id.toString();
    }

    Character convertPseudoUnicode(String matchedGroup) {
        return Character.valueOf((char)Integer.parseInt(matchedGroup.substring(1), 16));
    }

    public static class CaseSensitiveEmailAddress
    extends CaseSensitive
    implements Serializable {
        private static final long serialVersionUID = -5713655323057260180L;

        @DataBoundConstructor
        public CaseSensitiveEmailAddress() {
        }

        @Override
        public boolean equals(@NonNull String id1, @NonNull String id2) {
            return Objects.equals(this.keyFor(id1), this.keyFor(id2));
        }

        @Override
        @NonNull
        public String keyFor(@NonNull String id) {
            int index = id.lastIndexOf(64);
            return index == -1 ? id : id.substring(0, index) + id.substring(index).toLowerCase(Locale.ENGLISH);
        }

        @Override
        public int compare(@NonNull String id1, @NonNull String id2) {
            return this.keyFor(id1).compareTo(this.keyFor(id2));
        }

        @Extension
        public static class DescriptorImpl
        extends IdStrategyDescriptor {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.IdStrategy_CaseSensitiveEmailAddress_DisplayName();
            }
        }
    }

    public static class CaseSensitive
    extends IdStrategy
    implements Serializable {
        private static final long serialVersionUID = 8339425353883308324L;

        @DataBoundConstructor
        public CaseSensitive() {
        }

        @Override
        public String idFromFilename(@NonNull String filename) {
            String id = this.applyPatternRepeatedly(CAPITALIZATION_PATTERN, filename, this::convertCapitalizedAscii);
            return this.applyPatternRepeatedly(PSEUDO_UNICODE_PATTERN, id, this::convertPseudoUnicode);
        }

        private Character convertCapitalizedAscii(String encoded) {
            return Character.valueOf(encoded.toUpperCase().charAt(1));
        }

        @Override
        public boolean equals(@NonNull String id1, @NonNull String id2) {
            return Objects.equals(id1, id2);
        }

        @Override
        public int compare(@NonNull String id1, @NonNull String id2) {
            return id1.compareTo(id2);
        }

        @Extension
        @Symbol(value={"caseSensitive"})
        public static class DescriptorImpl
        extends IdStrategyDescriptor {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.IdStrategy_CaseSensitive_DisplayName();
            }
        }
    }

    public static class CaseInsensitive
    extends IdStrategy
    implements Serializable {
        private static final long serialVersionUID = -7244768200684861085L;

        @DataBoundConstructor
        public CaseInsensitive() {
        }

        @Override
        public String idFromFilename(@NonNull String filename) {
            String id = this.applyPatternRepeatedly(PSEUDO_UNICODE_PATTERN, filename, this::convertPseudoUnicode);
            return id.toLowerCase(Locale.ENGLISH);
        }

        @Override
        @NonNull
        public String keyFor(@NonNull String id) {
            return id.toLowerCase(Locale.ENGLISH);
        }

        @Override
        public boolean equals(@NonNull String id1, @NonNull String id2) {
            return id1.equalsIgnoreCase(id2);
        }

        @Override
        public int compare(@NonNull String id1, @NonNull String id2) {
            return id1.compareToIgnoreCase(id2);
        }

        @Extension
        @Symbol(value={"caseInsensitive"})
        public static class DescriptorImpl
        extends IdStrategyDescriptor {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.IdStrategy_CaseInsensitive_DisplayName();
            }
        }
    }
}

