/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.lazy.Boundary;

class SortedList<T extends Comparable<T>>
extends AbstractList<T> {
    private List<T> data;

    SortedList(List<T> data) {
        this.data = new ArrayList<T>(data);
        assert (this.isSorted());
    }

    public int find(T probe) {
        return Collections.binarySearch(this.data, probe);
    }

    @Override
    public boolean contains(Object o) {
        return this.find((Comparable)o) >= 0;
    }

    @Override
    public T get(int idx) {
        return (T)((Comparable)this.data.get(idx));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public T remove(int index) {
        return (T)((Comparable)this.data.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    public int lower(T v) {
        return Boundary.LOWER.apply(this.find(v));
    }

    public int higher(T v) {
        return Boundary.HIGHER.apply(this.find(v));
    }

    public int floor(T v) {
        return Boundary.FLOOR.apply(this.find(v));
    }

    public int ceil(T v) {
        return Boundary.CEIL.apply(this.find(v));
    }

    public boolean isInRange(int idx) {
        return 0 <= idx && idx < this.data.size();
    }

    private boolean isSorted() {
        for (int i = 1; i < this.data.size(); ++i) {
            if (((Comparable)this.data.get(i)).compareTo((Comparable)this.data.get(i - 1)) >= 0) continue;
            return false;
        }
        return true;
    }
}

