/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import hudson.model.AbstractBuild;
import hudson.model.BallColor;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.Run;
import jenkins.model.Jenkins;
import jenkins.widgets.RunListProgressiveRendering;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Restricted(value={DoNotUse.class})
public class BuildTimeTrend
extends RunListProgressiveRendering {
    @Override
    protected void calculate(Run<?, ?> build, JSONObject element) {
        BallColor iconColor = build.getIconColor();
        element.put("iconName", (Object)iconColor.getIconName());
        element.put("iconColorOrdinal", (Object)iconColor.ordinal());
        element.put("iconColorDescription", (Object)iconColor.getDescription());
        element.put("number", (Object)build.getNumber());
        element.put("displayName", (Object)build.getDisplayName());
        element.put("duration", (Object)build.getDuration());
        element.put("durationString", (Object)build.getDurationString());
        if (build instanceof AbstractBuild) {
            AbstractBuild b = (AbstractBuild)build;
            Node n = b.getBuiltOn();
            if (n == null) {
                String ns = b.getBuiltOnStr();
                if (ns != null && !ns.isEmpty()) {
                    element.put("builtOnStr", (Object)ns);
                }
            } else if (n != Jenkins.get()) {
                element.put("builtOn", (Object)n.getNodeName());
                element.put("builtOnStr", (Object)n.getDisplayName());
            } else {
                element.put("builtOnStr", (Object)Messages.Hudson_Computer_DisplayName());
            }
        }
    }
}

