/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.jgit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.apache.TemporaryBufferEntity;
import org.eclipse.jgit.transport.http.apache.internal.HttpApacheText;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;

public class PreemptiveAuthHttpClientConnection
implements HttpConnection {
    private static final String SLASH = "/";
    HttpClient client;
    String urlStr;
    HttpUriRequest req;
    HttpResponse resp = null;
    String method = "GET";
    private TemporaryBufferEntity entity;
    private boolean isUsingProxy = false;
    private Proxy proxy;
    private Integer timeout = null;
    private Integer readTimeout;
    private Boolean followRedirects;
    @Deprecated
    private X509HostnameVerifier hostnameverifier;
    SSLContext ctx;
    private final SmartCredentialsProvider credentialsProvider;

    public PreemptiveAuthHttpClientConnection(SmartCredentialsProvider credentialsProvider, String urlStr) {
        this(credentialsProvider, urlStr, null);
    }

    public PreemptiveAuthHttpClientConnection(SmartCredentialsProvider credentialsProvider, String urlStr, Proxy proxy) {
        this(credentialsProvider, urlStr, proxy, null);
    }

    public PreemptiveAuthHttpClientConnection(SmartCredentialsProvider credentialsProvider, String urlStr, Proxy proxy, HttpClient cl) {
        this.credentialsProvider = credentialsProvider;
        this.urlStr = urlStr;
        this.proxy = proxy;
        this.client = cl;
    }

    static URIish goUp(URIish uri) {
        String originalPath = uri.getPath();
        if (originalPath == null || originalPath.length() == 0 || originalPath.equals(SLASH)) {
            return null;
        }
        int lastSlash = originalPath.endsWith(SLASH) ? originalPath.lastIndexOf(SLASH, originalPath.length() - 2) : originalPath.lastIndexOf(SLASH);
        String pathUpOneLevel = originalPath.substring(0, lastSlash);
        URIish result = pathUpOneLevel.length() == 0 ? uri.setPath(null) : uri.setPath(pathUpOneLevel);
        return result;
    }

    private HttpClient getClient() {
        if (this.client == null) {
            URIish serviceUri;
            HttpClientBuilder builder = HttpClientBuilder.create();
            CredentialItem.Username u = new CredentialItem.Username();
            CredentialItem.Password p = new CredentialItem.Password();
            try {
                serviceUri = new URIish(this.urlStr);
            }
            catch (URISyntaxException e) {
                throw new Error(e);
            }
            HttpHost targetHost = new HttpHost(serviceUri.getHost(), serviceUri.getPort(), serviceUri.getScheme());
            SystemDefaultCredentialsProvider clientCredentialsProvider = new SystemDefaultCredentialsProvider();
            if (this.credentialsProvider.supports(new CredentialItem[]{u, p})) {
                URIish uri = serviceUri;
                while (uri != null) {
                    if (this.credentialsProvider.get(uri, new CredentialItem[]{u, p})) {
                        String userName = u.getValue();
                        String password = new String(p.getValue());
                        p.clear();
                        NTCredentials credentials = PreemptiveAuthHttpClientConnection.createNTCredentials(userName, password);
                        AuthScope authScope = new AuthScope(targetHost);
                        clientCredentialsProvider = new BasicCredentialsProvider();
                        clientCredentialsProvider.setCredentials(authScope, (Credentials)credentials);
                        break;
                    }
                    uri = PreemptiveAuthHttpClientConnection.goUp(uri);
                }
            }
            builder.setDefaultCredentialsProvider((CredentialsProvider)clientCredentialsProvider);
            if (this.proxy != null && !Proxy.NO_PROXY.equals(this.proxy)) {
                this.isUsingProxy = true;
                PreemptiveAuthHttpClientConnection.configureProxy(builder, this.proxy);
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            if (this.readTimeout != null) {
                requestConfigBuilder.setSocketTimeout(this.readTimeout.intValue());
            }
            if (this.timeout != null) {
                requestConfigBuilder.setConnectTimeout(this.timeout.intValue());
            }
            if (this.followRedirects != null) {
                requestConfigBuilder.setRedirectsEnabled(this.followRedirects.booleanValue());
            }
            requestConfigBuilder.setAuthenticationEnabled(true);
            RequestConfig requestConfig = requestConfigBuilder.build();
            builder.setDefaultRequestConfig(requestConfig);
            if (this.hostnameverifier != null) {
                builder.setSSLHostnameVerifier((HostnameVerifier)this.hostnameverifier);
            }
            this.client = builder.build();
        }
        return this.client;
    }

    static NTCredentials createNTCredentials(String userName, String password) {
        String domain;
        String user;
        int firstAt = userName.indexOf(64);
        int firstSlash = userName.indexOf(47);
        int firstBackSlash = userName.indexOf(92);
        if (firstAt != -1) {
            user = userName.substring(0, firstAt);
            domain = userName.substring(firstAt + 1);
        } else if (firstSlash != -1) {
            domain = userName.substring(0, firstSlash);
            user = userName.substring(firstSlash + 1);
        } else if (firstBackSlash != -1) {
            domain = userName.substring(0, firstBackSlash);
            user = userName.substring(firstBackSlash + 1);
        } else {
            user = userName;
            domain = null;
        }
        return new NTCredentials(user, password, null, domain);
    }

    private static void configureProxy(HttpClientBuilder builder, Proxy proxy) {
        SocketAddress socketAddress;
        if (proxy != null && !Proxy.NO_PROXY.equals(proxy) && (socketAddress = proxy.address()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            String proxyHost = inetSocketAddress.getHostName();
            int proxyPort = inetSocketAddress.getPort();
            HttpHost httpHost = new HttpHost(proxyHost, proxyPort);
            builder.setProxy(httpHost);
        }
    }

    private SSLContext getSSLContext() {
        if (this.ctx == null) {
            try {
                this.ctx = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(HttpApacheText.get().unexpectedSSLContextException, e);
            }
        }
        return this.ctx;
    }

    public void setBuffer(TemporaryBuffer buffer) {
        this.entity = new TemporaryBufferEntity(buffer);
    }

    public int getResponseCode() throws IOException {
        this.execute();
        return this.resp.getStatusLine().getStatusCode();
    }

    public URL getURL() {
        try {
            return new URL(this.urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getResponseMessage() throws IOException {
        this.execute();
        return this.resp.getStatusLine().getReasonPhrase();
    }

    private void execute() throws IOException {
        if (this.resp == null) {
            if (this.entity != null) {
                if (this.req instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest eReq = (HttpEntityEnclosingRequest)this.req;
                    eReq.setEntity((HttpEntity)this.entity);
                }
                this.resp = this.getClient().execute(this.req);
                this.entity.getBuffer().close();
                this.entity = null;
            } else {
                this.resp = this.getClient().execute(this.req);
            }
        }
    }

    public Map<String, List<String>> getHeaderFields() {
        TreeMap ret = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Header hdr : this.resp.getAllHeaders()) {
            LinkedList<String> list = new LinkedList<String>();
            for (HeaderElement hdrElem : hdr.getElements()) {
                list.add(hdrElem.toString());
            }
            ret.put(hdr.getName(), Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(ret);
    }

    public List<String> getHeaderFields(@NonNull String name) {
        Map<String, List<String>> allHeaders = this.getHeaderFields();
        return allHeaders.get(name);
    }

    public void setRequestProperty(String name, String value) {
        this.req.addHeader(name, value);
    }

    public void setRequestMethod(String method) {
        this.method = method;
        if ("GET".equalsIgnoreCase(method)) {
            this.req = new HttpGet(this.urlStr);
        } else if ("PUT".equalsIgnoreCase(method)) {
            this.req = new HttpPut(this.urlStr);
        } else if ("POST".equalsIgnoreCase(method)) {
            this.req = new HttpPost(this.urlStr);
        } else {
            this.method = null;
            throw new UnsupportedOperationException();
        }
    }

    public void setUseCaches(boolean usecaches) {
    }

    public void setConnectTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getContentType() {
        Header contentType;
        HttpEntity responseEntity = this.resp.getEntity();
        if (responseEntity != null && (contentType = responseEntity.getContentType()) != null) {
            return contentType.getValue();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.resp.getEntity().getContent();
    }

    public String getHeaderField(String name) {
        Header header = this.resp.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    public int getContentLength() {
        return Integer.parseInt(this.resp.getFirstHeader("content-length").getValue());
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setDoOutput(boolean dooutput) {
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.entity != null) {
            throw new IllegalArgumentException();
        }
        this.entity = new TemporaryBufferEntity((TemporaryBuffer)new TemporaryBuffer.LocalFile(null));
        this.entity.setContentLength(contentLength);
    }

    public OutputStream getOutputStream() {
        if (this.entity == null) {
            this.entity = new TemporaryBufferEntity((TemporaryBuffer)new TemporaryBuffer.LocalFile(null));
        }
        return this.entity.getBuffer();
    }

    public void setChunkedStreamingMode(int chunklen) {
        if (this.entity == null) {
            this.entity = new TemporaryBufferEntity((TemporaryBuffer)new TemporaryBuffer.LocalFile(null));
        }
        this.entity.setChunked(true);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public boolean usingProxy() {
        return this.isUsingProxy;
    }

    public void connect() throws IOException {
        this.execute();
    }

    public void setHostnameVerifier(HostnameVerifier hostnameverifier) {
        this.hostnameverifier = new X509HostnameVerifierImpl(hostnameverifier);
    }

    public void configure(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws KeyManagementException {
        this.getSSLContext().init(km, tm, random);
    }

    @Deprecated
    private static class X509HostnameVerifierImpl
    implements X509HostnameVerifier {
        private final HostnameVerifier hostnameverifier;

        public X509HostnameVerifierImpl(HostnameVerifier hostnameverifier) {
            this.hostnameverifier = hostnameverifier;
        }

        public boolean verify(String hostname, SSLSession session) {
            return this.hostnameverifier.verify(hostname, session);
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            throw new UnsupportedOperationException("Unsupported hostname verifier called for " + host);
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            throw new UnsupportedOperationException("Unsupported hostname verifier called for " + host + " with X.509 certificate");
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            if (!this.hostnameverifier.verify(host, ssl.getSession())) {
                throw new IOException();
            }
        }
    }
}

