/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class UsernamePasswordCredentialsImpl
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    @NonNull
    private final String username;
    @NonNull
    private final Secret password;
    @Nullable
    private Boolean usernameSecret = false;

    @DataBoundConstructor
    public UsernamePasswordCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String username, @CheckForNull String password) {
        super(scope, id, description);
        this.username = Util.fixNull((String)username);
        this.password = Secret.fromString((String)password);
    }

    @Override
    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    @Override
    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isUsernameSecret() {
        return this.usernameSecret != null ? this.usernameSecret : true;
    }

    @DataBoundSetter
    public void setUsernameSecret(boolean usernameSecret) {
        this.usernameSecret = usernameSecret;
    }

    @Extension(ordinal=1.0)
    @Symbol(value={"usernamePassword"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.UsernamePasswordCredentialsImpl_DisplayName();
        }

        @Override
        public String getIconClassName() {
            return "symbol-id-card";
        }
    }
}

