/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BaseSSHUser;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.Messages;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.DataBoundConstructor;

public class BasicSSHUserPrivateKey
extends BaseSSHUser
implements SSHUserPrivateKey {
    private static final long serialVersionUID = 1L;
    private final Secret passphrase;
    private final PrivateKeySource privateKeySource;
    @GuardedBy(value="this")
    private transient List<String> privateKeys;
    @GuardedBy(value="this")
    private transient long privateKeysLastModified;

    @DataBoundConstructor
    public BasicSSHUserPrivateKey(CredentialsScope scope, String id, String username, PrivateKeySource privateKeySource, String passphrase, String description) {
        super(scope, id, username, description);
        this.privateKeySource = privateKeySource == null ? new DirectEntryPrivateKeySource("") : privateKeySource;
        this.passphrase = BasicSSHUserPrivateKey.fixEmpty(passphrase == null ? null : Secret.fromString((String)passphrase));
    }

    private static Secret fixEmpty(Secret secret) {
        return secret == null ? null : (secret.getPlainText().isEmpty() ? null : secret);
    }

    @Override
    protected synchronized Object readResolve() {
        if (this.privateKeySource == null) {
            Secret passphrase = this.getPassphrase();
            if (this.privateKeys != null) {
                return new BasicSSHUserPrivateKey(this.getScope(), this.getId(), this.getUsername(), new DirectEntryPrivateKeySource(this.privateKeys), passphrase == null ? null : passphrase.getEncryptedValue(), this.getDescription());
            }
            return new BasicSSHUserPrivateKey(this.getScope(), this.getId(), this.getUsername(), new DirectEntryPrivateKeySource(""), passphrase == null ? null : passphrase.getEncryptedValue(), this.getDescription());
        }
        if (this.passphrase != null && BasicSSHUserPrivateKey.fixEmpty(this.passphrase) == null) {
            return new BasicSSHUserPrivateKey(this.getScope(), this.getId(), this.getUsername(), this.privateKeySource, null, this.getDescription());
        }
        return super.readResolve();
    }

    @Override
    @NonNull
    public synchronized List<String> getPrivateKeys() {
        if (this.privateKeySource == null) {
            return Collections.emptyList();
        }
        long lastModified = this.privateKeySource.getPrivateKeysLastModified();
        if (this.privateKeys == null || this.privateKeys.isEmpty() || lastModified > this.privateKeysLastModified) {
            ArrayList<String> privateKeys = new ArrayList<String>();
            for (String privateKey : this.privateKeySource.getPrivateKeys()) {
                try {
                    if (PuTTYKey.isPuTTYKeyFile((Reader)new StringReader(privateKey))) {
                        privateKeys.add(new PuTTYKey((Reader)new StringReader(privateKey), this.passphrase == null ? "" : this.passphrase.getPlainText()).toOpenSSH());
                        continue;
                    }
                    privateKeys.add((String)(privateKey.endsWith("\n") ? privateKey : privateKey + "\n"));
                }
                catch (IOException iOException) {}
            }
            this.privateKeys = privateKeys;
            this.privateKeysLastModified = lastModified;
        }
        return this.privateKeys;
    }

    @NonNull
    public PrivateKeySource getPrivateKeySource() {
        return this.privateKeySource == null ? new DirectEntryPrivateKeySource("") : this.privateKeySource;
    }

    @Override
    @CheckForNull
    public Secret getPassphrase() {
        return this.passphrase;
    }

    static {
        Items.XSTREAM2.addCriticalField(BasicSSHUserPrivateKey.class, "privateKeySource");
    }

    @Deprecated
    public static class UsersPrivateKeySource
    extends PrivateKeySource {
        private static final Logger LOGGER = Logger.getLogger(UsersPrivateKeySource.class.getName());
        private volatile transient long lastModified;
        private volatile transient long nextCheckLastModified;

        private List<File> files() {
            ArrayList<File> files = new ArrayList<File>();
            File sshHome = new File(new File(System.getProperty("user.home")), ".ssh");
            for (String keyName : Arrays.asList("id_ecdsa", "id_ed25519", "id_rsa", "id_dsa", "identity")) {
                File key = new File(sshHome, keyName);
                if (!key.isFile()) continue;
                files.add(key);
            }
            return files;
        }

        @Override
        @NonNull
        public List<String> getPrivateKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            for (File file : this.files()) {
                try {
                    keys.add(FileUtils.readFileToString((File)file));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not read private key", e);
                }
            }
            return keys;
        }

        @Override
        public long getPrivateKeysLastModified() {
            if (this.nextCheckLastModified > System.currentTimeMillis() || this.lastModified < 0L) {
                this.lastModified = Long.MIN_VALUE;
                for (File file : this.files()) {
                    this.lastModified = Math.max(this.lastModified, file.lastModified());
                }
                this.nextCheckLastModified = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
            }
            return this.lastModified;
        }

        private Object readResolve() {
            Jenkins.get().checkPermission(Jenkins.RUN_SCRIPTS);
            LOGGER.log(Level.INFO, "SECURITY-440: Migrating UsersPrivateKeySource to DirectEntryPrivateKeySource");
            return new DirectEntryPrivateKeySource(this.getPrivateKeys());
        }
    }

    @Deprecated
    public static class FileOnMasterPrivateKeySource
    extends PrivateKeySource {
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterPrivateKeySource.class.getName());
        private final String privateKeyFile;
        private volatile transient long lastModified;
        private volatile transient long nextCheckLastModified;

        public FileOnMasterPrivateKeySource(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        @Override
        @NonNull
        public List<String> getPrivateKeys() {
            File key;
            if (this.privateKeyFile != null && (key = new File(this.privateKeyFile)).isFile()) {
                try {
                    return Collections.singletonList(FileUtils.readFileToString((File)key));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not read private key file " + this.privateKeyFile, e);
                }
            }
            return Collections.emptyList();
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        private Object readResolve() {
            if (this.privateKeyFile != null && this.privateKeyFile.startsWith("---") && this.privateKeyFile.contains("---BEGIN") && this.privateKeyFile.contains("---END")) {
                return new DirectEntryPrivateKeySource(this.privateKeyFile);
            }
            Jenkins.get().checkPermission(Jenkins.RUN_SCRIPTS);
            LOGGER.log(Level.INFO, "SECURITY-440: Migrating FileOnMasterPrivateKeySource to DirectEntryPrivateKeySource");
            return new DirectEntryPrivateKeySource(this.getPrivateKeys());
        }

        @Override
        public long getPrivateKeysLastModified() {
            if (this.nextCheckLastModified > System.currentTimeMillis() || this.lastModified < 0L) {
                File file;
                this.lastModified = Long.MIN_VALUE;
                if (this.privateKeyFile != null && (file = new File(this.privateKeyFile)).exists()) {
                    this.lastModified = file.lastModified();
                }
                this.nextCheckLastModified = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
            }
            return this.lastModified;
        }
    }

    public static class DirectEntryPrivateKeySource
    extends PrivateKeySource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Secret privateKey;

        public DirectEntryPrivateKeySource(String privateKey) {
            this(Secret.fromString((String)(privateKey.endsWith("\n") ? privateKey : privateKey + "\n")));
        }

        @DataBoundConstructor
        public DirectEntryPrivateKeySource(Secret privateKey) {
            this.privateKey = privateKey;
        }

        public DirectEntryPrivateKeySource(List<String> privateKeys) {
            this(StringUtils.join(privateKeys, (String)"\f"));
        }

        @Override
        @NonNull
        public List<String> getPrivateKeys() {
            String privateKeys = Secret.toString((Secret)this.privateKey);
            return StringUtils.isBlank((String)privateKeys) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)privateKeys, (String)"\f"));
        }

        public Secret getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public boolean isSnapshotSource() {
            return true;
        }

        @Extension
        public static class DescriptorImpl
        extends PrivateKeySourceDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.BasicSSHUserPrivateKey_DirectEntryPrivateKeySourceDisplayName();
            }
        }
    }

    public static abstract class PrivateKeySourceDescriptor
    extends Descriptor<PrivateKeySource> {
    }

    public static abstract class PrivateKeySource
    extends AbstractDescribableImpl<PrivateKeySource> {
        @NonNull
        public abstract List<String> getPrivateKeys();

        public long getPrivateKeysLastModified() {
            return 1L;
        }

        @Deprecated
        public boolean isSnapshotSource() {
            return false;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BasicSSHUserPrivateKey_DisplayName();
        }

        public DescriptorExtensionList<PrivateKeySource, Descriptor<PrivateKeySource>> getPrivateKeySources() {
            return Jenkins.get().getDescriptorList(PrivateKeySource.class);
        }

        public String getIconClassName() {
            return "symbol-fingerprint";
        }
    }
}

