/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.ProvisionListener;
import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionPoint;
import hudson.PluginManager;
import hudson.model.Hudson;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionRefreshException;
import jenkins.ProxyInjector;
import jenkins.model.Jenkins;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.util.ClassUtils;

public abstract class ExtensionFinder
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ExtensionFinder.class.getName());

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public <T> Collection<T> findExtensions(Class<T> type, Hudson hudson) {
        return Collections.emptyList();
    }

    public boolean isRefreshable() {
        try {
            return this.getClass().getMethod("refresh", new Class[0]).getDeclaringClass() != ExtensionFinder.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public abstract ExtensionComponentSet refresh() throws ExtensionRefreshException;

    public abstract <T> Collection<ExtensionComponent<T>> find(Class<T> var1, Hudson var2);

    @Deprecated
    public <T> Collection<ExtensionComponent<T>> _find(Class<T> type, Hudson hudson) {
        return this.find(type, hudson);
    }

    public void scout(Class extensionType, Hudson hudson) {
    }

    Collection<Method> getMethodAndInterfaceDeclarations(Method method, Collection<Class<?>> interfaces) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.add(method);
        interfaces.stream().map(Class::getMethods).flatMap(Arrays::stream).filter(m -> m.getName().equals(method.getName()) && Arrays.equals(m.getParameterTypes(), method.getParameterTypes())).findFirst().ifPresent(methods::add);
        return methods;
    }

    private static Class<?> getClassFromIndex(IndexItem<Extension, Object> item) throws InstantiationException {
        Class<?> extType;
        AnnotatedElement e = item.element();
        if (e instanceof Class) {
            extType = (Class<?>)e;
        } else if (e instanceof Field) {
            extType = ((Field)e).getType();
        } else if (e instanceof Method) {
            extType = ((Method)e).getReturnType();
        } else {
            throw new AssertionError();
        }
        return extType;
    }

    public static final class Sezpoz
    extends ExtensionFinder {
        private volatile List<IndexItem<Extension, Object>> indices;

        private List<IndexItem<Extension, Object>> getIndices() {
            if (this.indices == null) {
                ClassLoader cl = Jenkins.get().getPluginManager().uberClassLoader;
                this.indices = StreamSupport.stream(Index.load(Extension.class, Object.class, (ClassLoader)cl).spliterator(), false).collect(Collectors.toUnmodifiableList());
            }
            return this.indices;
        }

        @Override
        public synchronized ExtensionComponentSet refresh() {
            List<IndexItem<Extension, Object>> old = this.indices;
            if (old == null) {
                return ExtensionComponentSet.EMPTY;
            }
            final List<IndexItem<Extension, Object>> delta = Sezpoz.listDelta(Extension.class, old);
            ArrayList<IndexItem<Extension, Object>> r = new ArrayList<IndexItem<Extension, Object>>(old);
            r.addAll(delta);
            this.indices = Collections.unmodifiableList(r);
            return new ExtensionComponentSet(){

                @Override
                public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                    return this._find(type, delta);
                }
            };
        }

        static <T extends Annotation> List<IndexItem<T, Object>> listDelta(Class<T> annotationType, List<? extends IndexItem<?, Object>> old) {
            ArrayList<IndexItem<T, Object>> delta = new ArrayList<IndexItem<T, Object>>();
            ClassLoader cl = Jenkins.get().getPluginManager().uberClassLoader;
            for (IndexItem ii : Index.load(annotationType, Object.class, (ClassLoader)cl)) {
                if (old.contains(ii)) continue;
                delta.add(ii);
            }
            return delta;
        }

        @Override
        public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson jenkins) {
            return this._find(type, this.getIndices());
        }

        private <T> Collection<ExtensionComponent<T>> _find(Class<T> type, List<IndexItem<Extension, Object>> indices) {
            ArrayList<ExtensionComponent<T>> result = new ArrayList<ExtensionComponent<T>>();
            for (IndexItem<Extension, Object> item : indices) {
                try {
                    Object instance;
                    Class<?> extType = ExtensionFinder.getClassFromIndex(item);
                    if (!type.isAssignableFrom(extType) || (instance = item.instance()) == null) continue;
                    result.add(new ExtensionComponent<T>(type.cast(instance), (Extension)item.annotation()));
                }
                catch (Exception | LinkageError e) {
                    LOGGER.log(this.logLevel(item), "Failed to load " + item.className(), e);
                }
            }
            return result;
        }

        @Override
        public void scout(Class extensionType, Hudson hudson) {
            for (IndexItem<Extension, Object> item : this.getIndices()) {
                try {
                    Class<?> extType = ExtensionFinder.getClassFromIndex(item);
                    Class.forName(extType.getName(), true, extType.getClassLoader());
                }
                catch (Exception | LinkageError e) {
                    LOGGER.log(this.logLevel(item), "Failed to scout " + item.className(), e);
                }
            }
        }

        private Level logLevel(IndexItem<Extension, Object> item) {
            return ((Extension)item.annotation()).optional() ? Level.FINE : Level.WARNING;
        }
    }

    @Extension
    public static class GuiceFinder
    extends ExtensionFinder {
        private volatile Injector container;
        private List<IndexItem<?, Object>> sezpozIndex;
        private final Map<Key, Annotation> annotations = new HashMap<Key, Annotation>();
        private final Sezpoz moduleFinder = new Sezpoz();
        private Map<Class<? extends Annotation>, GuiceExtensionAnnotation<?>> extensionAnnotations = new HashMap();
        public static final Scope FAULT_TOLERANT_SCOPE = new FaultTolerantScope(true);
        private static final Scope QUIET_FAULT_TOLERANT_SCOPE = new FaultTolerantScope(false);
        private static final Logger LOGGER = Logger.getLogger(GuiceFinder.class.getName());

        public GuiceFinder() {
            this.refreshExtensionAnnotations();
            SezpozModule extensions = new SezpozModule(this.loadSezpozIndices(Jenkins.get().getPluginManager().uberClassLoader));
            ArrayList<Object> modules = new ArrayList<Object>();
            modules.add(new AbstractModule(){

                protected void configure() {
                    Jenkins j = Jenkins.get();
                    this.bind(Jenkins.class).toInstance((Object)j);
                    this.bind(PluginManager.class).toInstance((Object)j.getPluginManager());
                }
            });
            modules.add((Object)extensions);
            for (ExtensionComponent<Module> ec : this.moduleFinder.find(Module.class, Hudson.getInstance())) {
                modules.add(ec.getInstance());
            }
            try {
                this.container = Guice.createInjector(modules);
                this.sezpozIndex = extensions.getLoadedIndex();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to create Guice container from all the plugins", e);
                this.container = Guice.createInjector((Module[])new Module[]{new SezpozModule(this.loadSezpozIndices(Jenkins.class.getClassLoader()))});
            }
            Jenkins.get().lookup.set(Injector.class, new ProxyInjector(){

                @Override
                protected Injector resolve() {
                    return this.getContainer();
                }
            });
        }

        private void refreshExtensionAnnotations() {
            for (ExtensionComponent<GuiceExtensionAnnotation> ec : this.moduleFinder.find(GuiceExtensionAnnotation.class, Hudson.getInstance())) {
                GuiceExtensionAnnotation gea = ec.getInstance();
                this.extensionAnnotations.put(gea.annotationType, gea);
            }
        }

        private List<IndexItem<?, Object>> loadSezpozIndices(ClassLoader classLoader) {
            ArrayList<IndexItem> indices = new ArrayList<IndexItem>();
            for (GuiceExtensionAnnotation<?> gea : this.extensionAnnotations.values()) {
                for (IndexItem indexItem : Index.load(gea.annotationType, Object.class, (ClassLoader)classLoader)) {
                    indices.add(indexItem);
                }
            }
            return Collections.unmodifiableList(indices);
        }

        public Injector getContainer() {
            return this.container;
        }

        @Override
        public synchronized ExtensionComponentSet refresh() throws ExtensionRefreshException {
            this.refreshExtensionAnnotations();
            ArrayList delta = new ArrayList();
            for (Class<? extends Annotation> annotationType : this.extensionAnnotations.keySet()) {
                delta.addAll(Sezpoz.listDelta(annotationType, this.sezpozIndex));
            }
            SezpozModule deltaExtensions = new SezpozModule(delta);
            ArrayList<SezpozModule> modules = new ArrayList<SezpozModule>();
            modules.add(deltaExtensions);
            for (ExtensionComponent<Module> ec : this.moduleFinder.refresh().find(Module.class)) {
                modules.add((SezpozModule)ec.getInstance());
            }
            try {
                Injector child;
                this.container = child = this.container.createChildInjector(modules);
                ArrayList l = new ArrayList(this.sezpozIndex);
                l.addAll(deltaExtensions.getLoadedIndex());
                this.sezpozIndex = l;
                return new ExtensionComponentSet(){

                    @Override
                    public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                        ArrayList<ExtensionComponent<T>> result = new ArrayList<ExtensionComponent<T>>();
                        this._find(type, result, child);
                        return result;
                    }
                };
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to create Guice container from newly added plugins", e);
                throw new ExtensionRefreshException(e);
            }
        }

        private Object instantiate(IndexItem<?, Object> item) {
            try {
                return item.instance();
            }
            catch (Exception | LinkageError e) {
                LOGGER.log(this.isOptional(item.annotation()) ? Level.FINE : Level.WARNING, "Failed to load " + item.className(), e);
                return null;
            }
        }

        private boolean isOptional(Annotation annotation) {
            GuiceExtensionAnnotation<?> gea = this.extensionAnnotations.get(annotation.annotationType());
            return gea.isOptional(annotation);
        }

        private boolean isActive(Annotation annotation, AnnotatedElement e) {
            GuiceExtensionAnnotation<?> gea = this.extensionAnnotations.get(annotation.annotationType());
            return gea.isActive(e);
        }

        public <U> Collection<ExtensionComponent<U>> find(Class<U> type, Hudson jenkins) {
            ArrayList<ExtensionComponent<U>> result = new ArrayList<ExtensionComponent<U>>();
            for (Injector i = this.container; i != null; i = i.getParent()) {
                this._find(type, result, i);
            }
            return result;
        }

        private <U> void _find(Class<U> type, List<ExtensionComponent<U>> result, Injector container) {
            for (Map.Entry e : container.getBindings().entrySet()) {
                if (!type.isAssignableFrom(((Key)e.getKey()).getTypeLiteral().getRawType())) continue;
                Annotation a = this.annotations.get(e.getKey());
                Object o = ((Binding)e.getValue()).getProvider().get();
                if (o == null) continue;
                GuiceExtensionAnnotation<?> gea = a != null ? this.extensionAnnotations.get(a.annotationType()) : null;
                result.add(new ExtensionComponent<U>(type.cast(o), gea != null ? gea.getOrdinal(a) : 0.0));
            }
        }

        @Override
        public void scout(Class extensionType, Hudson hudson) {
        }

        private class SezpozModule
        extends AbstractModule
        implements ProvisionListener {
            private final List<IndexItem<?, Object>> index;
            private final List<IndexItem<?, Object>> loadedIndex;

            SezpozModule(List<IndexItem<?, Object>> index) {
                this.index = index;
                this.loadedIndex = new ArrayList();
            }

            private void resolve(Class<?> c) {
                this.resolve(c, new HashSet());
            }

            private void resolve(Class<?> c, Set<Class<?>> encountered) {
                if (!encountered.add(c)) {
                    return;
                }
                try {
                    for (Class<?> cc = c; cc != Object.class && cc != null; cc = cc.getSuperclass()) {
                        cc.getGenericSuperclass();
                        cc.getGenericInterfaces();
                        boolean foundInjectableConstructor = false;
                        for (Constructor<?> constructor : cc.getDeclaredConstructors()) {
                            if (!constructor.isAnnotationPresent(javax.inject.Inject.class) && !constructor.isAnnotationPresent(Inject.class) && !constructor.isAnnotationPresent(com.google.inject.Inject.class)) continue;
                            constructor.getAnnotatedParameterTypes();
                            constructor.getParameterAnnotations();
                            foundInjectableConstructor = true;
                        }
                        if (!foundInjectableConstructor) {
                            Constructor<?> noArg = null;
                            try {
                                noArg = cc.getDeclaredConstructor(new Class[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            if (noArg != null) {
                                noArg.getAnnotatedParameterTypes();
                                noArg.getParameterAnnotations();
                            }
                        }
                        for (Executable executable : cc.getDeclaredMethods()) {
                            if (!executable.isAnnotationPresent(javax.inject.Inject.class) && !executable.isAnnotationPresent(Inject.class) && !executable.isAnnotationPresent(com.google.inject.Inject.class)) continue;
                            executable.getAnnotatedParameterTypes();
                            ((Method)executable).getParameterAnnotations();
                        }
                        for (AccessibleObject accessibleObject : cc.getDeclaredFields()) {
                            if (!accessibleObject.isAnnotationPresent(javax.inject.Inject.class) && !accessibleObject.isAnnotationPresent(Inject.class) && !accessibleObject.isAnnotationPresent(com.google.inject.Inject.class)) continue;
                            accessibleObject.getAnnotations();
                            ((Field)accessibleObject).getAnnotatedType().getAnnotations();
                            this.resolve(((Field)accessibleObject).getType(), encountered);
                        }
                    }
                    LOGGER.log(Level.FINER, "{0} looks OK", c);
                }
                catch (RuntimeException x) {
                    throw new LinkageError("Failed to resolve " + c, x);
                }
            }

            protected void configure() {
                this.bindListener(Matchers.any(), new ProvisionListener[]{this});
                for (IndexItem<?, Object> item : this.index) {
                    boolean optional = GuiceFinder.this.isOptional(item.annotation());
                    try {
                        Scope scope;
                        AnnotatedElement e = item.element();
                        Annotation a = item.annotation();
                        if (!GuiceFinder.this.isActive(a, e)) continue;
                        Scope scope2 = scope = optional ? QUIET_FAULT_TOLERANT_SCOPE : FAULT_TOLERANT_SCOPE;
                        if (e instanceof Class) {
                            Key key = Key.get((Class)((Class)e));
                            this.resolve((Class)e);
                            GuiceFinder.this.annotations.put(key, a);
                            this.bind(key).in(scope);
                        } else {
                            Class<?> extType;
                            if (e instanceof Field) {
                                extType = ((Field)e).getType();
                            } else if (e instanceof Method) {
                                extType = ((Method)e).getReturnType();
                            } else {
                                throw new AssertionError();
                            }
                            this.resolve(extType);
                            Key key = Key.get(extType, (Annotation)Names.named((String)(item.className() + "." + item.memberName())));
                            GuiceFinder.this.annotations.put(key, a);
                            this.bind(key).toProvider(() -> GuiceFinder.this.instantiate(item)).in(scope);
                        }
                        this.loadedIndex.add(item);
                    }
                    catch (Exception | LinkageError e) {
                        LOGGER.log(optional ? Level.FINE : Level.WARNING, "Failed to load " + item.className(), e);
                    }
                }
            }

            public List<IndexItem<?, Object>> getLoadedIndex() {
                return List.copyOf(this.loadedIndex);
            }

            public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                Object instance = provision.provision();
                if (instance == null) {
                    return;
                }
                ArrayList methods = new ArrayList();
                Set interfaces = ClassUtils.getAllInterfacesAsSet((Object)instance);
                for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
                    Arrays.stream(c.getDeclaredMethods()).map(m -> GuiceFinder.this.getMethodAndInterfaceDeclarations((Method)m, interfaces)).flatMap(Collection::stream).filter(m -> m.getAnnotation(jakarta.annotation.PostConstruct.class) != null || m.getAnnotation(PostConstruct.class) != null).findFirst().ifPresent(method -> methods.add(0, method));
                }
                for (Method postConstruct : methods) {
                    try {
                        postConstruct.setAccessible(true);
                        postConstruct.invoke(instance, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("@PostConstruct %s", postConstruct), e);
                    }
                }
            }
        }

        private static final class FaultTolerantScope
        implements Scope {
            private final boolean verbose;

            FaultTolerantScope(boolean verbose) {
                this.verbose = verbose;
            }

            public <T> Provider<T> scope(final Key<T> key, Provider<T> unscoped) {
                final Provider base = Scopes.SINGLETON.scope(key, unscoped);
                return new Provider<T>(){

                    public T get() {
                        try {
                            return base.get();
                        }
                        catch (Exception | LinkageError e) {
                            this.error(key, e);
                            return null;
                        }
                    }

                    void error(Key<T> key2, Throwable x) {
                        LOGGER.log(verbose ? Level.WARNING : Level.FINE, "Failed to instantiate " + key2 + "; skipping this component", x);
                    }
                };
            }
        }
    }

    public static abstract class GuiceExtensionAnnotation<T extends Annotation> {
        public final Class<T> annotationType;

        protected GuiceExtensionAnnotation(Class<T> annotationType) {
            this.annotationType = annotationType;
        }

        protected abstract double getOrdinal(T var1);

        protected abstract boolean isActive(AnnotatedElement var1);

        protected abstract boolean isOptional(T var1);
    }

    @Extension
    public static final class DefaultGuiceExtensionAnnotation
    extends GuiceExtensionAnnotation<Extension> {
        public DefaultGuiceExtensionAnnotation() {
            super(Extension.class);
        }

        @Override
        protected boolean isOptional(Extension annotation) {
            return annotation.optional();
        }

        @Override
        protected double getOrdinal(Extension annotation) {
            return annotation.ordinal();
        }

        @Override
        protected boolean isActive(AnnotatedElement e) {
            return true;
        }
    }
}

