/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BallColor;
import hudson.model.BuildAuthorizationToken;
import hudson.model.BuildListener;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.DependencyGraph;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ProminentProjectAction;
import hudson.model.Queue;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.TransientProjectActionFactory;
import hudson.model.User;
import hudson.model.WorkspaceBrowser;
import hudson.model.WorkspaceListener;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelExpression;
import hudson.model.listeners.SCMPollListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.SubTask;
import hudson.model.queue.SubTaskContributor;
import hudson.scm.NullSCM;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.scm.SCMS;
import hudson.search.SearchIndexBuilder;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Publisher;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.PersistedList;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.BlockedBecauseOfBuildInProgress;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.Uptime;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.scm.DefaultSCMCheckoutStrategyImpl;
import jenkins.scm.SCMCheckoutStrategy;
import jenkins.scm.SCMCheckoutStrategyDescriptor;
import jenkins.scm.SCMDecisionHandler;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

@BridgeMethodsAdded
public abstract class AbstractProject<P extends AbstractProject<P, R>, R extends AbstractBuild<P, R>>
extends Job<P, R>
implements BuildableItem,
LazyBuildMixIn.LazyLoadingJob<P, R>,
ParameterizedJobMixIn.ParameterizedJob<P, R> {
    private volatile SCM scm = new NullSCM();
    private volatile SCMCheckoutStrategy scmCheckoutStrategy;
    private volatile transient SCMRevisionState pollingBaseline = null;
    private transient LazyBuildMixIn<P, R> buildMixIn;
    @Restricted(value={NoExternalUse.class})
    protected transient RunMap<R> builds;
    private volatile Integer quietPeriod = null;
    private volatile Integer scmCheckoutRetryCount = null;
    private String assignedNode;
    private volatile boolean canRoam;
    protected volatile boolean disabled;
    protected volatile boolean blockBuildWhenDownstreamBuilding = false;
    protected volatile boolean blockBuildWhenUpstreamBuilding = false;
    private volatile String jdk;
    private volatile BuildAuthorizationToken authToken = null;
    protected volatile DescribableList<Trigger<?>, TriggerDescriptor> triggers = new DescribableList(this);
    private static final AtomicReferenceFieldUpdater<AbstractProject, DescribableList> triggersUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractProject.class, DescribableList.class, "triggers");
    protected volatile transient List<Action> transientActions = new Vector<Action>();
    private boolean concurrentBuild;
    private String customWorkspace;
    private static final Comparator<Integer> REVERSE_INTEGER_COMPARATOR = Comparator.reverseOrder();
    private static final Logger LOGGER = Logger.getLogger(AbstractProject.class.getName());
    @Deprecated
    public static final Permission ABORT = CANCEL;
    @Deprecated
    public static final AlternativeUiTextProvider.Message<AbstractProject> BUILD_NOW_TEXT = new AlternativeUiTextProvider.Message();

    protected AbstractProject(ItemGroup parent, String name) {
        super(parent, name);
        this.buildMixIn = this.createBuildMixIn();
        this.builds = this.buildMixIn.getRunMap();
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null && !j.getNodes().isEmpty()) {
            this.canRoam = true;
        }
    }

    private LazyBuildMixIn<P, R> createBuildMixIn() {
        return new LazyBuildMixIn<P, R>(){

            @Override
            protected P asJob() {
                return AbstractProject.this;
            }

            @Override
            protected Class<R> getBuildClass() {
                return AbstractProject.this.getBuildClass();
            }
        };
    }

    @Override
    public LazyBuildMixIn<P, R> getLazyBuildMixIn() {
        return this.buildMixIn;
    }

    @Override
    public synchronized void save() throws IOException {
        super.save();
        this.updateTransientActions();
    }

    @Override
    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        this.buildMixIn.onCreatedFromScratch();
        this.builds = this.buildMixIn.getRunMap();
        this.updateTransientActions();
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (this.buildMixIn == null) {
            this.buildMixIn = this.createBuildMixIn();
        }
        this.buildMixIn.onLoad(parent, name);
        this.builds = this.buildMixIn.getRunMap();
        ((PersistedList)this.triggers()).setOwner(this);
        for (Trigger t : this.triggers()) {
            try {
                t.start(this, Items.currentlyUpdatingByXml());
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "could not start trigger while loading project '" + this.getFullName() + "'", e);
            }
        }
        if (this.scm == null) {
            this.scm = new NullSCM();
        }
        if (this.transientActions == null) {
            this.transientActions = new Vector<Action>();
        }
        this.updateTransientActions();
    }

    @WithBridgeMethods(value={List.class})
    protected DescribableList<Trigger<?>, TriggerDescriptor> triggers() {
        if (this.triggers == null) {
            triggersUpdater.compareAndSet(this, null, new DescribableList(this));
        }
        return this.triggers;
    }

    @Override
    @NonNull
    public EnvVars getEnvironment(@CheckForNull Node node, @NonNull TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = super.getEnvironment(node, listener);
        JDK jdkTool = this.getJDK();
        if (jdkTool != null) {
            if (node != null) {
                jdkTool = jdkTool.forNode(node, listener);
            }
            jdkTool.buildEnvVars(env);
        } else if (!JDK.isDefaultName(this.jdk)) {
            listener.getLogger().println("No JDK named \u2018" + this.jdk + "\u2019 found");
        }
        return env;
    }

    @Override
    protected void performDelete() throws IOException, InterruptedException {
        this.makeDisabled(true);
        FilePath ws = this.getWorkspace();
        if (ws != null) {
            Node on = this.getLastBuiltOn();
            this.getScm().processWorkspaceBeforeDeletion(this, ws, on);
        }
        super.performDelete();
    }

    @Override
    @Exported
    public boolean isConcurrentBuild() {
        return this.concurrentBuild;
    }

    public void setConcurrentBuild(boolean b) throws IOException {
        this.concurrentBuild = b;
        this.save();
    }

    @Override
    @CheckForNull
    public Label getAssignedLabel() {
        if (this.canRoam) {
            return null;
        }
        if (this.assignedNode == null) {
            return Jenkins.get().getSelfLabel();
        }
        return Jenkins.get().getLabel(this.assignedNode);
    }

    public Set<Label> getRelevantLabels() {
        return Collections.singleton(this.getAssignedLabel());
    }

    @Exported(name="labelExpression")
    public String getAssignedLabelString() {
        if (this.canRoam || this.assignedNode == null) {
            return null;
        }
        try {
            Label.parseExpression(this.assignedNode);
            return this.assignedNode;
        }
        catch (IllegalArgumentException e) {
            return LabelAtom.escape(this.assignedNode);
        }
    }

    public void setAssignedLabel(Label l) throws IOException {
        if (l == null) {
            this.canRoam = true;
            this.assignedNode = null;
        } else {
            this.canRoam = false;
            this.assignedNode = l == Jenkins.get().getSelfLabel() ? null : l.getExpression();
        }
        this.save();
    }

    public void setAssignedNode(Node l) throws IOException {
        this.setAssignedLabel(l.getSelfLabel());
    }

    @Override
    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, this, Messages.AbstractProject_Pronoun());
    }

    @Override
    public String getBuildNowText() {
        return AlternativeUiTextProvider.get(BUILD_NOW_TEXT, this, ParameterizedJobMixIn.ParameterizedJob.super.getBuildNowText());
    }

    public AbstractProject<?, ?> getRootProject() {
        if (this instanceof TopLevelItem) {
            return this;
        }
        ItemGroup p = this.getParent();
        if (p instanceof AbstractProject) {
            return ((AbstractProject)((Object)p)).getRootProject();
        }
        return this;
    }

    @Deprecated
    public final FilePath getWorkspace() {
        AbstractBuild b = this.getBuildForDeprecatedMethods();
        return b != null ? b.getWorkspace() : null;
    }

    @CheckForNull
    private AbstractBuild getBuildForDeprecatedMethods() {
        AbstractBuild b;
        Queue.Executable exe;
        Executor e = Executor.currentExecutor();
        if (e != null && (exe = e.getCurrentExecutable()) instanceof AbstractBuild && (b = (AbstractBuild)exe).getProject() == this) {
            return b;
        }
        return this.getLastBuild();
    }

    @CheckForNull
    public final FilePath getSomeWorkspace() {
        R b = this.getSomeBuildWithWorkspace();
        if (b != null) {
            return ((AbstractBuild)b).getWorkspace();
        }
        for (WorkspaceBrowser browser : ExtensionList.lookup(WorkspaceBrowser.class)) {
            FilePath f = browser.getWorkspace(this);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public final R getSomeBuildWithWorkspace() {
        for (Run b = this.getLastBuild(); b != null; b = ((AbstractBuild)b).getPreviousBuild()) {
            FilePath ws = ((AbstractBuild)b).getWorkspace();
            if (ws == null) continue;
            return (R)b;
        }
        return null;
    }

    private R getSomeBuildWithExistingWorkspace() throws IOException, InterruptedException {
        for (Run b = this.getLastBuild(); b != null; b = ((AbstractBuild)b).getPreviousBuild()) {
            FilePath ws = ((AbstractBuild)b).getWorkspace();
            if (ws == null || !ws.exists()) continue;
            return (R)b;
        }
        return null;
    }

    @Deprecated
    public FilePath getModuleRoot() {
        AbstractBuild b = this.getBuildForDeprecatedMethods();
        return b != null ? b.getModuleRoot() : null;
    }

    @Deprecated
    public FilePath[] getModuleRoots() {
        AbstractBuild b = this.getBuildForDeprecatedMethods();
        return b != null ? b.getModuleRoots() : null;
    }

    @Override
    public int getQuietPeriod() {
        return this.quietPeriod != null ? this.quietPeriod.intValue() : Jenkins.get().getQuietPeriod();
    }

    public SCMCheckoutStrategy getScmCheckoutStrategy() {
        return this.scmCheckoutStrategy == null ? new DefaultSCMCheckoutStrategyImpl() : this.scmCheckoutStrategy;
    }

    public void setScmCheckoutStrategy(SCMCheckoutStrategy scmCheckoutStrategy) throws IOException {
        this.scmCheckoutStrategy = scmCheckoutStrategy;
        this.save();
    }

    public int getScmCheckoutRetryCount() {
        return this.scmCheckoutRetryCount != null ? this.scmCheckoutRetryCount.intValue() : Jenkins.get().getScmCheckoutRetryCount();
    }

    public boolean getHasCustomQuietPeriod() {
        return this.quietPeriod != null;
    }

    public void setQuietPeriod(Integer seconds) throws IOException {
        this.quietPeriod = seconds;
        this.save();
    }

    public boolean hasCustomScmCheckoutRetryCount() {
        return this.scmCheckoutRetryCount != null;
    }

    @Override
    public boolean isBuildable() {
        return ParameterizedJobMixIn.ParameterizedJob.super.isBuildable();
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean blockBuildWhenDownstreamBuilding() {
        return this.blockBuildWhenDownstreamBuilding;
    }

    public void setBlockBuildWhenDownstreamBuilding(boolean b) throws IOException {
        this.blockBuildWhenDownstreamBuilding = b;
        this.save();
    }

    public boolean blockBuildWhenUpstreamBuilding() {
        return this.blockBuildWhenUpstreamBuilding;
    }

    public void setBlockBuildWhenUpstreamBuilding(boolean b) throws IOException {
        this.blockBuildWhenUpstreamBuilding = b;
        this.save();
    }

    @Override
    @Exported
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Restricted(value={DoNotUse.class})
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public FormValidation doCheckRetryCount(@QueryParameter String value) throws IOException, ServletException {
        if (value == null || value.trim().isEmpty()) {
            return FormValidation.ok();
        }
        if (!value.matches("[0-9]*")) {
            return FormValidation.error("Invalid retry count");
        }
        return FormValidation.ok();
    }

    @Override
    public boolean supportsMakeDisabled() {
        return this instanceof TopLevelItem;
    }

    public void disable() throws IOException {
        this.makeDisabled(true);
    }

    public void enable() throws IOException {
        this.makeDisabled(false);
    }

    @Override
    public BallColor getIconColor() {
        if (this.isDisabled()) {
            return this.isBuilding() ? BallColor.DISABLED_ANIME : BallColor.DISABLED;
        }
        return super.getIconColor();
    }

    protected void updateTransientActions() {
        this.transientActions = this.createTransientActions();
    }

    protected List<Action> createTransientActions() {
        Vector<Action> ta = new Vector<Action>();
        for (JobProperty p : Util.fixNull(this.properties)) {
            ta.addAll(p.getJobActions(this));
        }
        for (TransientProjectActionFactory tpaf : TransientProjectActionFactory.all()) {
            try {
                ta.addAll(Util.fixNull(tpaf.createFor(this)));
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Could not load actions from " + tpaf + " for " + this, e);
            }
        }
        return ta;
    }

    public abstract DescribableList<Publisher, Descriptor<Publisher>> getPublishersList();

    @Override
    public void addProperty(JobProperty<? super P> jobProp) throws IOException {
        super.addProperty(jobProp);
        this.updateTransientActions();
    }

    public List<ProminentProjectAction> getProminentActions() {
        return this.getActions(ProminentProjectAction.class);
    }

    @Override
    @POST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.doConfigSubmit(req, rsp);
        this.updateTransientActions();
        Jenkins.get().getQueue().scheduleMaintenance();
        Jenkins.get().rebuildDependencyGraphAsync();
    }

    public boolean scheduleBuild(int quietPeriod, Cause c, Action ... actions) {
        return this.scheduleBuild2(quietPeriod, c, actions) != null;
    }

    @WithBridgeMethods(value={Future.class})
    public QueueTaskFuture<R> scheduleBuild2(int quietPeriod, Cause c, Action ... actions) {
        return this.scheduleBuild2(quietPeriod, c, Arrays.asList(actions));
    }

    @WithBridgeMethods(value={Future.class})
    public QueueTaskFuture<R> scheduleBuild2(int quietPeriod, Cause c, Collection<? extends Action> actions) {
        ArrayList<? extends Action> queueActions = new ArrayList<Action>(actions);
        if (c != null) {
            queueActions.add(new CauseAction(c));
        }
        return this.scheduleBuild2(quietPeriod, queueActions.toArray(new Action[0]));
    }

    @WithBridgeMethods(value={Future.class})
    public QueueTaskFuture<R> scheduleBuild2(int quietPeriod) {
        return this.scheduleBuild2(quietPeriod, new Cause.LegacyCodeCause());
    }

    @WithBridgeMethods(value={Future.class})
    public QueueTaskFuture<R> scheduleBuild2(int quietPeriod, Cause c) {
        return this.scheduleBuild2(quietPeriod, c, new Action[0]);
    }

    @Override
    public QueueTaskFuture<R> scheduleBuild2(int quietPeriod, Action ... actions) {
        return ParameterizedJobMixIn.ParameterizedJob.super.scheduleBuild2(quietPeriod, actions);
    }

    public boolean schedulePolling() {
        if (this.isDisabled()) {
            return false;
        }
        SCMTrigger scmt = this.getTrigger(SCMTrigger.class);
        if (scmt == null) {
            return false;
        }
        scmt.run();
        return true;
    }

    @Override
    public boolean isInQueue() {
        return Jenkins.get().getQueue().contains(this);
    }

    @Override
    public Queue.Item getQueueItem() {
        return Jenkins.get().getQueue().getItem(this);
    }

    public JDK getJDK() {
        return Jenkins.get().getJDK(this.jdk);
    }

    public void setJDK(JDK jdk) throws IOException {
        this.jdk = jdk.getName();
        this.save();
    }

    @Override
    public BuildAuthorizationToken getAuthToken() {
        return this.authToken;
    }

    public RunMap<R> _getRuns() {
        return this.buildMixIn._getRuns();
    }

    @Override
    public void removeRun(R run) {
        this.buildMixIn.removeRun(run);
    }

    @Override
    public R getBuild(String id) {
        return (R)((AbstractBuild)this.buildMixIn.getBuild(id));
    }

    @Override
    public R getBuildByNumber(int n) {
        return (R)((AbstractBuild)this.buildMixIn.getBuildByNumber(n));
    }

    @Override
    public R getFirstBuild() {
        return (R)((AbstractBuild)this.buildMixIn.getFirstBuild());
    }

    @Override
    @CheckForNull
    public R getLastBuild() {
        return (R)((AbstractBuild)this.buildMixIn.getLastBuild());
    }

    @Override
    public R getNearestBuild(int n) {
        return (R)((AbstractBuild)this.buildMixIn.getNearestBuild(n));
    }

    @Override
    public R getNearestOldBuild(int n) {
        return (R)((AbstractBuild)this.buildMixIn.getNearestOldBuild(n));
    }

    protected abstract Class<R> getBuildClass();

    protected synchronized R newBuild() throws IOException {
        return (R)((AbstractBuild)this.buildMixIn.newBuild());
    }

    protected R loadBuild(File dir) throws IOException {
        return (R)((AbstractBuild)this.buildMixIn.loadBuild(dir));
    }

    @Override
    @NonNull
    public List<Action> getActions() {
        Vector<Action> actions = new Vector<Action>(super.getActions());
        actions.addAll(this.transientActions);
        return Collections.unmodifiableList(actions);
    }

    @Override
    public Node getLastBuiltOn() {
        Run b = this.getLastBuild();
        if (b == null) {
            return null;
        }
        return ((AbstractBuild)b).getBuiltOn();
    }

    @Override
    public Object getSameNodeConstraint() {
        return this;
    }

    @Override
    public CauseOfBlockage getCauseOfBlockage() {
        AbstractProject bup;
        if (!this.isConcurrentBuild() && this.isLogUpdated()) {
            Run lastBuild = this.getLastBuild();
            if (lastBuild != null) {
                return new BlockedBecauseOfBuildInProgress(lastBuild);
            }
            LOGGER.log(Level.FINE, "The last build has been deleted during the non-concurrent cause creation. The build is not blocked anymore");
        }
        if (this.blockBuildWhenDownstreamBuilding() && (bup = this.getBuildingDownstream()) != null) {
            return new BecauseOfDownstreamBuildInProgress(bup);
        }
        if (this.blockBuildWhenUpstreamBuilding() && (bup = this.getBuildingUpstream()) != null) {
            return new BecauseOfUpstreamBuildInProgress(bup);
        }
        return null;
    }

    public AbstractProject getBuildingDownstream() {
        Set<Queue.Task> tasks = Jenkins.get().getQueue().getUnblockedTasks();
        for (Queue.BlockedItem item : Jenkins.get().getQueue().getBlockedItems()) {
            if (item.isCauseOfBlockageNull() || item.getCauseOfBlockage() instanceof BecauseOfUpstreamBuildInProgress || item.getCauseOfBlockage() instanceof BecauseOfDownstreamBuildInProgress) continue;
            tasks.add(item.task);
        }
        for (AbstractProject tup : this.getTransitiveDownstreamProjects()) {
            if (tup == this || !tup.isBuilding() && !tasks.contains(tup)) continue;
            return tup;
        }
        return null;
    }

    public AbstractProject getBuildingUpstream() {
        Set<Queue.Task> tasks = Jenkins.get().getQueue().getUnblockedTasks();
        for (Queue.BlockedItem item : Jenkins.get().getQueue().getBlockedItems()) {
            if (item.isCauseOfBlockageNull() || item.getCauseOfBlockage() instanceof BecauseOfUpstreamBuildInProgress || item.getCauseOfBlockage() instanceof BecauseOfDownstreamBuildInProgress) continue;
            tasks.add(item.task);
        }
        for (AbstractProject tup : this.getTransitiveUpstreamProjects()) {
            if (tup == this || !tup.isBuilding() && !tasks.contains(tup)) continue;
            return tup;
        }
        return null;
    }

    public List<SubTask> getSubTasks() {
        ArrayList<SubTask> r = new ArrayList<SubTask>();
        r.add(this);
        for (SubTaskContributor euc : SubTaskContributor.all()) {
            r.addAll(euc.forProject(this));
        }
        for (JobProperty p : this.properties) {
            r.addAll(p.getSubTasks());
        }
        return r;
    }

    @Override
    @CheckForNull
    public R createExecutable() throws IOException {
        if (this.isDisabled()) {
            return null;
        }
        return this.newBuild();
    }

    @Override
    public void checkAbortPermission() {
        this.checkPermission(CANCEL);
    }

    @Override
    public boolean hasAbortPermission() {
        return this.hasPermission(CANCEL);
    }

    @Deprecated
    public Resource getWorkspaceResource() {
        return new Resource(this.getFullDisplayName() + " workspace");
    }

    @Override
    public ResourceList getResourceList() {
        Set<ResourceActivity> resourceActivities = this.getResourceActivities();
        ArrayList<ResourceList> resourceLists = new ArrayList<ResourceList>(1 + resourceActivities.size());
        for (ResourceActivity activity : resourceActivities) {
            if (activity == this || activity == null) continue;
            resourceLists.add(activity.getResourceList());
        }
        return ResourceList.union(resourceLists);
    }

    protected Set<ResourceActivity> getResourceActivities() {
        return Collections.emptySet();
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        SCM scm = this.getScm();
        if (scm == null) {
            return true;
        }
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("Cannot checkout SCM, workspace is not defined");
        }
        workspace.mkdirs();
        boolean r = scm.checkout(build, launcher, workspace, listener, changelogFile);
        if (r) {
            this.calcPollingBaseline(build, launcher, listener);
        }
        return r;
    }

    private void calcPollingBaseline(AbstractBuild build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        SCMRevisionState baseline = build.getAction(SCMRevisionState.class);
        if (baseline == null) {
            try {
                baseline = this.getScm().calcRevisionsFromBuild(build, launcher, listener);
            }
            catch (AbstractMethodError e) {
                baseline = SCMRevisionState.NONE;
            }
            if (baseline != null) {
                build.addAction(baseline);
            }
        }
        this.pollingBaseline = baseline;
    }

    @Deprecated
    public boolean pollSCMChanges(TaskListener listener) {
        return this.poll(listener).hasChanges();
    }

    public PollingResult poll(TaskListener listener) {
        SCM scm = this.getScm();
        if (scm == null) {
            listener.getLogger().println(Messages.AbstractProject_NoSCM());
            return PollingResult.NO_CHANGES;
        }
        if (!this.isBuildable()) {
            listener.getLogger().println(Messages.AbstractProject_Disabled());
            return PollingResult.NO_CHANGES;
        }
        SCMDecisionHandler veto = SCMDecisionHandler.firstShouldPollVeto(this);
        if (veto != null) {
            listener.getLogger().println(Messages.AbstractProject_PollingVetoed(veto));
            return PollingResult.NO_CHANGES;
        }
        Run lb = this.getLastBuild();
        if (lb == null) {
            listener.getLogger().println(Messages.AbstractProject_NoBuilds());
            return this.isInQueue() ? PollingResult.NO_CHANGES : PollingResult.BUILD_NOW;
        }
        if (this.pollingBaseline == null) {
            AbstractBuild success = (AbstractBuild)this.getLastSuccessfulBuild();
            for (Run r = lb; r != null; r = ((AbstractBuild)r).getPreviousBuild()) {
                SCMRevisionState s = r.getAction(SCMRevisionState.class);
                if (s != null) {
                    this.pollingBaseline = s;
                    break;
                }
                if (r == success) break;
            }
        }
        try {
            SCMPollListener.fireBeforePolling(this, listener);
            PollingResult r = this._poll(listener, scm);
            SCMPollListener.firePollingSuccess(this, listener, r);
            return r;
        }
        catch (AbortException e) {
            listener.getLogger().println(e.getMessage());
            listener.fatalError(Messages.AbstractProject_Aborted());
            LOGGER.log(Level.FINE, "Polling " + this + " aborted", e);
            SCMPollListener.firePollingFailed(this, listener, e);
            return PollingResult.NO_CHANGES;
        }
        catch (IOException e) {
            Functions.printStackTrace((Throwable)e, listener.fatalError(e.getMessage()));
            SCMPollListener.firePollingFailed(this, listener, e);
            return PollingResult.NO_CHANGES;
        }
        catch (InterruptedException e) {
            Functions.printStackTrace((Throwable)e, listener.fatalError(Messages.AbstractProject_PollingABorted()));
            SCMPollListener.firePollingFailed(this, listener, e);
            return PollingResult.NO_CHANGES;
        }
        catch (Error | RuntimeException e) {
            SCMPollListener.firePollingFailed(this, listener, e);
            throw e;
        }
    }

    private PollingResult _poll(TaskListener listener, SCM scm) throws IOException, InterruptedException {
        if (scm.requiresWorkspaceForPolling()) {
            Object b = this.getSomeBuildWithExistingWorkspace();
            if (b == null) {
                b = this.getLastBuild();
            }
            FilePath ws = ((AbstractBuild)b).getWorkspace();
            WorkspaceOfflineReason workspaceOfflineReason = this.workspaceOffline(b);
            if (workspaceOfflineReason != null) {
                for (WorkspaceBrowser browser : ExtensionList.lookup(WorkspaceBrowser.class)) {
                    ws = browser.getWorkspace(this);
                    if (ws == null) continue;
                    return this.pollWithWorkspace(listener, scm, b, ws, browser.getWorkspaceList());
                }
                long running = ((Uptime)Jenkins.get().getInjector().getInstance(Uptime.class)).getUptime();
                long remaining = TimeUnit.MINUTES.toMillis(10L) - running;
                if (remaining > 0L && !Functions.getIsUnitTest()) {
                    listener.getLogger().print(Messages.AbstractProject_AwaitingWorkspaceToComeOnline(remaining / 1000L));
                    listener.getLogger().println(" (" + workspaceOfflineReason.name() + ")");
                    return PollingResult.NO_CHANGES;
                }
                if (workspaceOfflineReason.equals((Object)WorkspaceOfflineReason.all_suitable_nodes_are_offline)) {
                    listener.getLogger().print(Messages.AbstractProject_AwaitingWorkspaceToComeOnline(running / 1000L));
                    listener.getLogger().println(" (" + workspaceOfflineReason.name() + ")");
                    return PollingResult.NO_CHANGES;
                }
                Label label = this.getAssignedLabel();
                if (label != null && label.isSelfLabel()) {
                    listener.getLogger().print(Messages.AbstractProject_NoWorkspace());
                    listener.getLogger().println(" (" + workspaceOfflineReason.name() + ")");
                    return PollingResult.NO_CHANGES;
                }
                listener.getLogger().println(ws == null ? Messages.AbstractProject_WorkspaceOffline() : Messages.AbstractProject_NoWorkspace());
                if (this.isInQueue()) {
                    listener.getLogger().println(Messages.AbstractProject_AwaitingBuildForWorkspace());
                    return PollingResult.NO_CHANGES;
                }
                listener.getLogger().print(Messages.AbstractProject_NewBuildForWorkspace());
                listener.getLogger().println(" (" + workspaceOfflineReason.name() + ")");
                return PollingResult.BUILD_NOW;
            }
            WorkspaceList l = ((AbstractBuild)b).getBuiltOn().toComputer().getWorkspaceList();
            return this.pollWithWorkspace(listener, scm, b, ws, l);
        }
        LOGGER.fine("Polling SCM changes of " + this.getName());
        if (this.pollingBaseline == null) {
            this.calcPollingBaseline((AbstractBuild)this.getLastBuild(), null, listener);
        }
        PollingResult r = scm.poll(this, null, null, listener, this.pollingBaseline);
        this.pollingBaseline = r.remote;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollingResult pollWithWorkspace(TaskListener listener, SCM scm, R lb, @NonNull FilePath ws, WorkspaceList l) throws InterruptedException, IOException {
        Node node = ((AbstractBuild)lb).getBuiltOn();
        Launcher launcher = ws.createLauncher(listener).decorateByEnv(this.getEnvironment(node, listener));
        WorkspaceList.Lease lease = l.acquire(ws, !this.concurrentBuild);
        try {
            String nodeName = node != null ? node.getSelfLabel().getName() : "[node_unavailable]";
            listener.getLogger().println("Polling SCM changes on " + nodeName);
            LOGGER.fine("Polling SCM changes of " + this.getName());
            if (this.pollingBaseline == null) {
                this.calcPollingBaseline((AbstractBuild)lb, launcher, listener);
            }
            PollingResult r = scm.poll(this, launcher, ws, listener, this.pollingBaseline);
            this.pollingBaseline = r.remote;
            PollingResult pollingResult = r;
            return pollingResult;
        }
        finally {
            lease.release();
        }
    }

    private boolean isAllSuitableNodesOffline(R build) {
        Label label = this.getAssignedLabel();
        if (label != null) {
            if (label.getNodes().isEmpty()) {
                return false;
            }
            return label.isOffline();
        }
        if (this.canRoam) {
            for (Node n : Jenkins.get().getNodes()) {
                Computer c = n.toComputer();
                if (c == null || !c.isOnline() || !c.isAcceptingTasks() || n.getMode() != Node.Mode.NORMAL) continue;
                return false;
            }
            return Jenkins.get().getMode() == Node.Mode.EXCLUSIVE;
        }
        return true;
    }

    private WorkspaceOfflineReason workspaceOffline(R build) throws IOException, InterruptedException {
        FilePath ws = ((AbstractBuild)build).getWorkspace();
        Label label = this.getAssignedLabel();
        if (this.isAllSuitableNodesOffline(build)) {
            Collection<Cloud> applicableClouds = label == null ? Jenkins.get().clouds : label.getClouds();
            return applicableClouds.isEmpty() ? WorkspaceOfflineReason.all_suitable_nodes_are_offline : WorkspaceOfflineReason.use_ondemand_slave;
        }
        if (ws == null || !ws.exists()) {
            return WorkspaceOfflineReason.nonexisting_workspace;
        }
        Node builtOn = ((AbstractBuild)build).getBuiltOn();
        if (builtOn == null) {
            return WorkspaceOfflineReason.builton_node_gone;
        }
        if (builtOn.toComputer() == null) {
            return WorkspaceOfflineReason.builton_node_no_executors;
        }
        return null;
    }

    public boolean hasParticipant(User user) {
        for (Run build = this.getLastBuild(); build != null; build = ((AbstractBuild)build).getPreviousBuild()) {
            if (!build.hasParticipant(user)) continue;
            return true;
        }
        return false;
    }

    @Exported
    public SCM getScm() {
        return this.scm;
    }

    public void setScm(SCM scm) throws IOException {
        this.scm = scm;
        this.save();
    }

    public void addTrigger(Trigger<?> trigger) throws IOException {
        this.addToList(trigger, this.triggers());
    }

    public void removeTrigger(TriggerDescriptor trigger) throws IOException {
        this.removeFromList(trigger, this.triggers());
    }

    protected final synchronized <T extends Describable<T>> void addToList(T item, List<T> collection) throws IOException {
        this.removeFromList(item.getDescriptor(), collection);
        collection.add(item);
        this.save();
        this.updateTransientActions();
    }

    protected final synchronized <T extends Describable<T>> void removeFromList(Descriptor<T> item, List<T> collection) throws IOException {
        Iterator<T> iCollection = collection.iterator();
        while (iCollection.hasNext()) {
            Describable next = (Describable)iCollection.next();
            if (next.getDescriptor() != item) continue;
            iCollection.remove();
            this.save();
            this.updateTransientActions();
            return;
        }
    }

    @Override
    public Map<TriggerDescriptor, Trigger<?>> getTriggers() {
        return ((DescribableList)this.triggers()).toMap();
    }

    public <T extends Trigger> T getTrigger(Class<T> clazz) {
        for (Trigger p : this.triggers()) {
            if (!clazz.isInstance(p)) continue;
            return (T)((Trigger)clazz.cast(p));
        }
        return null;
    }

    public abstract boolean isFingerprintConfigured();

    public final List<AbstractProject> getDownstreamProjects() {
        return Jenkins.get().getDependencyGraph().getDownstream(this);
    }

    @Exported(name="downstreamProjects")
    @Restricted(value={DoNotUse.class})
    public List<AbstractProject> getDownstreamProjectsForApi() {
        ArrayList<AbstractProject> r = new ArrayList<AbstractProject>();
        for (AbstractProject p : this.getDownstreamProjects()) {
            if (!p.hasPermission(Item.READ)) continue;
            r.add(p);
        }
        return r;
    }

    public final List<AbstractProject> getUpstreamProjects() {
        return Jenkins.get().getDependencyGraph().getUpstream(this);
    }

    @Exported(name="upstreamProjects")
    @Restricted(value={DoNotUse.class})
    public List<AbstractProject> getUpstreamProjectsForApi() {
        ArrayList<AbstractProject> r = new ArrayList<AbstractProject>();
        for (AbstractProject p : this.getUpstreamProjects()) {
            if (!p.hasPermission(Item.READ)) continue;
            r.add(p);
        }
        return r;
    }

    public final List<AbstractProject> getBuildTriggerUpstreamProjects() {
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        for (AbstractProject ap : this.getUpstreamProjects()) {
            BuildTrigger buildTrigger = (BuildTrigger)ap.getPublishersList().get(BuildTrigger.class);
            if (buildTrigger == null || !buildTrigger.getChildJobs(ap).contains(this)) continue;
            result.add(ap);
        }
        return result;
    }

    public final Set<AbstractProject> getTransitiveUpstreamProjects() {
        return Jenkins.get().getDependencyGraph().getTransitiveUpstream(this);
    }

    public final Set<AbstractProject> getTransitiveDownstreamProjects() {
        return Jenkins.get().getDependencyGraph().getTransitiveDownstream(this);
    }

    public SortedMap<Integer, Fingerprint.RangeSet> getRelationship(AbstractProject that) {
        TreeMap<Integer, Fingerprint.RangeSet> r = new TreeMap<Integer, Fingerprint.RangeSet>(REVERSE_INTEGER_COMPARATOR);
        this.checkAndRecord(that, r, this.getBuilds());
        return r;
    }

    private void checkAndRecord(AbstractProject that, TreeMap<Integer, Fingerprint.RangeSet> r, Iterable<R> builds) {
        for (AbstractBuild build : builds) {
            Fingerprint.RangeSet rs = build.getDownstreamRelationship(that);
            if (rs == null || rs.isEmpty()) continue;
            int n = build.getNumber();
            Fingerprint.RangeSet value = r.get(n);
            if (value == null) {
                r.put(n, rs);
                continue;
            }
            value.add(rs);
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        ((DescribableList)this.triggers()).buildDependencyGraph(this, graph);
    }

    @Override
    protected SearchIndexBuilder makeSearchIndex() {
        return this.getParameterizedJobMixIn().extendSearchIndex(super.makeSearchIndex());
    }

    @Override
    protected HistoryWidget createHistoryWidget() {
        return this.buildMixIn.createHistoryWidget();
    }

    @Deprecated
    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.doBuild(req, rsp, TimeDuration.fromString(req.getParameter("delay")));
    }

    @Deprecated
    public int getDelay(StaplerRequest req) throws ServletException {
        String delay = req.getParameter("delay");
        if (delay == null) {
            return this.getQuietPeriod();
        }
        try {
            if (delay.endsWith("sec")) {
                delay = delay.substring(0, delay.length() - 3);
            }
            if (delay.endsWith("secs")) {
                delay = delay.substring(0, delay.length() - 4);
            }
            return Integer.parseInt(delay);
        }
        catch (NumberFormatException e) {
            throw new ServletException("Invalid delay parameter value: " + delay, (Throwable)e);
        }
    }

    @Deprecated
    public void doBuildWithParameters(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.doBuildWithParameters(req, rsp, TimeDuration.fromString(req.getParameter("delay")));
    }

    @Override
    public void doPolling(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        BuildAuthorizationToken.checkPermission(this, this.authToken, req, rsp);
        this.schedulePolling();
        rsp.sendRedirect(".");
    }

    @Override
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.makeDisabled(!json.optBoolean("enable"));
        this.jdk = json.optString("jdk", null);
        this.quietPeriod = json.optBoolean("hasCustomQuietPeriod", json.has("quiet_period")) ? Integer.valueOf(json.optInt("quiet_period")) : null;
        this.scmCheckoutRetryCount = json.optBoolean("hasCustomScmCheckoutRetryCount", json.has("scmCheckoutRetryCount")) ? Integer.valueOf(json.optInt("scmCheckoutRetryCount")) : null;
        this.blockBuildWhenDownstreamBuilding = json.optBoolean("blockBuildWhenDownstreamBuilding");
        this.blockBuildWhenUpstreamBuilding = json.optBoolean("blockBuildWhenUpstreamBuilding");
        if (req.hasParameter("customWorkspace.directory")) {
            LOGGER.log(Level.WARNING, "label assignment is using legacy 'customWorkspace.directory'");
            this.customWorkspace = Util.fixEmptyAndTrim(req.getParameter("customWorkspace.directory"));
        } else {
            this.customWorkspace = json.optBoolean("hasCustomWorkspace", json.has("customWorkspace")) ? Util.fixEmptyAndTrim(json.optString("customWorkspace")) : null;
        }
        this.scmCheckoutStrategy = json.has("scmCheckoutStrategy") ? (SCMCheckoutStrategy)req.bindJSON(SCMCheckoutStrategy.class, json.getJSONObject("scmCheckoutStrategy")) : null;
        if (json.optBoolean("hasSlaveAffinity", json.has("label"))) {
            this.assignedNode = Util.fixEmptyAndTrim(json.optString("label"));
        } else if (req.hasParameter("_.assignedLabelString")) {
            LOGGER.log(Level.WARNING, "label assignment is using legacy '_.assignedLabelString'");
            this.assignedNode = Util.fixEmptyAndTrim(req.getParameter("_.assignedLabelString"));
        } else {
            this.assignedNode = null;
        }
        this.canRoam = this.assignedNode == null;
        this.keepDependencies = json.has("keepDependencies");
        this.concurrentBuild = json.optBoolean("concurrentBuild");
        this.authToken = BuildAuthorizationToken.create(req);
        this.setScm(SCMS.parseSCM(req, this));
        for (Trigger t : this.triggers()) {
            t.stop();
        }
        this.triggers.replaceBy(this.buildDescribable(req, Trigger.for_(this)));
        for (Trigger t : this.triggers()) {
            t.start(this, true);
        }
    }

    @Deprecated
    protected final <T extends Describable<T>> List<T> buildDescribable(StaplerRequest req, List<? extends Descriptor<T>> descriptors, String prefix) throws Descriptor.FormException, ServletException {
        return this.buildDescribable(req, descriptors);
    }

    protected final <T extends Describable<T>> List<T> buildDescribable(StaplerRequest req, List<? extends Descriptor<T>> descriptors) throws Descriptor.FormException, ServletException {
        JSONObject data = req.getSubmittedForm();
        Vector<T> r = new Vector<T>();
        for (Descriptor<T> d : descriptors) {
            String safeName = d.getJsonSafeClassName();
            if (req.getParameter(safeName) == null) continue;
            T instance = d.newInstance(req, data.getJSONObject(safeName));
            r.add(instance);
        }
        return r;
    }

    public DirectoryBrowserSupport doWs(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        this.checkPermission(Item.WORKSPACE);
        FilePath ws = this.getSomeWorkspace();
        if (ws == null || !ws.exists()) {
            req.getView((Object)this, "noWorkspace.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return null;
        }
        Computer c = ws.toComputer();
        String title = c == null ? Messages.AbstractProject_WorkspaceTitle(this.getDisplayName()) : Messages.AbstractProject_WorkspaceTitleOnComputer(this.getDisplayName(), c.getDisplayName());
        return new DirectoryBrowserSupport((ModelObject)this, ws, title, "folder.png", true);
    }

    @RequirePOST
    public HttpResponse doDoWipeOutWorkspace() throws IOException, ServletException, InterruptedException {
        FilePath ws;
        this.checkPermission(Functions.isWipeOutPermissionEnabled() ? WIPEOUT : BUILD);
        R b = this.getSomeBuildWithWorkspace();
        FilePath filePath = ws = b != null ? ((AbstractBuild)b).getWorkspace() : null;
        if (ws != null && this.getScm().processWorkspaceBeforeDeletion(this, ws, ((AbstractBuild)b).getBuiltOn())) {
            ws.deleteRecursive();
            for (WorkspaceListener wl : WorkspaceListener.all()) {
                wl.afterDelete(this);
            }
            return new HttpRedirect(".");
        }
        return new ForwardToView((Object)this, "wipeOutWorkspaceBlocked.jelly");
    }

    @CheckForNull
    public static AbstractProject findNearest(String name) {
        return AbstractProject.findNearest(name, Jenkins.get());
    }

    @CheckForNull
    public static AbstractProject findNearest(String name, ItemGroup context) {
        return Items.findNearest(AbstractProject.class, name, context);
    }

    @CLIResolver
    public static AbstractProject resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Job name") String name) throws CmdLineException {
        AbstractProject item = Jenkins.get().getItemByFullName(name, AbstractProject.class);
        if (item == null) {
            AbstractProject project = AbstractProject.findNearest(name);
            throw new CmdLineException(null, project == null ? Messages.AbstractItem_NoSuchJobExistsWithoutSuggestion(name) : Messages.AbstractItem_NoSuchJobExists(name, project.getFullName()));
        }
        return item;
    }

    public String getCustomWorkspace() {
        return this.customWorkspace;
    }

    public void setCustomWorkspace(String customWorkspace) throws IOException {
        this.customWorkspace = Util.fixEmptyAndTrim(customWorkspace);
        this.save();
    }

    @Deprecated
    public static abstract class LabelValidator
    implements ExtensionPoint {
        @NonNull
        public abstract FormValidation check(@NonNull AbstractProject<?, ?> var1, @NonNull Label var2);

        @NonNull
        public FormValidation checkItem(@NonNull Item item, @NonNull Label label) {
            if (item instanceof AbstractProject) {
                return this.check((AbstractProject)item, label);
            }
            return FormValidation.ok();
        }
    }

    public static abstract class AbstractProjectDescriptor
    extends TopLevelItemDescriptor {
        @Override
        public boolean isApplicable(Descriptor descriptor) {
            return true;
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckAssignedLabelString(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            LOGGER.log(Level.WARNING, "checking label via legacy '_.assignedLabelString'");
            return this.doCheckLabel(project, value);
        }

        public FormValidation doCheckLabel(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            return LabelExpression.validate(value, project);
        }

        @Deprecated
        @NonNull
        public static FormValidation validateLabelExpression(String value, @CheckForNull AbstractProject<?, ?> project) {
            return LabelExpression.validate(value, project);
        }

        public FormValidation doCheckCustomWorkspace(@QueryParameter String customWorkspace) {
            if (Util.fixEmptyAndTrim(customWorkspace) == null) {
                return FormValidation.error(Messages.AbstractProject_CustomWorkspaceEmpty());
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteUpstreamProjects(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            Collection jobs = Jenkins.get().getItems(j -> j instanceof Job && j.getFullName().startsWith(value));
            for (TopLevelItem job : jobs) {
                candidates.add(job.getFullName());
            }
            return candidates;
        }

        @Restricted(value={DoNotUse.class})
        public AutoCompletionCandidates doAutoCompleteAssignedLabelString(@QueryParameter String value) {
            LOGGER.log(Level.WARNING, "autocompleting label via legacy '_.assignedLabelString'");
            return this.doAutoCompleteLabel(value);
        }

        public AutoCompletionCandidates doAutoCompleteLabel(@QueryParameter String value) {
            return LabelExpression.autoComplete(value);
        }

        public List<SCMCheckoutStrategyDescriptor> getApplicableSCMCheckoutStrategyDescriptors(AbstractProject p) {
            return SCMCheckoutStrategyDescriptor._for(p);
        }
    }

    static enum WorkspaceOfflineReason {
        nonexisting_workspace,
        builton_node_gone,
        builton_node_no_executors,
        all_suitable_nodes_are_offline,
        use_ondemand_slave;

    }

    public static class BecauseOfUpstreamBuildInProgress
    extends CauseOfBlockage {
        public final AbstractProject<?, ?> up;

        public BecauseOfUpstreamBuildInProgress(AbstractProject<?, ?> up) {
            this.up = up;
        }

        @Override
        public String getShortDescription() {
            return Messages.AbstractProject_UpstreamBuildInProgress(this.up.getName());
        }
    }

    public static class BecauseOfDownstreamBuildInProgress
    extends CauseOfBlockage {
        public final AbstractProject<?, ?> up;

        public BecauseOfDownstreamBuildInProgress(AbstractProject<?, ?> up) {
            this.up = up;
        }

        @Override
        public String getShortDescription() {
            return Messages.AbstractProject_DownstreamBuildInProgress(this.up.getName());
        }
    }

    @Deprecated
    public static class BecauseOfBuildInProgress
    extends BlockedBecauseOfBuildInProgress {
        public BecauseOfBuildInProgress(@NonNull AbstractBuild<?, ?> build) {
            super(build);
        }
    }
}

