/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.security.Permission;
import java.util.List;
import jenkins.management.Badge;
import jenkins.management.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

@Extension(ordinal=2.147483247E9)
@Symbol(value={"plugins"})
public class PluginsLink
extends ManagementLink {
    @Override
    public String getIconFileName() {
        return "plugin.svg";
    }

    @Override
    public String getDisplayName() {
        return Messages.PluginsLink_DisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.PluginsLink_Description();
    }

    @Override
    public String getUrlName() {
        return "pluginManager";
    }

    @Override
    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Override
    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    @Override
    public Badge getBadge() {
        UpdateCenter updateCenter = Jenkins.get().getUpdateCenter();
        if (!updateCenter.isSiteDataReady()) {
            return null;
        }
        List<UpdateSite.Plugin> plugins = updateCenter.getUpdates();
        int size = plugins.size();
        if (size > 0) {
            StringBuilder tooltip = new StringBuilder();
            Badge.Severity severity = Badge.Severity.WARNING;
            int securityFixSize = (int)plugins.stream().filter(plugin -> plugin.fixesSecurityVulnerabilities()).count();
            int incompatibleSize = (int)plugins.stream().filter(plugin -> !plugin.isCompatibleWithInstalledVersion()).count();
            if (size > 1) {
                tooltip.append(Messages.PluginsLink_updatesAvailable(size));
            } else {
                tooltip.append(Messages.PluginsLink_updateAvailable());
            }
            switch (incompatibleSize) {
                case 0: {
                    break;
                }
                case 1: {
                    tooltip.append("\n").append(Messages.PluginsLink_incompatibleUpdateAvailable());
                    break;
                }
                default: {
                    tooltip.append("\n").append(Messages.PluginsLink_incompatibleUpdatesAvailable(incompatibleSize));
                }
            }
            switch (securityFixSize) {
                case 0: {
                    break;
                }
                case 1: {
                    tooltip.append("\n").append(Messages.PluginsLink_securityUpdateAvailable());
                    severity = Badge.Severity.DANGER;
                    break;
                }
                default: {
                    tooltip.append("\n").append(Messages.PluginsLink_securityUpdatesAvailable(securityFixSize));
                    severity = Badge.Severity.DANGER;
                }
            }
            return new Badge(Integer.toString(size), tooltip.toString(), severity);
        }
        return null;
    }
}

