/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.bind;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class Bound
implements HttpResponse {
    public abstract void release();

    public abstract String getURL();

    public abstract Object getTarget();

    public final String getProxyScript() {
        StringBuilder buf = new StringBuilder("makeStaplerProxy('").append(this.getURL()).append("','").append(WebApp.getCurrent().getCrumbIssuer().issueCrumb()).append("',[");
        boolean first = true;
        for (Method m : this.getTarget().getClass().getMethods()) {
            Collection<String> names;
            if (m.getName().startsWith("js")) {
                names = Set.of(Bound.camelize(m.getName().substring(2)));
            } else {
                JavaScriptMethod a = m.getAnnotation(JavaScriptMethod.class);
                if (a == null) continue;
                names = Arrays.asList(a.name());
                if (names.isEmpty()) {
                    names = Set.of(m.getName());
                }
            }
            for (String n : names) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append('\'').append(n).append('\'');
            }
        }
        buf.append("])");
        return buf.toString();
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

