/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.io.Writer;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.JSONDataWriter;
import org.kohsuke.stapler.export.PythonDataWriter;
import org.kohsuke.stapler.export.RubyDataWriter;
import org.kohsuke.stapler.export.XMLDataWriter;

public enum Flavor {
    JSON("application/json;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new JSONDataWriter(w, config);
        }
    }
    ,
    JSONP("application/javascript;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new JSONDataWriter(w, config);
        }
    }
    ,
    PYTHON("text/x-python;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new PythonDataWriter(w, config);
        }
    }
    ,
    RUBY("text/x-ruby;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new RubyDataWriter(w, config);
        }
    }
    ,
    XML("application/xml;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new XMLDataWriter(bean, w, config);
        }
    };

    public final String contentType;

    private Flavor(String contentType) {
        this.contentType = contentType;
    }

    public DataWriter createDataWriter(Object bean, StaplerResponse rsp) throws IOException {
        return this.createDataWriter(bean, rsp.getWriter());
    }

    public DataWriter createDataWriter(Object bean, Writer w) throws IOException {
        return this.createDataWriter(bean, w, new ExportConfig().withFlavor(this));
    }

    public abstract DataWriter createDataWriter(Object var1, Writer var2, ExportConfig var3) throws IOException;
}

