/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.lifecycle.ExitLifecycle;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.lifecycle.SolarisSMFLifecycle;
import hudson.lifecycle.SystemdLifecycle;
import hudson.lifecycle.UnixLifecycle;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FileUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Lifecycle
implements ExtensionPoint {
    private static Lifecycle INSTANCE = null;
    private static final Logger LOGGER = Logger.getLogger(Lifecycle.class.getName());

    @NonNull
    public static synchronized Lifecycle get() {
        if (INSTANCE == null) {
            Lifecycle instance;
            String p = SystemProperties.getString("hudson.lifecycle");
            if (p != null) {
                try {
                    ClassLoader cl = Jenkins.get().getPluginManager().uberClassLoader;
                    instance = (Lifecycle)cl.loadClass(p).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    NoSuchMethodError x = new NoSuchMethodError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (InstantiationException e) {
                    InstantiationError x = new InstantiationError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (IllegalAccessException e) {
                    IllegalAccessError x = new IllegalAccessError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.FINE, e, () -> "Failed to load " + p + " so will try again later");
                    instance = new PlaceholderLifecycle();
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof IOException) {
                        throw new UncheckedIOException((IOException)t);
                    }
                    if (t instanceof Exception) {
                        throw new RuntimeException(t);
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new Error(e);
                }
            } else if (Functions.isWindows()) {
                instance = new Lifecycle(){

                    @Override
                    public void verifyRestartable() throws RestartNotSupportedException {
                        throw new RestartNotSupportedException("Default Windows lifecycle does not support restart.");
                    }
                };
            } else if (System.getenv("SMF_FMRI") != null && System.getenv("SMF_RESTARTER") != null) {
                instance = new SolarisSMFLifecycle();
            } else if (System.getenv("NOTIFY_SOCKET") != null) {
                instance = new SystemdLifecycle();
            } else {
                try {
                    instance = new UnixLifecycle();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Failed to install embedded lifecycle implementation", t);
                    instance = new Lifecycle(){

                        @Override
                        public void verifyRestartable() throws RestartNotSupportedException {
                            throw new RestartNotSupportedException("Failed to install embedded lifecycle implementation, so cannot restart: " + t, t);
                        }
                    };
                }
            }
            assert (instance != null);
            INSTANCE = instance;
        }
        return INSTANCE;
    }

    public File getHudsonWar() {
        String war = SystemProperties.getString("executable-war");
        if (war != null && new File(war).exists()) {
            return new File(war);
        }
        return null;
    }

    public void rewriteHudsonWar(File by) throws IOException {
        File dest = this.getHudsonWar();
        if (dest == null) {
            throw new IOException("jenkins.war location is not known.");
        }
        File bak = new File(dest.getPath() + ".bak");
        if (!by.equals(bak)) {
            FileUtils.copyFile((File)dest, (File)bak);
        }
        FileUtils.copyFile((File)by, (File)dest);
        if (by.equals(bak)) {
            Files.deleteIfExists(Util.fileToPath(bak));
        }
    }

    public boolean canRewriteHudsonWar() {
        File f = this.getHudsonWar();
        if (f == null || !f.canWrite()) {
            return false;
        }
        File parent = f.getParentFile();
        return parent != null && parent.canWrite();
    }

    public void restart() throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void verifyRestartable() throws RestartNotSupportedException {
        if (!Util.isOverridden(Lifecycle.class, this.getClass(), "restart", new Class[0])) {
            throw new RestartNotSupportedException("Restart is not supported in this running mode (" + this.getClass().getName() + ").");
        }
    }

    public boolean canRestart() {
        try {
            this.verifyRestartable();
            return true;
        }
        catch (RestartNotSupportedException e) {
            return false;
        }
    }

    public void onReady() {
        LOGGER.log(Level.INFO, "Jenkins is fully up and running");
    }

    public void onReload(@NonNull String user, @CheckForNull String remoteAddr) {
        if (remoteAddr != null) {
            LOGGER.log(Level.INFO, "Reloading Jenkins as requested by {0} from {1}", new Object[]{user, remoteAddr});
        } else {
            LOGGER.log(Level.INFO, "Reloading Jenkins as requested by {0}", user);
        }
    }

    public void onStop(@NonNull String user, @CheckForNull String remoteAddr) {
        if (remoteAddr != null) {
            LOGGER.log(Level.INFO, "Stopping Jenkins as requested by {0} from {1}", new Object[]{user, remoteAddr});
        } else {
            LOGGER.log(Level.INFO, "Stopping Jenkins as requested by {0}", user);
        }
    }

    public void onExtendTimeout(long timeout, @NonNull TimeUnit unit) {
    }

    public void onStatusUpdate(String status) {
        LOGGER.log(Level.INFO, status);
    }

    @Restricted(value={Beta.class})
    public boolean supportsDynamicLoad() {
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PlaceholderLifecycle
    extends ExitLifecycle {
        @Initializer(after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
        public static synchronized void replacePlaceholder() {
            if (PlaceholderLifecycle.get() instanceof PlaceholderLifecycle) {
                String p = SystemProperties.getString("hudson.lifecycle");
                try {
                    INSTANCE = (Lifecycle)Jenkins.get().getPluginManager().uberClassLoader.loadClass(p).getConstructor(new Class[0]).newInstance(new Object[0]);
                    LOGGER.fine(() -> "Updated to " + INSTANCE);
                }
                catch (Exception | LinkageError x) {
                    LOGGER.log(Level.WARNING, x, () -> "Failed to load " + p + "; using fallback exit lifecycle");
                }
            }
        }
    }
}

