/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Items;
import hudson.model.LoadStatistics;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TopLevelItem;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelExpression;
import hudson.model.labels.LabelExpressionLexer;
import hudson.model.labels.LabelExpressionParser;
import hudson.model.labels.LabelOperatorPrecedence;
import hudson.model.labels.LabelVisitor;
import hudson.model.queue.SubTask;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.QuotedStringTokenizer;
import hudson.util.VariableResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.util.antlr.JenkinsANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class Label
extends Actionable
implements Comparable<Label>,
ModelObjectWithChildren {
    @NonNull
    protected final transient String name;
    private volatile transient Set<Node> nodes;
    private volatile transient Set<Cloud> clouds;
    private volatile transient int tiedJobsCount;
    @Exported
    @NonNull
    public final transient LoadStatistics loadStatistics;
    @NonNull
    public final transient NodeProvisioner nodeProvisioner;
    private static final LabelVisitor<Void, Set<LabelAtom>> ATOM_COLLECTOR = new LabelVisitor<Void, Set<LabelAtom>>(){

        @Override
        public Void onAtom(LabelAtom a, Set<LabelAtom> param) {
            param.add(a);
            return null;
        }

        @Override
        public Void onParen(LabelExpression.Paren p, Set<LabelAtom> param) {
            return p.base.accept(this, param);
        }

        @Override
        public Void onNot(LabelExpression.Not p, Set<LabelAtom> param) {
            return p.base.accept(this, param);
        }

        @Override
        public Void onAnd(LabelExpression.And p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        @Override
        public Void onOr(LabelExpression.Or p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        @Override
        public Void onIff(LabelExpression.Iff p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        @Override
        public Void onImplies(LabelExpression.Implies p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        private Void onBinary(LabelExpression.Binary b, Set<LabelAtom> param) {
            b.lhs.accept(this, param);
            b.rhs.accept(this, param);
            return null;
        }
    };

    protected Label(@NonNull String name) {
        this.name = name;
        this.loadStatistics = new LoadStatistics(0, 0){

            @Override
            public int computeIdleExecutors() {
                return Label.this.getIdleExecutors();
            }

            @Override
            public int computeTotalExecutors() {
                return Label.this.getTotalExecutors();
            }

            @Override
            public int computeQueueLength() {
                return Jenkins.get().getQueue().countBuildableItemsFor(Label.this);
            }

            protected Set<Node> getNodes() {
                return Label.this.getNodes();
            }

            @Override
            protected boolean matches(Queue.Item item, SubTask subTask) {
                Label l = item.getAssignedLabelFor(subTask);
                return l != null && Label.this.matches(l.name);
            }
        };
        this.nodeProvisioner = new NodeProvisioner(this, this.loadStatistics);
    }

    @Exported(visibility=2)
    @NonNull
    public final String getName() {
        return this.getDisplayName();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.name;
    }

    public abstract String getExpression();

    public String getUrl() {
        return "label/" + Util.rawEncode(this.name) + "/";
    }

    @Override
    public String getSearchUrl() {
        return this.getUrl();
    }

    public boolean isAtom() {
        return false;
    }

    public abstract boolean matches(VariableResolver<Boolean> var1);

    public final boolean matches(final Collection<LabelAtom> labels) {
        return this.matches(new VariableResolver<Boolean>(){

            @Override
            public Boolean resolve(String name) {
                for (LabelAtom a : labels) {
                    if (!a.getName().equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public final boolean matches(Node n) {
        return this.matches(n.getAssignedLabels());
    }

    public boolean isSelfLabel() {
        Set<Node> nodes = this.getNodes();
        return nodes.size() == 1 && nodes.iterator().next().getSelfLabel().equals(this);
    }

    @Exported
    public Set<Node> getNodes() {
        Set<Node> nodes = this.nodes;
        if (nodes != null) {
            return nodes;
        }
        HashSet<Node> r = new HashSet<Node>();
        Jenkins h = Jenkins.get();
        if (this.matches(h)) {
            r.add(h);
        }
        for (Node n : h.getNodes()) {
            if (!this.matches(n)) continue;
            r.add(n);
        }
        this.nodes = Collections.unmodifiableSet(r);
        return this.nodes;
    }

    @Restricted(value={DoNotUse.class})
    public Set<Node> getSortedNodes() {
        TreeSet<Node> r = new TreeSet<Node>(new NodeSorter());
        r.addAll(this.getNodes());
        return r;
    }

    @Exported
    public Set<Cloud> getClouds() {
        if (this.clouds == null) {
            HashSet<Cloud> r = new HashSet<Cloud>();
            Jenkins h = Jenkins.get();
            for (Cloud c : h.clouds) {
                if (!c.canProvision(this)) continue;
                r.add(c);
            }
            this.clouds = Collections.unmodifiableSet(r);
        }
        return this.clouds;
    }

    public boolean isAssignable() {
        for (Node n : this.getNodes()) {
            if (n.getNumExecutors() <= 0) continue;
            return true;
        }
        return !this.getClouds().isEmpty();
    }

    public int getTotalConfiguredExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            r += n.getNumExecutors();
        }
        return r;
    }

    @Exported
    public int getTotalExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || !c.isOnline()) continue;
            r += c.countExecutors();
        }
        return r;
    }

    @Exported
    public int getBusyExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || !c.isOnline()) continue;
            r += c.countBusy();
        }
        return r;
    }

    @Exported
    public int getIdleExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || !c.isOnline() && !c.isConnecting() || !c.isAcceptingTasks()) continue;
            r += c.countIdle();
        }
        return r;
    }

    @Exported
    public boolean isOffline() {
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || c.isOffline()) continue;
            return false;
        }
        return true;
    }

    @Exported
    public String getDescription() {
        Set<Node> nodes = this.getNodes();
        if (nodes.isEmpty()) {
            Set<Cloud> clouds = this.getClouds();
            if (clouds.isEmpty()) {
                return Messages.Label_InvalidLabel();
            }
            return Messages.Label_ProvisionedFrom(this.toString(clouds));
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next().getNodeDescription();
        }
        return Messages.Label_GroupOf(this.toString(nodes));
    }

    private String toString(Collection<? extends ModelObject> model) {
        boolean first = true;
        StringBuilder buf = new StringBuilder();
        for (ModelObject modelObject : model) {
            if (buf.length() > 80) {
                buf.append(",...");
                break;
            }
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(modelObject.getDisplayName());
        }
        return buf.toString();
    }

    @Exported
    public List<AbstractProject> getTiedJobs() {
        return StreamSupport.stream(Jenkins.get().allItems(AbstractProject.class, i -> i instanceof TopLevelItem && this.equals(i.getAssignedLabel())).spliterator(), true).sorted(Items.BY_FULL_NAME).collect(Collectors.toList());
    }

    public int getTiedJobCount() {
        if (this.tiedJobsCount != -1) {
            return this.tiedJobsCount;
        }
        try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
            int result = 0;
            for (AbstractProject ignored : Jenkins.get().allItems(AbstractProject.class, p -> this.matches(p.getAssignedLabelString()))) {
                ++result;
            }
            int n = this.tiedJobsCount = result;
            return n;
        }
    }

    public boolean contains(Node node) {
        return this.getNodes().contains(node);
    }

    public boolean isEmpty() {
        return this.getNodes().isEmpty() && this.getClouds().isEmpty();
    }

    void reset() {
        this.nodes = null;
        this.clouds = null;
        this.tiedJobsCount = -1;
    }

    public Api getApi() {
        return new Api(this);
    }

    public abstract <V, P> V accept(LabelVisitor<V, P> var1, P var2);

    public Set<LabelAtom> listAtoms() {
        HashSet<LabelAtom> r = new HashSet<LabelAtom>();
        this.accept(ATOM_COLLECTOR, r);
        return r;
    }

    public Label and(Label rhs) {
        return new LabelExpression.And(this, rhs);
    }

    public Label or(Label rhs) {
        return new LabelExpression.Or(this, rhs);
    }

    public Label iff(Label rhs) {
        return new LabelExpression.Iff(this, rhs);
    }

    public Label implies(Label rhs) {
        return new LabelExpression.Implies(this, rhs);
    }

    public Label not() {
        return new LabelExpression.Not(this);
    }

    public Label paren() {
        return new LabelExpression.Paren(this);
    }

    public abstract LabelOperatorPrecedence precedence();

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.matches(((Label)that).name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public final int compareTo(Label that) {
        return this.name.compareTo(that.name);
    }

    private boolean matches(String name) {
        return this.name.equals(name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (Node node : this.getNodes()) {
            menu.add(node);
        }
        return menu;
    }

    @NonNull
    public static Set<LabelAtom> parse(@CheckForNull String labels) {
        TreeSet<LabelAtom> r = new TreeSet<LabelAtom>();
        if ((labels = Util.fixNull(labels)).length() > 0) {
            Jenkins j = Jenkins.get();
            LabelAtom labelAtom = j.tryGetLabelAtom(labels);
            if (labelAtom == null) {
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(labels);
                while (tokenizer.hasMoreTokens()) {
                    r.add(j.getLabelAtom(tokenizer.nextToken()));
                }
            } else {
                r.add(labelAtom);
            }
        }
        return r;
    }

    @CheckForNull
    public static Label get(String l) {
        return Jenkins.get().getLabel(l);
    }

    public static Label parseExpression(@NonNull String labelExpression) {
        LabelExpressionLexer lexer = new LabelExpressionLexer((CharStream)CharStreams.fromString((String)labelExpression));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new JenkinsANTLRErrorListener());
        LabelExpressionParser parser = new LabelExpressionParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new JenkinsANTLRErrorListener());
        return parser.expr().l;
    }

    private static class NodeSorter
    implements Comparator<Node>,
    Serializable {
        private static final long serialVersionUID = -7368519598046684532L;

        private NodeSorter() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1 instanceof Jenkins ? -1 : (o2 instanceof Jenkins ? 1 : o1.getNodeName().compareTo(o2.getNodeName()));
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return Label.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Label src = (Label)source;
            writer.setValue(src.getExpression());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Jenkins.get().getLabel(reader.getValue());
        }
    }
}

