/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.remoting.AsyncFutureImpl;
import hudson.remoting.Callable;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.security.AccessControlled;
import hudson.util.Messages;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.ScriptListener;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public final class RemotingDiagnostics {
    public static Map<Object, Object> getSystemProperties(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return Map.of("N/A", "N/A");
        }
        return (Map)channel.call((Callable)new GetSystemProperties());
    }

    public static Map<String, String> getThreadDump(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return Map.of("N/A", "N/A");
        }
        return (Map)channel.call((Callable)new GetThreadDump());
    }

    public static Future<Map<String, String>> getThreadDumpAsync(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return new AsyncFutureImpl(Map.of("N/A", "offline"));
        }
        return channel.callAsync((Callable)new GetThreadDump());
    }

    public static String executeGroovy(String script, @NonNull VirtualChannel channel) throws IOException, InterruptedException {
        String correlationId = UUID.randomUUID().toString();
        String context = channel.toString();
        ScriptListener.fireScriptExecution(script, new Binding(), RemotingDiagnostics.class, context, correlationId, User.current());
        String output = (String)channel.call((Callable)new Script(script));
        ScriptListener.fireScriptOutput(output, RemotingDiagnostics.class, context, correlationId, User.current());
        return output;
    }

    public static FilePath getHeapDump(VirtualChannel channel) throws IOException, InterruptedException {
        return (FilePath)channel.call((Callable)new GetHeapDump());
    }

    private static final class GetSystemProperties
    extends MasterToSlaveCallable<Map<Object, Object>, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetSystemProperties() {
        }

        public Map<Object, Object> call() {
            return new TreeMap<Object, Object>(System.getProperties());
        }
    }

    private static final class GetThreadDump
    extends MasterToSlaveCallable<Map<String, String>, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetThreadDump() {
        }

        public Map<String, String> call() {
            LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
            ThreadInfo[] data = Functions.getThreadInfos();
            Functions.ThreadGroupMap map = Functions.sortThreadsAndGetGroupMap(data);
            for (ThreadInfo ti : data) {
                r.put(ti.getThreadName(), Functions.dumpThreadInfo(ti, map));
            }
            return r;
        }
    }

    private static final class Script
    extends MasterToSlaveCallable<String, RuntimeException>
    implements DelegatingCallable<String, RuntimeException> {
        private final String script;
        private transient ClassLoader cl;
        private static final long serialVersionUID = 1L;

        private Script(String script) {
            this.script = script;
            this.cl = this.getClassLoader();
        }

        public ClassLoader getClassLoader() {
            return Jenkins.get().getPluginManager().uberClassLoader;
        }

        @SuppressFBWarnings(value={"GROOVY_SHELL"}, justification="script console is a feature, not a bug")
        public String call() throws RuntimeException {
            if (this.cl == null) {
                this.cl = Thread.currentThread().getContextClassLoader();
            }
            CompilerConfiguration cc = new CompilerConfiguration();
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            GroovyShell shell = new GroovyShell(this.cl, new Binding(), cc);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            shell.setVariable("out", (Object)pw);
            try {
                Object output = shell.evaluate(this.script);
                if (output != null) {
                    pw.println("Result: " + output);
                }
            }
            catch (Throwable t) {
                Functions.printStackTrace(t, pw);
            }
            return out.toString();
        }
    }

    private static class GetHeapDump
    extends MasterToSlaveCallable<FilePath, IOException> {
        private static final long serialVersionUID = 1L;

        private GetHeapDump() {
        }

        public FilePath call() throws IOException {
            File hprof = File.createTempFile("hudson-heapdump", ".hprof");
            Files.delete(Util.fileToPath(hprof));
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                server.invoke(new ObjectName("com.sun.management:type=HotSpotDiagnostic"), "dumpHeap", new Object[]{hprof.getAbsolutePath(), true}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
                return new FilePath(hprof);
            }
            catch (JMException e) {
                throw new IOException(e);
            }
        }
    }

    public static class HeapDump
    implements ModelObject {
        private final AccessControlled owner;
        private final VirtualChannel channel;

        public HeapDump(AccessControlled owner, VirtualChannel channel) {
            this.owner = owner;
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WebMethod(name={"heapdump.hprof"})
        @RequirePOST
        public void doHeapDump(StaplerRequest req, StaplerResponse rsp) throws IOException, InterruptedException {
            this.owner.checkPermission(Jenkins.ADMINISTER);
            rsp.setContentType("application/octet-stream");
            FilePath dump = this.obtain();
            try {
                dump.copyTo(rsp.getCompressedOutputStream((HttpServletRequest)req));
            }
            finally {
                dump.delete();
            }
        }

        @Restricted(value={DoNotUse.class})
        public AccessControlled getContext() {
            if (this.owner instanceof ModelObject) {
                return this.owner;
            }
            return Jenkins.get();
        }

        public FilePath obtain() throws IOException, InterruptedException {
            return RemotingDiagnostics.getHeapDump(this.channel);
        }

        @Override
        public String getDisplayName() {
            return Messages.HeapDump_DisplayName();
        }
    }
}

