/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.MemoryReductionUtil;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.TokenizedPath;
import org.apache.tools.ant.types.selectors.TokenizedPattern;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class VirtualFile
implements Comparable<VirtualFile>,
Serializable {
    @NonNull
    public abstract String getName();

    @NonNull
    public abstract URI toURI();

    public abstract VirtualFile getParent();

    public abstract boolean isDirectory() throws IOException;

    public abstract boolean isFile() throws IOException;

    @CheckForNull
    public String readLink() throws IOException {
        return null;
    }

    public abstract boolean exists() throws IOException;

    @NonNull
    public abstract VirtualFile[] list() throws IOException;

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public VirtualFile[] list(OpenOption ... openOptions) throws IOException {
        return this.list();
    }

    @Restricted(value={NoExternalUse.class})
    public boolean supportsQuickRecursiveListing() {
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasSymlink(OpenOption ... openOptions) throws IOException {
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<VirtualFile> listOnlyDescendants() throws IOException {
        VirtualFile[] children = this.list();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile child : children) {
            if (!child.isDescendant("")) continue;
            result.add(child);
        }
        return result;
    }

    @Deprecated
    @NonNull
    public String[] list(String glob) throws IOException {
        return this.list(glob.replace('\\', '/'), null, true).toArray(MemoryReductionUtil.EMPTY_STRING_ARRAY);
    }

    @NonNull
    public Collection<String> list(@NonNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes) throws IOException {
        return this.list(includes, excludes, useDefaultExcludes, new OpenOption[0]);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Collection<String> list(@NonNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes, OpenOption ... openOptions) throws IOException {
        Collection<String> r = this.run(new CollectFiles(this));
        List<TokenizedPattern> includePatterns = this.patterns(includes);
        List<TokenizedPattern> excludePatterns = this.patterns(excludes);
        if (useDefaultExcludes) {
            for (String patt : DirectoryScanner.getDefaultExcludes()) {
                excludePatterns.add(new TokenizedPattern(patt.replace('/', File.separatorChar)));
            }
        }
        return r.stream().filter(p -> {
            TokenizedPath path = new TokenizedPath(p.replace('/', File.separatorChar));
            return includePatterns.stream().anyMatch(patt -> patt.matchPath(path, true)) && excludePatterns.stream().noneMatch(patt -> patt.matchPath(path, true));
        }).collect(Collectors.toSet());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean containsSymLinkChild(OpenOption ... openOptions) throws IOException {
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean containsTmpDirChild(OpenOption ... openOptions) throws IOException {
        for (VirtualFile child : this.list()) {
            if (!child.isDirectory() || !FilePath.isTmpDir(child.getName(), openOptions)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private List<TokenizedPattern> patterns(String patts) {
        ArrayList<TokenizedPattern> r = new ArrayList<TokenizedPattern>();
        if (patts != null) {
            for (String string : patts.split(",")) {
                void var6_6;
                if (string.endsWith("/")) {
                    String string2 = string + "**";
                }
                r.add(new TokenizedPattern(var6_6.replace('/', File.separatorChar)));
            }
        }
        return r;
    }

    public int zip(OutputStream outputStream, String includes, String excludes, boolean useDefaultExcludes, String prefix, OpenOption ... openOptions) throws IOException {
        String correctPrefix = prefix == null || prefix.isBlank() ? "" : Util.ensureEndsWith(prefix, "/");
        Collection<String> files = this.list(includes, excludes, useDefaultExcludes, openOptions);
        try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
            zos.setEncoding(System.getProperty("file.encoding"));
            for (String relativePath : files) {
                VirtualFile virtualFile = this.child(relativePath);
                this.sendOneZipEntry(zos, virtualFile, relativePath, correctPrefix, openOptions);
            }
        }
        return files.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOneZipEntry(ZipOutputStream zos, VirtualFile vf, String relativePath, String prefix, OpenOption ... openOptions) throws IOException {
        String onlyForwardRelativePath = relativePath.replace('\\', '/');
        String zipEntryName = prefix + onlyForwardRelativePath;
        ZipEntry e = new ZipEntry(zipEntryName);
        e.setTime(vf.lastModified());
        zos.putNextEntry(e);
        try (InputStream in = vf.open(openOptions);){
            IOUtils.copy((InputStream)in, (OutputStream)zos);
        }
        finally {
            zos.closeEntry();
        }
    }

    @NonNull
    public abstract VirtualFile child(@NonNull String var1);

    public abstract long length() throws IOException;

    public abstract long lastModified() throws IOException;

    public int mode() throws IOException {
        return -1;
    }

    public abstract boolean canRead() throws IOException;

    public abstract InputStream open() throws IOException;

    @Restricted(value={NoExternalUse.class})
    public InputStream open(OpenOption ... openOptions) throws IOException {
        return this.open();
    }

    @Override
    public final int compareTo(VirtualFile o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public final boolean equals(Object obj) {
        return obj instanceof VirtualFile && this.toURI().equals(((VirtualFile)obj).toURI());
    }

    public final int hashCode() {
        return this.toURI().hashCode();
    }

    public final String toString() {
        return this.toURI().toString();
    }

    public <V> V run(Callable<V, IOException> callable) throws IOException {
        return (V)callable.call();
    }

    @CheckForNull
    public URL toExternalURL() throws IOException {
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean supportIsDescendant() {
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isDescendant(String childRelativePath) throws IOException {
        return false;
    }

    String joinWithForwardSlashes(Collection<String> relativePath) {
        return String.join((CharSequence)"/", relativePath) + "/";
    }

    public static VirtualFile forFile(File f) {
        return new FileVF(f, f);
    }

    public static VirtualFile forFilePath(FilePath f) {
        return new FilePathVF(f, f);
    }

    private static final class CollectFiles
    extends MasterToSlaveCallable<Collection<String>, IOException> {
        private static final long serialVersionUID = 1L;
        private final VirtualFile root;

        CollectFiles(VirtualFile root) {
            this.root = root;
        }

        public Collection<String> call() throws IOException {
            ArrayList<String> r = new ArrayList<String>();
            CollectFiles.collectFiles(this.root, r, "");
            return r;
        }

        private static void collectFiles(VirtualFile d, Collection<String> names, String prefix) throws IOException {
            for (VirtualFile child : d.list()) {
                if (child.isFile()) {
                    names.add(prefix + child.getName());
                    continue;
                }
                if (!child.isDirectory()) continue;
                CollectFiles.collectFiles(child, names, prefix + child.getName() + "/");
            }
        }
    }

    private static final class FileVF
    extends VirtualFile {
        private final File f;
        private final File root;
        private boolean cacheDescendant = false;

        FileVF(File f, File root) {
            this.f = f;
            this.root = root;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public URI toURI() {
            return this.f.toURI();
        }

        @Override
        public VirtualFile getParent() {
            return new FileVF(this.f.getParentFile(), this.root);
        }

        @Override
        public boolean isDirectory() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.isDirectory();
        }

        @Override
        public boolean isFile() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.isFile();
        }

        @Override
        public boolean exists() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.exists();
        }

        @Override
        public String readLink() throws IOException {
            if (this.isIllegalSymlink()) {
                return null;
            }
            return Util.resolveSymlink(this.f);
        }

        @Override
        public VirtualFile[] list() throws IOException {
            if (this.isIllegalSymlink()) {
                return new VirtualFile[0];
            }
            File[] kids = this.f.listFiles();
            if (kids == null) {
                return new VirtualFile[0];
            }
            VirtualFile[] vfs = new VirtualFile[kids.length];
            for (int i = 0; i < kids.length; ++i) {
                vfs[i] = new FileVF(kids[i], this.root);
            }
            return vfs;
        }

        @Override
        @NonNull
        public VirtualFile[] list(OpenOption ... openOptions) throws IOException {
            String rootPath = this.determineRootPath();
            File[] kids = this.f.listFiles();
            ArrayList<FileVF> contents = new ArrayList<FileVF>(kids.length);
            for (File child : kids) {
                if (FilePath.isSymlink(child, rootPath, openOptions) || FilePath.isTmpDir(child, rootPath, openOptions)) continue;
                contents.add(new FileVF(child, this.root));
            }
            return contents.toArray(new VirtualFile[0]);
        }

        @Override
        public boolean supportsQuickRecursiveListing() {
            return true;
        }

        @Override
        @NonNull
        public List<VirtualFile> listOnlyDescendants() throws IOException {
            if (this.isIllegalSymlink()) {
                return Collections.emptyList();
            }
            File[] children = this.f.listFiles();
            if (children == null) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> legalChildren = new ArrayList<VirtualFile>(children.length);
            for (File child : children) {
                if (!this.isDescendant(child.getName())) continue;
                FileVF legalChild = new FileVF(child, this.root);
                legalChild.cacheDescendant = true;
                legalChildren.add(legalChild);
            }
            return legalChildren;
        }

        @Override
        public Collection<String> list(String includes, String excludes, boolean useDefaultExcludes) throws IOException {
            if (this.isIllegalSymlink()) {
                return Collections.emptySet();
            }
            return new Scanner(includes, excludes, useDefaultExcludes).invoke(this.f, null);
        }

        @Override
        public Collection<String> list(String includes, String excludes, boolean useDefaultExcludes, OpenOption ... openOptions) throws IOException {
            String rootPath = this.determineRootPath();
            return new Scanner(includes, excludes, useDefaultExcludes, rootPath, openOptions).invoke(this.f, null);
        }

        @Override
        public int zip(OutputStream outputStream, String includes, String excludes, boolean useDefaultExcludes, String prefix, OpenOption ... openOptions) throws IOException {
            String rootPath = this.determineRootPath();
            DirScanner.Glob globScanner = new DirScanner.Glob(includes, excludes, useDefaultExcludes, openOptions);
            ArchiverFactory archiverFactory = prefix == null ? ArchiverFactory.ZIP : ArchiverFactory.createZipWithPrefix(prefix, openOptions);
            try (Archiver archiver = archiverFactory.create(outputStream);){
                globScanner.scan(this.f, FilePath.ignoringTmpDirs(FilePath.ignoringSymlinks(archiver, rootPath, openOptions), rootPath, openOptions));
                int n = archiver.countEntries();
                return n;
            }
        }

        @Override
        public boolean hasSymlink(OpenOption ... openOptions) throws IOException {
            String rootPath = this.determineRootPath();
            return FilePath.isSymlink(this.f, rootPath, openOptions);
        }

        @Override
        public VirtualFile child(String name) {
            return new FileVF(new File(this.f, name), this.root);
        }

        @Override
        public long length() throws IOException {
            if (this.isIllegalSymlink()) {
                return 0L;
            }
            return this.f.length();
        }

        @Override
        public int mode() throws IOException {
            if (this.isIllegalSymlink()) {
                return -1;
            }
            return hudson.util.IOUtils.mode(this.f);
        }

        @Override
        public long lastModified() throws IOException {
            if (this.isIllegalSymlink()) {
                return 0L;
            }
            return this.f.lastModified();
        }

        @Override
        public boolean canRead() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.canRead();
        }

        @Override
        public InputStream open() throws IOException {
            if (this.isIllegalSymlink()) {
                throw new FileNotFoundException(this.f.getPath());
            }
            try {
                return Files.newInputStream(this.f.toPath(), new OpenOption[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }

        @Override
        public InputStream open(OpenOption ... openOptions) throws IOException {
            String rootPath = this.determineRootPath();
            InputStream inputStream = FilePath.newInputStreamDenyingSymlinkAsNeeded(this.f, rootPath, openOptions);
            return inputStream;
        }

        @Override
        public boolean containsSymLinkChild(OpenOption ... openOptions) {
            File[] kids;
            String rootPath = this.determineRootPath();
            for (File child : kids = this.f.listFiles()) {
                if (!FilePath.isSymlink(child, rootPath, openOptions)) continue;
                return true;
            }
            return false;
        }

        private String determineRootPath() {
            return this.root == null ? null : this.root.getPath();
        }

        private boolean isIllegalSymlink() {
            try {
                String myPath = this.f.toPath().toRealPath(new LinkOption[0]).toString();
                String rootPath = this.root.toPath().toRealPath(new LinkOption[0]).toString();
                if (!myPath.equals(rootPath) && !myPath.startsWith(rootPath + File.separatorChar)) {
                    return true;
                }
            }
            catch (IOException x) {
                Logger.getLogger(VirtualFile.class.getName()).log(Level.FINE, "could not determine symlink status of " + this.f, x);
            }
            catch (InvalidPathException x2) {
                Logger.getLogger(VirtualFile.class.getName()).log(Level.FINE, "Could not convert " + this.f + " to path", x2);
            }
            return false;
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public boolean supportIsDescendant() {
            return true;
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public boolean isDescendant(String potentialChildRelativePath) throws IOException {
            if (potentialChildRelativePath.isEmpty() && this.cacheDescendant) {
                return true;
            }
            if (new File(potentialChildRelativePath).isAbsolute()) {
                throw new IllegalArgumentException("Only a relative path is supported, the given path is absolute: " + potentialChildRelativePath);
            }
            File directChild = new File(this.f, potentialChildRelativePath);
            if (directChild.getParentFile().equals(this.f) && !Util.isSymlink(directChild)) {
                return true;
            }
            FilePath root = new FilePath(this.root);
            String relativePath = this.computeRelativePathToRoot();
            try {
                boolean isDescendant = root.isDescendant(relativePath + potentialChildRelativePath);
                if (isDescendant && potentialChildRelativePath.isEmpty()) {
                    this.cacheDescendant = true;
                }
                return isDescendant;
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        private String computeRelativePathToRoot() {
            if (this.root.equals(this.f)) {
                return "";
            }
            ArrayDeque<String> relativePath = new ArrayDeque<String>();
            for (File current = this.f; current != null && !current.equals(this.root); current = current.getParentFile()) {
                relativePath.addFirst(current.getName());
            }
            return this.joinWithForwardSlashes(relativePath);
        }
    }

    private static final class FilePathVF
    extends VirtualFile {
        private final FilePath f;
        private final FilePath root;
        private boolean cacheDescendant = false;

        FilePathVF(FilePath f, FilePath root) {
            this.f = f;
            this.root = root;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public URI toURI() {
            try {
                return this.f.toURI();
            }
            catch (Exception x) {
                return URI.create(this.f.getRemote());
            }
        }

        @Override
        public VirtualFile getParent() {
            return this.f.getParent().toVirtualFile();
        }

        @Override
        public boolean isDirectory() throws IOException {
            try {
                return this.f.isDirectory();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean isFile() throws IOException {
            return this.exists() && !this.isDirectory();
        }

        @Override
        public boolean exists() throws IOException {
            try {
                return this.f.exists();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public String readLink() throws IOException {
            try {
                return this.f.readLink();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public VirtualFile[] list() throws IOException {
            try {
                List<FilePath> kids = this.f.list();
                return this.convertChildrenToVirtualFile(kids);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        private VirtualFile[] convertChildrenToVirtualFile(List<FilePath> kids) {
            VirtualFile[] vfs = new VirtualFile[kids.size()];
            for (int i = 0; i < vfs.length; ++i) {
                vfs[i] = new FilePathVF(kids.get(i), this.root);
            }
            return vfs;
        }

        @Override
        @NonNull
        public VirtualFile[] list(OpenOption ... openOptions) throws IOException {
            try {
                List<FilePath> kids = this.f.list(this.root, openOptions);
                return this.convertChildrenToVirtualFile(kids);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean containsSymLinkChild(OpenOption ... openOptions) throws IOException {
            try {
                return this.f.containsSymlink(this.root, openOptions);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean hasSymlink(OpenOption ... openOptions) throws IOException {
            try {
                return this.f.hasSymlink(this.root, openOptions);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean supportsQuickRecursiveListing() {
            return this.f.getChannel() == FilePath.localChannel;
        }

        @Override
        @NonNull
        public List<VirtualFile> listOnlyDescendants() throws IOException {
            try {
                if (!this.isDescendant("")) {
                    return Collections.emptyList();
                }
                List<FilePath> children = this.f.list();
                ArrayList<VirtualFile> legalChildren = new ArrayList<VirtualFile>(children.size());
                for (FilePath child : children) {
                    if (!this.isDescendant(child.getName())) continue;
                    FilePathVF legalChild = new FilePathVF(child, this.root);
                    legalChild.cacheDescendant = true;
                    legalChildren.add(legalChild);
                }
                return legalChildren;
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public Collection<String> list(String includes, String excludes, boolean useDefaultExcludes) throws IOException {
            try {
                return this.f.act(new Scanner(includes, excludes, useDefaultExcludes));
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public Collection<String> list(String includes, String excludes, boolean useDefaultExcludes, OpenOption ... openOptions) throws IOException {
            try {
                String rootPath = this.root == null ? null : this.root.getRemote();
                return this.f.act(new Scanner(includes, excludes, useDefaultExcludes, rootPath, openOptions));
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public int zip(OutputStream outputStream, String includes, String excludes, boolean useDefaultExcludes, String prefix, OpenOption ... openOptions) throws IOException {
            try {
                String rootPath = this.root == null ? null : this.root.getRemote();
                DirScanner.Glob globScanner = new DirScanner.Glob(includes, excludes, useDefaultExcludes, openOptions);
                return this.f.zip(outputStream, globScanner, rootPath, prefix, openOptions);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public VirtualFile child(String name) {
            return new FilePathVF(this.f.child(name), this.root);
        }

        @Override
        public long length() throws IOException {
            try {
                return this.f.length();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public int mode() throws IOException {
            try {
                return this.f.mode();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public long lastModified() throws IOException {
            try {
                return this.f.lastModified();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean canRead() throws IOException {
            try {
                return this.f.act(new Readable());
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public InputStream open() throws IOException {
            try {
                return this.f.read();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public InputStream open(OpenOption ... openOptions) throws IOException {
            try {
                return this.f.read(this.root, openOptions);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public <V> V run(Callable<V, IOException> callable) throws IOException {
            try {
                return this.f.act(callable);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public boolean supportIsDescendant() {
            return true;
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public boolean isDescendant(String potentialChildRelativePath) throws IOException {
            if (potentialChildRelativePath.isEmpty() && this.cacheDescendant) {
                return true;
            }
            if (new File(potentialChildRelativePath).isAbsolute()) {
                throw new IllegalArgumentException("Only a relative path is supported, the given path is absolute: " + potentialChildRelativePath);
            }
            FilePath directChild = this.f.child(potentialChildRelativePath);
            if (Objects.equals(directChild.getParent(), this.f)) {
                try {
                    boolean isDirectDescendant = this.f.isDescendant(potentialChildRelativePath);
                    if (isDirectDescendant) {
                        return true;
                    }
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            String relativePath = this.computeRelativePathToRoot();
            try {
                return this.root.isDescendant(relativePath + potentialChildRelativePath);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        private String computeRelativePathToRoot() {
            if (this.root.equals(this.f)) {
                return "";
            }
            ArrayDeque<String> relativePath = new ArrayDeque<String>();
            for (FilePath current = this.f; current != null && !current.equals(this.root); current = current.getParent()) {
                relativePath.addFirst(current.getName());
            }
            return this.joinWithForwardSlashes(relativePath);
        }
    }

    private static final class Readable
    extends MasterToSlaveFileCallable<Boolean> {
        private Readable() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return f.canRead();
        }
    }

    private static final class Scanner
    extends MasterToSlaveFileCallable<List<String>> {
        private final String includes;
        private final String excludes;
        private final boolean useDefaultExcludes;
        private final String verificationRoot;
        private OpenOption[] openOptions;

        Scanner(String includes, String excludes, boolean useDefaultExcludes, String verificationRoot, OpenOption ... openOptions) {
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
            this.verificationRoot = verificationRoot;
            this.openOptions = openOptions;
        }

        Scanner(String includes, String excludes, boolean useDefaultExcludes) {
            this(includes, excludes, useDefaultExcludes, null, new OpenOption[0]);
        }

        @Override
        public List<String> invoke(File f, VirtualChannel channel) throws IOException {
            if (this.includes.isEmpty()) {
                return Collections.emptyList();
            }
            final ArrayList<String> paths = new ArrayList<String>();
            FileVisitor listing = new FileVisitor(){

                @Override
                public void visit(File f, String relativePath) {
                    paths.add(relativePath.replace('\\', '/'));
                }
            };
            DirScanner.Glob globScanner = new DirScanner.Glob(this.includes, this.excludes, this.useDefaultExcludes, this.openOptions);
            globScanner.scan(f, FilePath.ignoringTmpDirs(FilePath.ignoringSymlinks(listing, this.verificationRoot, this.openOptions), this.verificationRoot, this.openOptions));
            return paths;
        }
    }
}

