/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class CrumbIssuer {
    public static final CrumbIssuer DEFAULT = new CrumbIssuer(){

        @Override
        public String issueCrumb(StaplerRequest request) {
            HttpSession s = request.getSession();
            String v = (String)s.getAttribute(ATTRIBUTE_NAME);
            if (v != null) {
                return v;
            }
            v = UUID.randomUUID().toString();
            s.setAttribute(ATTRIBUTE_NAME, (Object)v);
            return v;
        }
    };
    private static final String ATTRIBUTE_NAME = CrumbIssuer.class.getName();

    public abstract String issueCrumb(StaplerRequest var1);

    public final String issueCrumb() {
        return this.issueCrumb(Stapler.getCurrentRequest());
    }

    public HttpResponse doCrumb() {
        return HttpResponses.text(this.issueCrumb());
    }

    public void validateCrumb(StaplerRequest request, String submittedCrumb) {
        if (!this.issueCrumb(request).equals(submittedCrumb)) {
            throw new SecurityException("Request failed to pass the crumb test (try clearing your cookies)");
        }
    }
}

