/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.ServletException;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class HttpResponses {
    private static final HttpResponseException FORWARD_TO_PREVIOUS_PAGE = new HttpResponseException(){

        @Override
        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            rsp.forwardToPreviousPage(req);
        }
    };

    public static HttpResponseException ok() {
        return HttpResponses.status(200);
    }

    public static HttpResponseException notFound() {
        return HttpResponses.status(404);
    }

    public static HttpResponseException forbidden() {
        return HttpResponses.status(403);
    }

    public static HttpResponseException status(final int code) {
        return new HttpResponseException(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(code);
            }
        };
    }

    public static HttpResponseException error(int code, String errorMessage) {
        return HttpResponses.error(code, new Exception(errorMessage));
    }

    public static HttpResponseException error(Throwable cause) {
        return HttpResponses.error(500, cause);
    }

    public static HttpResponseException error(final int code, final Throwable cause) {
        ErrorCustomizer handler;
        HttpResponseException responseException = null;
        Iterator<ErrorCustomizer> iterator = ServiceLoader.load(ErrorCustomizer.class).iterator();
        while (iterator.hasNext() && (responseException = (handler = iterator.next()).handleError(code, cause)) == null) {
        }
        if (responseException == null) {
            responseException = new HttpResponseException(cause){

                @Override
                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    rsp.setStatus(code);
                    rsp.setContentType("text/plain;charset=UTF-8");
                    PrintWriter w = new PrintWriter(rsp.getWriter());
                    cause.printStackTrace(w);
                    w.close();
                }
            };
        }
        return responseException;
    }

    public static HttpResponseException errorWithoutStack(final int code, final String errorMessage) {
        return new HttpResponseException(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.sendError(code, errorMessage);
            }
        };
    }

    public static HttpResponseException redirectViaContextPath(String relative) {
        return HttpResponses.redirectViaContextPath(302, relative);
    }

    public static HttpResponseException redirectViaContextPath(final int statusCode, final String relative) {
        return new HttpResponseException(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                StringBuilder sb = new StringBuilder(req.getContextPath());
                if (!relative.startsWith("/")) {
                    sb.append('/');
                }
                sb.append(relative);
                rsp.sendRedirect(statusCode, sb.toString());
            }
        };
    }

    public static HttpRedirect redirectTo(String url) {
        return new HttpRedirect(url);
    }

    public static HttpRedirect redirectTo(int statusCode, String url) {
        return new HttpRedirect(statusCode, url);
    }

    public static HttpResponse redirectToDot() {
        return HttpRedirect.DOT;
    }

    public static HttpResponseException redirectToContextRoot() {
        return HttpResponses.redirectViaContextPath("");
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="TODO needs triage")
    public static HttpResponseException forwardToPreviousPage() {
        return FORWARD_TO_PREVIOUS_PAGE;
    }

    public static HttpResponse staticResource(URL resource) {
        return HttpResponses.staticResource(resource, 0L);
    }

    public static HttpResponse staticResource(final URL resource, final long expiration) {
        return new HttpResponse(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.serveFile(req, resource, expiration);
            }
        };
    }

    @Deprecated
    public static HttpResponse html(final String literalHtml) {
        return new HttpResponse(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().println(literalHtml);
            }
        };
    }

    public static HttpResponse literalHtml(final String text) {
        return new HttpResponse(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setContentType("text/html;charset=UTF-8");
                PrintWriter pw = rsp.getWriter();
                pw.print(text);
                pw.flush();
            }
        };
    }

    @Deprecated
    public static HttpResponse plainText(final String plainText) {
        return new HttpResponse(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setContentType("text/plain;charset=UTF-8");
                rsp.getWriter().println(plainText);
            }
        };
    }

    public static HttpResponse text(final String text) {
        return new HttpResponse(){

            @Override
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setContentType("text/plain;charset=UTF-8");
                PrintWriter pw = rsp.getWriter();
                pw.print(text);
                pw.flush();
            }
        };
    }

    public static ForwardToView forwardToView(Object it, String view) {
        return new ForwardToView(it, view);
    }

    public static ForwardToView forwardToView(Class clazz, String view) {
        return new ForwardToView(clazz, view);
    }

    public static abstract class HttpResponseException
    extends RuntimeException
    implements HttpResponse {
        public HttpResponseException() {
        }

        public HttpResponseException(String message) {
            super(message);
        }

        public HttpResponseException(String message, Throwable cause) {
            super(message, cause);
        }

        public HttpResponseException(Throwable cause) {
            super(cause);
        }
    }

    public static interface ErrorCustomizer {
        @CheckForNull
        public HttpResponseException handleError(int var1, Throwable var2);
    }
}

