/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD})
@InterceptorAnnotation(value=Processor.class)
public @interface LimitedTo {
    public String value();

    public static class Processor
    extends Interceptor {
        private String role;

        @Override
        public void setTarget(Function target) {
            this.role = target.getAnnotation(LimitedTo.class).value();
            super.setTarget(target);
        }

        @Override
        public Object invoke(StaplerRequest request, StaplerResponse response, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            if (request.isUserInRole(this.role)) {
                return this.target.invoke(request, response, instance, arguments);
            }
            throw new IllegalAccessException("Needs to be in role " + this.role);
        }
    }
}

