/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LocaleDrivenResourceProvider {
    private static List<LocaleDrivenResourceProvider> localeDrivenResourceProviders;
    private static final Logger LOGGER;

    @CheckForNull
    public abstract URL lookup(@NonNull String var1);

    private static synchronized List<LocaleDrivenResourceProvider> getLocaleDrivenResourceProviders() {
        if (localeDrivenResourceProviders == null) {
            localeDrivenResourceProviders = new ArrayList<LocaleDrivenResourceProvider>();
            for (LocaleDrivenResourceProvider provider : ServiceLoader.load(LocaleDrivenResourceProvider.class)) {
                localeDrivenResourceProviders.add(provider);
                LOGGER.fine(() -> "Registered LocaleDrivenResourceProvider: " + provider);
            }
        }
        return localeDrivenResourceProviders;
    }

    static URL lookupResource(String path) {
        for (LocaleDrivenResourceProvider provider : LocaleDrivenResourceProvider.getLocaleDrivenResourceProviders()) {
            try {
                URL url = provider.lookup(path);
                if (url == null) continue;
                return url;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to look up URL for " + path + " from " + provider, e);
            }
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(LocaleDrivenResourceProvider.class.getName());
    }
}

