/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.kohsuke.stapler.ReflectionUtils;

class UnionAnnotatedElement
implements AnnotatedElement {
    private final List<? extends AnnotatedElement> sources;

    UnionAnnotatedElement(List<? extends AnnotatedElement> sources) {
        this.sources = sources;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        for (AnnotatedElement annotatedElement : this.sources) {
            if (!annotatedElement.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (AnnotatedElement annotatedElement : this.sources) {
            T a = annotatedElement.getAnnotation(annotationClass);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] a = null;
        for (AnnotatedElement annotatedElement : this.sources) {
            Annotation[] next = annotatedElement.getAnnotations();
            if (a == null) {
                a = next;
                continue;
            }
            a = ReflectionUtils.union(a, next);
        }
        return a;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.sources.get(this.sources.size() - 1).getAnnotations();
    }
}

