/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.RootAction;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.JenkinsLintGlobalConfiguration;
import org.jenkins.ci.plugins.jenkinslint.graph.JenkinsLintGraph;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractAction;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceCheck;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceSlaveCheck;
import org.jenkins.ci.plugins.jenkinslint.model.Job;
import org.jenkins.ci.plugins.jenkinslint.model.Lint;
import org.jenkins.ci.plugins.jenkinslint.model.Slave;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
@Extension
public final class JenkinsLintAction
extends AbstractAction
implements RootAction {
    private static final Logger LOG = Logger.getLogger(JenkinsLintAction.class.getName());
    private Hashtable<String, Job> jobSet = new Hashtable();
    private Hashtable<String, Slave> slaveSet = new Hashtable();

    @Override
    public void getData() throws IOException {
        LOG.log(Level.FINE, "getData()");
        this.getJobSet().clear();
        this.getSlaveSet().clear();
        this.reloadCheckList();
        this.reloadSlaveCheckList();
        JenkinsLintGlobalConfiguration config = JenkinsLintGlobalConfiguration.get();
        for (hudson.model.Job item : Jenkins.getInstance().getAllItems(hudson.model.Job.class)) {
            if (config.isLintDisabledJobEnabled() || this.isJobEnabled(item)) {
                if (!item.getParent().getClass().getSimpleName().equals("MatrixProject")) {
                    LOG.log(Level.FINER, "queryChecks " + item.getName());
                    Job newJob = new Job(item.getName(), item.getUrl());
                    for (InterfaceCheck interfaceCheck : this.getCheckList()) {
                        LOG.log(Level.FINER, interfaceCheck.getName() + " " + item.getName() + " " + interfaceCheck.executeCheck((Item)item));
                        newJob.addLint(new Lint(interfaceCheck.getName(), interfaceCheck.executeCheck((Item)item), interfaceCheck.isIgnored(item.getDescription()), interfaceCheck.isEnabled()));
                    }
                    this.getJobSet().put(item.getName(), newJob);
                    LOG.log(Level.FINER, newJob.toString());
                    continue;
                }
                LOG.log(Level.FINER, "Excluded MatrixConfiguration " + item.getName());
                continue;
            }
            LOG.log(Level.FINER, "Excluded Job '" + item.getName() + "' since isLintDisabledJobEnabled has been disabled");
        }
        for (Node node : Jenkins.getInstance().getNodes()) {
            LOG.log(Level.FINER, "querySlaveCheck " + node.getDisplayName());
            Slave newSlave = new Slave(node.getNodeName(), node.getSearchUrl());
            for (InterfaceSlaveCheck interfaceSlaveCheck : this.getSlaveCheckList()) {
                boolean status = interfaceSlaveCheck.executeCheck(node);
                LOG.log(Level.FINER, interfaceSlaveCheck.getName() + " " + node.getDisplayName() + " " + status);
                newSlave.addLint(new Lint(interfaceSlaveCheck.getName(), status, interfaceSlaveCheck.isIgnored(node.getNodeDescription()), interfaceSlaveCheck.isEnabled()));
            }
            this.getSlaveSet().put(newSlave.getName(), newSlave);
            LOG.log(Level.FINER, newSlave.toString());
        }
    }

    @Exported
    public synchronized Hashtable<String, Job> getJobSet() {
        return this.jobSet;
    }

    @Exported
    public synchronized Hashtable<String, InterfaceCheck> getCheckSet() {
        Hashtable<String, InterfaceCheck> temp = new Hashtable<String, InterfaceCheck>();
        for (InterfaceCheck check : this.getCheckList()) {
            temp.put(check.getName(), check);
        }
        return temp;
    }

    @Exported
    public synchronized Hashtable<String, Slave> getSlaveSet() {
        return this.slaveSet;
    }

    @Exported
    public synchronized Hashtable<String, InterfaceSlaveCheck> getSlaveCheckSet() {
        Hashtable<String, InterfaceSlaveCheck> temp = new Hashtable<String, InterfaceSlaveCheck>();
        for (InterfaceSlaveCheck check : this.getSlaveCheckList()) {
            temp.put(check.getName(), check);
        }
        return temp;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)JenkinsLintGraph.createChart(this.getJobSet().elements()), (int)1024, (int)768);
    }

    public void doPieGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)JenkinsLintGraph.createPieChart(this.getJobSet().elements()), (int)512, (int)384);
    }

    public void doSeverityPieGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)JenkinsLintGraph.createSeverityPieChart(this.getJobSet().elements(), this.getCheckSet()), (int)512, (int)384);
    }

    private boolean isJobEnabled(hudson.model.Job job) {
        boolean enabled = true;
        if (job != null) {
            try {
                Object isDisabled = job.getClass().getMethod("isDisabled", null).invoke((Object)job, new Object[0]);
                if (isDisabled instanceof Boolean) {
                    enabled = (Boolean)isDisabled == false;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return enabled;
    }
}

