/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.TransientActionFactory;
import org.jenkins.ci.plugins.jenkinslint.JenkinsLintGlobalConfiguration;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractAction;
import org.jenkins.ci.plugins.jenkinslint.model.InterfaceCheck;
import org.jenkins.ci.plugins.jenkinslint.model.Job;
import org.jenkins.ci.plugins.jenkinslint.model.Lint;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class JobLintAction
extends AbstractAction
implements Action {
    private static final Logger LOG = Logger.getLogger(JobLintAction.class.getName());
    private hudson.model.Job project;
    private Job job;

    public boolean isProjectEnabled() {
        boolean enabled = true;
        if (this.project != null) {
            try {
                Object isDisabled = this.project.getClass().getMethod("isDisabled", null).invoke((Object)this.project, new Object[0]);
                if (isDisabled instanceof Boolean) {
                    enabled = (Boolean)isDisabled == false;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception " + e.getMessage(), e.getCause());
            }
        }
        return enabled;
    }

    public static boolean isDisabled() {
        return !JenkinsLintGlobalConfiguration.get().isJobActionEnabled();
    }

    public static boolean isLintDisabledJobEnabled() {
        return JenkinsLintGlobalConfiguration.get().isLintDisabledJobEnabled();
    }

    public JobLintAction(hudson.model.Job project) {
        this.project = project;
    }

    public final hudson.model.Job<?, ?> getProject() {
        return this.project;
    }

    @Exported
    public Job getJob() {
        return this.job;
    }

    @Override
    public void getData() throws IOException {
        this.reloadCheckList();
        if (this.isProjectEnabled() || JobLintAction.isLintDisabledJobEnabled()) {
            this.job = new Job(this.project.getName(), this.project.getUrl());
            for (InterfaceCheck checker : this.getCheckList()) {
                this.job.addLint(new Lint(checker.getName(), checker.executeCheck((Item)this.project), checker.isIgnored(this.project.getDescription()), checker.isEnabled()));
            }
            LOG.log(Level.FINE, this.job.getLintList().toString());
        }
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<hudson.model.Job> {
        public Class<hudson.model.Job> type() {
            return hudson.model.Job.class;
        }

        public Collection<? extends Action> createFor(hudson.model.Job target) {
            return Collections.singleton(new JobLintAction(target));
        }
    }
}

