/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.util.logging.Level;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class ArtifactChecker
extends AbstractCheck {
    public ArtifactChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.ArtifactCheckerDesc());
        this.setSeverity(Messages.ArtifactCheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        LOG.log(Level.FINE, "executeCheck " + item);
        if (item instanceof AbstractProject) {
            DescribableList publishersList = ((AbstractProject)item).getPublishersList();
            for (Publisher publisher : publishersList) {
                if (!(publisher instanceof ArtifactArchiver)) continue;
                LOG.log(Level.FINEST, "ArtifactChecker " + publisher);
                return ((ArtifactArchiver)publisher).getArtifacts() == null || ((ArtifactArchiver)publisher).getArtifacts() != null && ((ArtifactArchiver)publisher).getArtifacts().length() == 0;
            }
        }
        return false;
    }
}

