/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.model.Item;
import hudson.model.Job;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class BFAChecker
extends AbstractCheck {
    public BFAChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.BFACheckerDesc());
        this.setSeverity(Messages.BFACheckerSeverity());
    }

    @Override
    public boolean executeCheck(Item item) {
        LOG.log(Level.FINE, "executeCheck " + item);
        boolean found = false;
        if (Jenkins.getInstance().pluginManager.getPlugin("build-failure-analyzer") != null) {
            found = this.isDoNotScan(((Job)item).getProperty("com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty"));
        }
        return found;
    }

    private boolean isDoNotScan(Object property) {
        boolean status = false;
        if (property != null) {
            try {
                Object isDoNotScan = property.getClass().getMethod("isDoNotScan", null).invoke(property, new Object[0]);
                if (isDoNotScan instanceof Boolean) {
                    status = (Boolean)isDoNotScan;
                    LOG.log(Level.FINE, "isDoNotScan " + status);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                status = false;
            }
        } else {
            status = true;
        }
        return status;
    }
}

