/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jenkinslint.check;

import hudson.PluginWrapper;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.util.VersionNumber;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkins.ci.plugins.jenkinslint.check.Messages;
import org.jenkins.ci.plugins.jenkinslint.model.AbstractCheck;

public class GitRefChecker
extends AbstractCheck {
    public GitRefChecker(boolean enabled) {
        super(enabled);
        this.setDescription(Messages.GitRefCheckerDesc());
        this.setSeverity(Messages.GitRefCheckerSeverity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCheck(Item item) {
        if (item instanceof AbstractProject) {
            PluginWrapper plugin = Jenkins.getInstance().pluginManager.getPlugin("git");
            if (plugin != null && !plugin.getVersionNumber().isOlderThan(new VersionNumber("2.0"))) {
                if (((AbstractProject)item).getScm().getClass().getName().endsWith("GitSCM")) {
                    boolean status = true;
                    try {
                        Method method = ((AbstractProject)item).getScm().getClass().getMethod("getExtensions", null);
                        Object extensionsList = method.invoke((Object)((AbstractProject)item).getScm(), new Object[0]);
                        if (extensionsList instanceof AbstractList) {
                            for (Object extension : (AbstractList)extensionsList) {
                                Object reference;
                                if (!extension.getClass().getName().endsWith("CloneOption") || !((reference = extension.getClass().getMethod("getReference", null).invoke(extension, new Object[0])) instanceof String)) continue;
                                status = ((String)reference).isEmpty();
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Exception " + e.getMessage(), e.getCause());
                        status = false;
                        return status;
                    }
                    finally {
                        return status;
                    }
                }
                LOG.log(Level.FINE, "Plugin GIT hasn't been configured in this project");
                return false;
            }
            LOG.log(Level.FINE, "Plugin GIT doesn't exist");
            return false;
        }
        return false;
    }
}

